/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BDegreeDays
extends BComponent {
    public static final Property facets = BDegreeDays.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1), null);
    public static final Property baseTemperature = BDegreeDays.newProperty((int)0, (float)65.0f, null);
    public static final Property tempIn = BDegreeDays.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property minTemp = BDegreeDays.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property maxTemp = BDegreeDays.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property meanTemp = BDegreeDays.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property clgDegDays = BDegreeDays.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property clgDegDaysTotal = BDegreeDays.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property htgDegDays = BDegreeDays.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property htgDegDaysTotal = BDegreeDays.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Action resetTotals = BDegreeDays.newAction((int)0, null);
    public static final Action calculate = BDegreeDays.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDegreeDays.class);
    boolean firstTime = true;
    double tempDiff;
    int currentDay;
    int previousDay;
    Clock.Ticket ticket = null;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public float getBaseTemperature() {
        return this.getFloat(baseTemperature);
    }

    public void setBaseTemperature(float v) {
        this.setFloat(baseTemperature, v, null);
    }

    public BStatusNumeric getTempIn() {
        return (BStatusNumeric)this.get(tempIn);
    }

    public void setTempIn(BStatusNumeric v) {
        this.set(tempIn, (BValue)v, null);
    }

    public BStatusNumeric getMinTemp() {
        return (BStatusNumeric)this.get(minTemp);
    }

    public void setMinTemp(BStatusNumeric v) {
        this.set(minTemp, (BValue)v, null);
    }

    public BStatusNumeric getMaxTemp() {
        return (BStatusNumeric)this.get(maxTemp);
    }

    public void setMaxTemp(BStatusNumeric v) {
        this.set(maxTemp, (BValue)v, null);
    }

    public BStatusNumeric getMeanTemp() {
        return (BStatusNumeric)this.get(meanTemp);
    }

    public void setMeanTemp(BStatusNumeric v) {
        this.set(meanTemp, (BValue)v, null);
    }

    public BStatusNumeric getClgDegDays() {
        return (BStatusNumeric)this.get(clgDegDays);
    }

    public void setClgDegDays(BStatusNumeric v) {
        this.set(clgDegDays, (BValue)v, null);
    }

    public BStatusNumeric getClgDegDaysTotal() {
        return (BStatusNumeric)this.get(clgDegDaysTotal);
    }

    public void setClgDegDaysTotal(BStatusNumeric v) {
        this.set(clgDegDaysTotal, (BValue)v, null);
    }

    public BStatusNumeric getHtgDegDays() {
        return (BStatusNumeric)this.get(htgDegDays);
    }

    public void setHtgDegDays(BStatusNumeric v) {
        this.set(htgDegDays, (BValue)v, null);
    }

    public BStatusNumeric getHtgDegDaysTotal() {
        return (BStatusNumeric)this.get(htgDegDaysTotal);
    }

    public void setHtgDegDaysTotal(BStatusNumeric v) {
        this.set(htgDegDaysTotal, (BValue)v, null);
    }

    public void resetTotals() {
        this.invoke(resetTotals, null, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(tempIn)) {
            this.doCalculate();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)tempIn) || slot.equals((Object)meanTemp) || slot.equals((Object)maxTemp) || slot.equals((Object)minTemp) || slot.equals((Object)baseTemperature)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doResetTotals() {
        this.getHtgDegDaysTotal().setValue(0.0);
        this.getClgDegDaysTotal().setValue(0.0);
    }

    public void doCalculate() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
        this.currentDay = Clock.time().getDayOfYear();
        BStatusNumeric currentTemp = this.getTempIn();
        if (!currentTemp.getStatus().isValid()) {
            return;
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.previousDay = this.currentDay;
            this.setMinTemp((BStatusNumeric)currentTemp.newCopy());
            this.setMaxTemp((BStatusNumeric)currentTemp.newCopy());
            return;
        }
        if (currentTemp.getValue() < this.getMinTemp().getValue()) {
            this.setMinTemp((BStatusNumeric)currentTemp.newCopy());
        }
        if (currentTemp.getValue() > this.getMaxTemp().getValue()) {
            this.setMaxTemp((BStatusNumeric)currentTemp.newCopy());
        }
        if (this.currentDay != this.previousDay) {
            this.previousDay = this.currentDay;
            this.getMeanTemp().setValue((this.getMinTemp().getValue() + this.getMaxTemp().getValue()) / 2.0);
            this.tempDiff = this.getMeanTemp().getValue() - (double)this.getBaseTemperature();
            if (this.tempDiff > 0.0) {
                this.getClgDegDays().setValue(Math.abs(this.tempDiff));
                this.getHtgDegDays().setValue(0.0);
            } else {
                this.getHtgDegDays().setValue(Math.abs(this.tempDiff));
                this.getClgDegDays().setValue(0.0);
            }
            this.getHtgDegDaysTotal().setValue(this.getHtgDegDaysTotal().getValue() + this.getHtgDegDays().getValue());
            this.getClgDegDaysTotal().setValue(this.getClgDegDaysTotal().getValue() + this.getClgDegDays().getValue());
            this.setMinTemp((BStatusNumeric)currentTemp.newCopy());
            this.setMaxTemp((BStatusNumeric)currentTemp.newCopy());
        }
    }
}

