/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl;

import com.tridium.kitControl.enums.BDisableAction;
import com.tridium.kitControl.enums.BLoopAction;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLoopPoint
extends BNumericPoint {
    public static final Property loopEnable = BLoopPoint.newProperty((int)0, (BValue)new BStatusBoolean(true), null);
    public static final Property inputFacets = BLoopPoint.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property controlledVariable = BLoopPoint.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric());
    public static final Property setpoint = BLoopPoint.newProperty((int)0, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric());
    public static final Property executeTime = BLoopPoint.newProperty((int)0, (BValue)BRelTime.make((long)500L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property actualTime = BLoopPoint.newProperty((int)259, (int)0, null);
    public static final Property loopAction = BLoopPoint.newProperty((int)0, (BValue)BLoopAction.direct, null);
    public static final Property disableAction = BLoopPoint.newProperty((int)0, (BValue)BDisableAction.zero, null);
    public static final Property tuningFacets = BLoopPoint.newProperty((int)0, (BValue)BFacets.makeNumeric((int)3), null);
    public static final Property proportionalConstant = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property integralConstant = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property derivativeConstant = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property bias = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property maximumOutput = BLoopPoint.newProperty((int)0, (int)100, null);
    public static final Property minimumOutput = BLoopPoint.newProperty((int)0, (int)0, null);
    public static final Property rampTime = BLoopPoint.newProperty((int)0, (BValue)BRelTime.make((long)0L), null);
    public static final Action resetIntegral = BLoopPoint.newAction((int)0, null);
    public static final Action timerExpired = BLoopPoint.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BLoopPoint.class);
    private Clock.Ticket ticket;
    private double lastUpdateValue = Double.NaN;
    private boolean loopEnabled;
    private boolean lastStatusInhibit = false;
    private double kPkIconst;
    private double errorSum = 0.0;
    private double lastError = 0.0;
    private boolean debug = false;
    private long lastExecuteTime;
    private double kPortionalCurrent;
    private double kIntegralCurrent;
    private long rampStartTicks;
    private long rampEndTicks;
    private double rampConst;
    private BStatusNumeric pidOutput = new BStatusNumeric();
    public static long LOOP_MAX_EXECUTE_TIME = 60000L;
    public static long LOOP_MIN_EXECUTE_TIME = 100L;
    public static long LOOP_DEFAULT_EXECUTE_TIME = 500L;

    public BStatusBoolean getLoopEnable() {
        return (BStatusBoolean)this.get(loopEnable);
    }

    public void setLoopEnable(BStatusBoolean v) {
        this.set(loopEnable, (BValue)v, null);
    }

    public BFacets getInputFacets() {
        return (BFacets)this.get(inputFacets);
    }

    public void setInputFacets(BFacets v) {
        this.set(inputFacets, (BValue)v, null);
    }

    public BStatusNumeric getControlledVariable() {
        return (BStatusNumeric)this.get(controlledVariable);
    }

    public void setControlledVariable(BStatusNumeric v) {
        this.set(controlledVariable, (BValue)v, null);
    }

    public BStatusNumeric getSetpoint() {
        return (BStatusNumeric)this.get(setpoint);
    }

    public void setSetpoint(BStatusNumeric v) {
        this.set(setpoint, (BValue)v, null);
    }

    public BRelTime getExecuteTime() {
        return (BRelTime)this.get(executeTime);
    }

    public void setExecuteTime(BRelTime v) {
        this.set(executeTime, (BValue)v, null);
    }

    public int getActualTime() {
        return this.getInt(actualTime);
    }

    public void setActualTime(int v) {
        this.setInt(actualTime, v, null);
    }

    public BLoopAction getLoopAction() {
        return (BLoopAction)this.get(loopAction);
    }

    public void setLoopAction(BLoopAction v) {
        this.set(loopAction, (BValue)v, null);
    }

    public BDisableAction getDisableAction() {
        return (BDisableAction)this.get(disableAction);
    }

    public void setDisableAction(BDisableAction v) {
        this.set(disableAction, (BValue)v, null);
    }

    public BFacets getTuningFacets() {
        return (BFacets)this.get(tuningFacets);
    }

    public void setTuningFacets(BFacets v) {
        this.set(tuningFacets, (BValue)v, null);
    }

    public double getProportionalConstant() {
        return this.getDouble(proportionalConstant);
    }

    public void setProportionalConstant(double v) {
        this.setDouble(proportionalConstant, v, null);
    }

    public double getIntegralConstant() {
        return this.getDouble(integralConstant);
    }

    public void setIntegralConstant(double v) {
        this.setDouble(integralConstant, v, null);
    }

    public double getDerivativeConstant() {
        return this.getDouble(derivativeConstant);
    }

    public void setDerivativeConstant(double v) {
        this.setDouble(derivativeConstant, v, null);
    }

    public double getBias() {
        return this.getDouble(bias);
    }

    public void setBias(double v) {
        this.setDouble(bias, v, null);
    }

    public double getMaximumOutput() {
        return this.getDouble(maximumOutput);
    }

    public void setMaximumOutput(double v) {
        this.setDouble(maximumOutput, v, null);
    }

    public double getMinimumOutput() {
        return this.getDouble(minimumOutput);
    }

    public void setMinimumOutput(double v) {
        this.setDouble(minimumOutput, v, null);
    }

    public BRelTime getRampTime() {
        return (BRelTime)this.get(rampTime);
    }

    public void setRampTime(BRelTime v) {
        this.set(rampTime, (BValue)v, null);
    }

    public void resetIntegral() {
        this.invoke(resetIntegral, null, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isIntegral() {
        double kI = this.getIntegralConstant();
        return !Double.isNaN(kI) && kI != 0.0;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)controlledVariable) || slot.equals((Object)setpoint)) {
            return this.getInputFacets();
        }
        if (slot.equals((Object)proportionalConstant) || slot.equals((Object)integralConstant) || slot.equals((Object)derivativeConstant)) {
            return this.getTuningFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doResetIntegral() {
        this.clearIntegralTerms();
    }

    public void doTimerExpired() {
        if (!this.getLoopEnable().getBoolean()) {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
            this.lastExecuteTime = 0L;
        }
        this.calculatePoint();
    }

    public void started() throws Exception {
        super.started();
        this.initTimer();
        this.kPortionalCurrent = this.getProportionalConstant();
        this.kIntegralCurrent = this.getIntegralConstant();
        this.kPkIconst = this.kPortionalCurrent * this.kIntegralCurrent / 60.0;
        this.rampConst = Math.abs(this.getMaximumOutput() - this.getMinimumOutput());
        this.rampStartTicks = Clock.ticks();
        this.rampEndTicks = this.rampStartTicks + this.getRampTime().getMillis();
    }

    private void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getExecuteTime(), (Action)timerExpired, null);
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        ((BStatusNumeric)out).setStatus(this.pidOutput.getStatus());
        ((BStatusNumeric)out).setValue(this.pidOutput.getValue());
    }

    public void calculatePoint() {
        boolean currentStatusInhibit;
        this.debug = false;
        BValue debugValue = this.get("debug");
        if (debugValue instanceof BBoolean) {
            this.debug = ((BBoolean)debugValue).getBoolean();
        }
        this.loopEnabled = currentStatusInhibit = this.getLoopEnable().getBoolean();
        this.lastStatusInhibit = currentStatusInhibit;
        double kProportional = this.getProportionalConstant();
        double kIntegral = this.getIntegralConstant();
        double kDerivative = this.getDerivativeConstant();
        double maxOutput = this.getMaximumOutput();
        double minOutput = this.getMinimumOutput();
        long now = Clock.ticks();
        double setPt = this.getSetpoint().getValue();
        double controlVar = this.getControlledVariable().getValue();
        boolean fault = false;
        BDisableAction disableAction = this.getDisableAction();
        this.rampConst = Math.abs(this.getMaximumOutput() - this.getMinimumOutput());
        if (Double.isNaN(setPt) || Double.isNaN(controlVar)) {
            this.pidOutput.setStatusFault(true);
            fault = true;
        } else {
            this.pidOutput.setStatusFault(false);
        }
        if (this.lastExecuteTime == 0L) {
            this.lastExecuteTime = now;
        }
        long delta = now - this.lastExecuteTime;
        this.setActualTime((int)delta);
        double deltaSecs = (double)delta / 1000.0;
        if (!this.loopEnabled) {
            double outValue = Double.NaN;
            if (disableAction == BDisableAction.zero) {
                outValue = 0.0;
            } else if (disableAction == BDisableAction.maxValue) {
                outValue = this.getMaximumOutput();
            } else if (disableAction == BDisableAction.minValue) {
                outValue = this.getMinimumOutput();
            }
            if (!Double.isNaN(outValue)) {
                this.pidOutput.setValue(outValue);
                this.errorSum = this.getLoopAction() == BLoopAction.direct ? -(outValue / this.kPkIconst) : outValue / this.kPkIconst;
            }
            this.lastExecuteTime = 0L;
            return;
        }
        if (fault) {
            return;
        }
        double error = this.getSetpoint().getValue() - this.getControlledVariable().getValue();
        if (kIntegral != 0.0) {
            double iError = deltaSecs * error;
            this.errorSum += iError;
            this.kPkIconst = kProportional * kIntegral / 60.0;
            if (this.getLoopAction() == BLoopAction.direct) {
                if (-this.errorSum > maxOutput / this.kPkIconst) {
                    this.errorSum = -(maxOutput / this.kPkIconst);
                } else if (-this.errorSum < minOutput / this.kPkIconst) {
                    this.errorSum = -(minOutput / this.kPkIconst);
                }
            } else if (this.errorSum > maxOutput / this.kPkIconst) {
                this.errorSum = maxOutput / this.kPkIconst;
            } else if (this.errorSum < minOutput / this.kPkIconst) {
                this.errorSum = minOutput / this.kPkIconst;
            }
        }
        if (Double.isNaN(this.errorSum) || Double.isInfinite(this.errorSum)) {
            this.errorSum = 0.0;
        }
        double proportionalGain = error * kProportional;
        double integralGain = 0.0;
        integralGain = kProportional * kIntegral * this.errorSum / 60.0;
        double derivativeGain = kProportional * kDerivative * (error - this.lastError) / deltaSecs;
        this.lastError = error;
        double pv = proportionalGain + integralGain + derivativeGain;
        if (Double.isNaN(pv)) {
            return;
        }
        if (this.getLoopAction() == BLoopAction.direct) {
            pv = -pv;
        }
        if (!this.isIntegral()) {
            pv += this.getBias();
        }
        if (this.debug) {
            System.out.println("pGain: " + proportionalGain + " iGain: " + integralGain + " dGain: " + derivativeGain + "\nerrorSum: " + this.errorSum + " error: " + error + " pv: " + pv + " deltaSecs: " + deltaSecs + " out: " + this.getOut().getValue());
        }
        if (now < this.rampEndTicks) {
            double maxChange = this.rampConst * (double)delta / (double)this.getRampTime().getMillis();
            if (this.getOut().getValue() > pv) {
                double minRampOut = this.getOut().getValue() - maxChange;
                if (pv < minRampOut) {
                    this.errorSum = this.errorSum * minRampOut / pv;
                    pv = minRampOut;
                }
            } else {
                double maxRampOut = this.getOut().getValue() + maxChange;
                if (pv > maxRampOut) {
                    this.errorSum = this.errorSum * maxRampOut / pv;
                    pv = maxRampOut;
                }
            }
        }
        if (pv > maxOutput) {
            pv = maxOutput;
        } else if (pv < minOutput) {
            pv = minOutput;
        }
        this.pidOutput.setValue(pv);
        this.lastExecuteTime = now;
        this.doExecute();
    }

    private void clearIntegralTerms() {
        this.lastExecuteTime = 0L;
        this.errorSum = this.getLoopAction() == BLoopAction.direct ? -(this.getMaximumOutput() / this.kPkIconst) : this.getMinimumOutput() / this.kPkIconst;
        if (Double.isNaN(this.errorSum)) {
            this.errorSum = 0.0;
        }
        if (this.debug) {
            System.out.println("Clearing integral term...");
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(p, cx);
        if (p.equals(executeTime)) {
            if (this.getExecuteTime().getMillis() < LOOP_MIN_EXECUTE_TIME) {
                this.setExecuteTime(BRelTime.make((long)LOOP_MIN_EXECUTE_TIME));
            } else if (this.getExecuteTime().getMillis() > LOOP_MAX_EXECUTE_TIME) {
                this.setExecuteTime(BRelTime.make((long)LOOP_MAX_EXECUTE_TIME));
            }
            this.initTimer();
        } else if (p.equals(proportionalConstant)) {
            double kPnew = this.getProportionalConstant();
            if (kPnew != 0.0) {
                this.errorSum = this.errorSum * this.kPortionalCurrent / kPnew;
            }
            this.kPortionalCurrent = kPnew;
        } else if (p.equals(integralConstant)) {
            double kInew = this.getIntegralConstant();
            if (kInew != 0.0) {
                this.errorSum = this.errorSum * this.kIntegralCurrent / kInew;
            }
            this.kIntegralCurrent = kInew;
        } else if (p.equals(rampTime)) {
            this.rampConst = Math.abs(this.getMaximumOutput() - this.getMinimumOutput());
            this.rampStartTicks = Clock.ticks();
            this.rampEndTicks = this.rampStartTicks + this.getRampTime().getMillis();
        } else if (p.equals(loopEnable)) {
            if (this.getLoopEnable().getBoolean()) {
                this.rampConst = Math.abs(this.getMaximumOutput() - this.getMinimumOutput());
                this.rampStartTicks = Clock.ticks();
                this.rampEndTicks = this.rampStartTicks + this.getRampTime().getMillis();
                this.calculatePoint();
                if (this.isRunning()) {
                    this.initTimer();
                }
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                BDisableAction disableAction = this.getDisableAction();
                double outValue = Double.NaN;
                if (disableAction == BDisableAction.zero) {
                    outValue = 0.0;
                } else if (disableAction == BDisableAction.maxValue) {
                    outValue = this.getMaximumOutput();
                } else if (disableAction == BDisableAction.minValue) {
                    outValue = this.getMinimumOutput();
                }
                if (!Double.isNaN(outValue)) {
                    this.pidOutput.setValue(outValue);
                    this.errorSum = this.getLoopAction() == BLoopAction.direct ? -(outValue / this.kPkIconst) : outValue / this.kPkIconst;
                }
                this.lastExecuteTime = 0L;
                if (this.debug) {
                    System.out.println("loop disabled:  errorSum " + this.errorSum);
                    System.out.println("loop disabled:  outValue " + outValue);
                    System.out.println("loop disabled:  kPkIconst " + this.kPkIconst);
                }
            }
        }
    }
}

