/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl;

import com.tridium.kitControl.BDiscreteTotalizerAlarmAlgorithm;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BElapsedActiveTimeAlarmAlgorithm
extends BDiscreteTotalizerAlarmAlgorithm {
    public static final Property errorLimit = BElapsedActiveTimeAlarmAlgorithm.newProperty((int)0, (BValue)BRelTime.make((long)0L), null);
    public static final Type TYPE = Sys.loadType(BElapsedActiveTimeAlarmAlgorithm.class);
    private static BFacets timeFacet = BFacets.make((String)"showDate", (BIDataValue)BBoolean.make((boolean)false), (String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)false));
    private static Context timeContext = new BasicContext((Context)new BasicContext(), timeFacet);

    public BRelTime getErrorLimit() {
        return (BRelTime)this.get(errorLimit);
    }

    public void setErrorLimit(BRelTime v) {
        this.set(errorLimit, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context c) {
        BBooleanPoint point;
        if (this.isRunning() && p.equals(errorLimit) && (point = (BBooleanPoint)this.getParentPoint()) != null) {
            point.execute();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)errorLimit)) {
            return timeFacet;
        }
        return super.getSlotFacets(slot);
    }

    @Override
    protected boolean isNormal(BDiscreteTotalizerExt totalExt) {
        return this.getErrorLimit().getMillis() > totalExt.getElapsedActiveTime().getMillis();
    }

    @Override
    protected String getAlarmPresentValueString(BDiscreteTotalizerExt totalizerExt) {
        return totalizerExt.getElapsedActiveTime().toString(timeContext);
    }

    @Override
    protected String getAlarmErrorLimitString() {
        return this.getErrorLimit().toString(timeContext);
    }
}

