/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.util;

import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.callbacks.LdapUpdateVendorDetailsCallback;
import com.tridiumx.ldapDriver.users.BLdapUserOperationStatus;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.baja.sys.BajaRuntimeException;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.ldap.LdapContext;

public class LdapDriverUtil {
    private static final String VENDOR = "tridium";
    private static final String ENTSEC_LDAP_FEATURE = "entsecLDAP";

    public static String getUserDN(String dnUniqueName, String userBase) {
        return new StringBuffer(dnUniqueName).append(",").append(userBase).toString();
    }

    public static boolean supportsPersistentControl(BLdapServer ldapServer) throws NamingException {
        LdapContext ldapContext = (LdapContext)ldapServer.connect();
        Attributes list = ldapContext.getAttributes("", new String[]{"supportedControl"});
        Attribute supportedControlAttribute = list.get("supportedControl");
        boolean isActiveDirectory = LdapDriverUtil.isActiveDirectry(ldapServer);
        if (supportedControlAttribute != null) {
            NamingEnumeration<?> allControls = supportedControlAttribute.getAll();
            while (allControls.hasMore()) {
                String ctName = (String)allControls.next();
                if ((!isActiveDirectory || !"1.2.840.113556.1.4.528".equals(ctName)) && !"2.16.840.1.113730.3.4.3".equals(ctName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isActiveDirectry(BLdapServer ldapServer) {
        LdapUpdateVendorDetailsCallback callback = new LdapUpdateVendorDetailsCallback(ldapServer);
        try {
            callback.invoke();
            return ldapServer.getIsGlobalCatalogReady();
        }
        catch (NamingException e) {
            Logger.getLogger("Ldap.Utils").severe("Error getting Vendor details : " + e.getLocalizedMessage());
            return false;
        }
    }

    public static BLdapUserOperationStatus getUserOperationStatus(NamingException ex) {
        BLdapUserOperationStatus status = BLdapUserOperationStatus.error;
        if (ex instanceof NameAlreadyBoundException) {
            status = BLdapUserOperationStatus.entryAlreadyExists;
        } else if (ex instanceof InvalidNameException) {
            status = BLdapUserOperationStatus.invalidDN;
        } else if (ex instanceof NoSuchAttributeException) {
            status = BLdapUserOperationStatus.noSuchAttributeSpecified;
        } else if (ex instanceof InvalidAttributesException) {
            status = BLdapUserOperationStatus.invalidAttributes;
        } else if (ex instanceof InvalidAttributeValueException) {
            status = BLdapUserOperationStatus.invalidAttributeValue;
        }
        return status;
    }

    public static byte[] getBytes(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static byte[] leftTrim(byte ... bytes) {
        int pos;
        for (pos = 0; pos < bytes.length && bytes[pos] == 0; ++pos) {
        }
        byte[] dest = new byte[bytes.length - pos];
        if (pos < bytes.length) {
            System.arraycopy(bytes, pos, dest, 0, dest.length);
            return dest;
        }
        return new byte[]{0};
    }

    public static String getTimeStampAttribute(BLdapServer server, String fallback) {
        return fallback;
    }

    public static void checkFeatureLicense(BLdapServer ldapServer) {
        if (ldapServer.isFault()) {
            throw new BajaRuntimeException(ldapServer.getFaultCause());
        }
    }
}

