/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.users;

import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridiumx.ldapDriver.BLdapAttributeValuePair;
import com.tridiumx.ldapDriver.BLdapEntryDeviceExt;
import com.tridiumx.ldapDriver.BLdapGroupValuePair;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import com.tridiumx.ldapDriver.users.BLdapUser;
import com.tridiumx.ldapDriver.users.BLdapUserOperationResponse;
import com.tridiumx.ldapDriver.users.BLdapUserOperationStatus;
import com.tridiumx.ldapDriver.users.BLdapUsersDiscoveryLeaf;
import com.tridiumx.ldapDriver.users.BLdapUsersDiscoveryPreferences;
import com.tridiumx.ldapDriver.users.BLdapUsersFolder;
import com.tridiumx.ldapDriver.users.LdapUserListQueryResponse;
import com.tridiumx.ldapDriver.util.LdapDriverUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

public class BLdapUsersDeviceExt
extends BLdapEntryDeviceExt
implements BIDeviceFolder,
BINDiscoveryHost {
    public static final Property discoveryPreferences = BLdapUsersDeviceExt.newProperty((int)0, (BValue)new BLdapUsersDiscoveryPreferences(), null);
    public static final Property userBase = BLdapUsersDeviceExt.newProperty((int)0, (String)"cn=users,dc=honeywell,dc=com", null);
    public static final Property searchFilter = BLdapUsersDeviceExt.newProperty((int)0, (String)"(|(objectClass=inetorgperson)(objectClass=person)(objectClass=organizationalPerson))", null);
    public static final Property lastUpdateTime = BLdapUsersDeviceExt.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Action resetLastUpdateTime = BLdapUsersDeviceExt.newAction((int)0, null);
    public static final Topic ldapUserChanged = BLdapUsersDeviceExt.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BLdapUsersDeviceExt.class);
    private Lock lock = new ReentrantLock();
    private final Logger log = Logger.getLogger("ldapDriver.UserDeviceExt");
    private static final int DEFAULT_THREAD_COUNT = 100;

    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    @Override
    public void setDiscoveryPreferences(BNDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    public String getUserBase() {
        return this.getString(userBase);
    }

    public void setUserBase(String v) {
        this.setString(userBase, v, null);
    }

    public String getSearchFilter() {
        return this.getString(searchFilter);
    }

    public void setSearchFilter(String v) {
        this.setString(searchFilter, v, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime v) {
        this.set(lastUpdateTime, (BValue)v, null);
    }

    public void resetLastUpdateTime() {
        this.invoke(resetLastUpdateTime, null, null);
    }

    public void fireLdapUserChanged(BValue event) {
        this.fire(ldapUserChanged, event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BLdapUser.TYPE;
    }

    public Type getDeviceFolderType() {
        return BLdapUsersFolder.TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        this.lease();
        BLdapUser[] users = this.getUserList().getUserList();
        BLdapUsersDiscoveryLeaf[] discoveredObjects = new BLdapUsersDiscoveryLeaf[users.length];
        for (int i = 0; i < users.length; ++i) {
            BLdapAttributeValuePair snAttr;
            BComponent ocList = users[i].getObjectClassList();
            BComponent attrList = users[i].getAttributeList();
            BLdapUsersDiscoveryLeaf discoveredObject = new BLdapUsersDiscoveryLeaf();
            discoveredObject.setDistinguishedName(users[i].getDistinguishedName());
            BLdapAttributeValuePair cnAttr = (BLdapAttributeValuePair)attrList.get("cn");
            if (cnAttr != null && cnAttr.getAttrValue() != null) {
                discoveredObject.setFirstName(cnAttr.getAttrValue());
            }
            if ((snAttr = (BLdapAttributeValuePair)attrList.get("sn")) != null && snAttr.getAttrValue() != null) {
                discoveredObject.setLastName(snAttr.getAttrValue());
            }
            BLdapAttributeValuePair[] ocAttrList = (BLdapAttributeValuePair[])ocList.getChildren(BLdapAttributeValuePair.class);
            StringBuffer ocString = new StringBuffer();
            for (int j = 0; j < ocAttrList.length; ++j) {
                ocString.append((j != 0 ? "," : "") + ocAttrList[j].getAttrValue());
            }
            discoveredObject.setUserTypes(ocString.toString());
            discoveredObjects[i] = discoveredObject;
        }
        return discoveredObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLdapUserOperationResponse add(BLdapUser user) {
        BLdapUserOperationResponse status;
        block23: {
            Object objClassList;
            BLdapServer ldapServer = (BLdapServer)this.getParent();
            status = new BLdapUserOperationResponse();
            status.setDistinguishedName(user.getDistinguishedName());
            BasicAttributes entry = new BasicAttributes();
            try {
                BasicAttribute oc = new BasicAttribute("objectClass");
                BComponent objClassListHolder = user.getObjectClassList();
                objClassList = (BLdapAttributeValuePair[])objClassListHolder.getChildren(BLdapAttributeValuePair.class);
                for (int i = 0; i < ((BLdapAttributeValuePair[])objClassList).length; ++i) {
                    oc.add(objClassList[i].getAttrValue());
                }
                entry.put(oc);
                BComponent attributeListHolder = user.getAttributeList();
                BLdapAttributeValuePair[] attributeSlotList = (BLdapAttributeValuePair[])attributeListHolder.getChildren(BLdapAttributeValuePair.class);
                for (int i = 0; i < attributeSlotList.length; ++i) {
                    String attrName = attributeSlotList[i].getAttrName();
                    String attValue = attributeSlotList[i].getAttrValue();
                    BasicAttribute attr = new BasicAttribute(attrName, attValue);
                    entry.put(attr);
                }
                BLdapAttributesDeviceExt attrExt = ldapServer.getAttributes();
                String groupAttr = attrExt.getGroupAttribute();
                if (groupAttr != null && !"".equals(groupAttr.trim())) {
                    BasicAttribute attr = null;
                    BVector groupListHolder = user.getGroupNameList();
                    if (groupListHolder != null) {
                        BLdapGroupValuePair[] groupSlotList = (BLdapGroupValuePair[])groupListHolder.getChildren(BLdapGroupValuePair.class);
                        for (int i = 0; i < groupSlotList.length; ++i) {
                            String groupValue = groupSlotList[i].getGroupName();
                            attr = new BasicAttribute(groupAttr, groupValue);
                            entry.put(attr);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.log.severe("Error creating attribute/objectClass : " + ex.getMessage());
                status.setStatus(BLdapUserOperationStatus.error);
                status.setTimestamp(BAbsTime.now());
                return status;
            }
            DirContext dirContext = null;
            Context userCtx = null;
            try {
                dirContext = ldapServer.connect();
                if (dirContext != null) {
                    userCtx = dirContext.createSubcontext(LdapDriverUtil.getUserDN(user.getDistinguishedName(), ldapServer.getUserSearchBase()), (Attributes)entry);
                    status.setStatus(BLdapUserOperationStatus.success);
                    status.setTimestamp(BAbsTime.now());
                    break block23;
                }
                this.log.severe("No Directory context could be found");
                status.setStatus(BLdapUserOperationStatus.error);
                status.setTimestamp(BAbsTime.now());
                objClassList = status;
                return objClassList;
            }
            catch (NamingException ex) {
                this.log.log(Level.SEVERE, "Error creating user entry on LDAP server  : ", ex);
                status.setStatus(this.getLdapOperationResponseStatus(ex));
                status.setTimestamp(BAbsTime.now());
                BLdapUserOperationResponse bLdapUserOperationResponse = status;
                return bLdapUserOperationResponse;
            }
            finally {
                try {
                    if (dirContext != null) {
                        dirContext.close();
                        dirContext = null;
                    }
                    if (userCtx != null) {
                        userCtx.close();
                        userCtx = null;
                    }
                }
                catch (NamingException ex) {
                    this.log.severe("Error closing connection to LDAP server  : " + ex.getMessage());
                }
            }
        }
        return status;
    }

    private BLdapUserOperationStatus getLdapOperationResponseStatus(NamingException ex) {
        return LdapDriverUtil.getUserOperationStatus(ex);
    }

    public BLdapUserOperationResponse[] add(BLdapUser[] users) {
        BLdapUserOperationResponse[] statusList = new BLdapUserOperationResponse[users.length];
        for (int index = 0; index < users.length; ++index) {
            statusList[index] = this.add(users[index]);
        }
        return statusList;
    }

    public BLdapUserOperationResponse delete(BLdapUser user) {
        return this.delete(user.getDistinguishedName());
    }

    public BLdapUserOperationResponse[] delete(String[] dnList) {
        BLdapUserOperationResponse[] statusList = new BLdapUserOperationResponse[dnList.length];
        for (int index = 0; index < dnList.length; ++index) {
            statusList[index] = this.delete(dnList[index]);
        }
        return statusList;
    }

    public BLdapUserOperationResponse[] delete(BLdapUser[] users) {
        BLdapUserOperationResponse[] statusList = new BLdapUserOperationResponse[users.length];
        for (int index = 0; index < users.length; ++index) {
            statusList[index] = this.delete(users[index].getDistinguishedName());
        }
        return statusList;
    }

    public BLdapUserOperationResponse delete(String userDN) {
        BLdapUserOperationResponse response = new BLdapUserOperationResponse();
        response.setDistinguishedName(userDN);
        if (userDN != null && !"".equals(userDN.trim())) {
            BLdapServer ldapServer = (BLdapServer)this.getParent();
            DirContext context = null;
            try {
                context = ldapServer.connect();
            }
            catch (NamingException e) {
                this.log.severe("Unable to establish connection " + e.getLocalizedMessage());
            }
            if (context != null) {
                try {
                    context.destroySubcontext(LdapDriverUtil.getUserDN(userDN, ldapServer.getUserSearchBase()));
                    response.setStatus(BLdapUserOperationStatus.success);
                }
                catch (NamingException e) {
                    this.log.severe("Error trying to delete the user " + userDN + " : " + e.getLocalizedMessage());
                    response.setStatus(BLdapUserOperationStatus.error);
                }
            } else {
                this.log.severe("Unable to get directory context");
            }
        } else {
            this.log.severe("Empty Distinguisehd name passed for user");
            response.setStatus(BLdapUserOperationStatus.invalidDN);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLdapUser getUser(String distinguishedName) throws NamingException {
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        try (DirContext context = ldapServer.connect();){
            Attributes attrs = context.getAttributes(distinguishedName);
            BLdapUser bLdapUser = this.makeLdapUser(ldapServer, distinguishedName, attrs);
            return bLdapUser;
        }
    }

    public LdapUserListQueryResponse getUserList(String searchBase, String searchFilter) throws NamingException {
        return this.getUserList(searchBase, searchFilter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapUserListQueryResponse getUserList(String searchBase, String searchFilter, Control[] controls) throws NamingException {
        LdapUserListQueryResponse resp = new LdapUserListQueryResponse();
        ArrayList<BLdapUser> users = new ArrayList<BLdapUser>();
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        LdapContext context = (LdapContext)ldapServer.connect();
        SearchControls searchControls = new SearchControls();
        if (context != null) {
            context.setRequestControls(controls);
        }
        searchControls.setSearchScope(ldapServer.getSearchScope().getOrdinal());
        searchBase = searchBase != null && !"".equals(searchBase) ? searchBase : ldapServer.getUserSearchBase();
        searchFilter = searchFilter != null && !"".equals(searchFilter) ? searchFilter : ldapServer.getUserSearchFilter();
        NamingEnumeration<SearchResult> searchResults = context.search(searchBase, searchFilter, searchControls);
        try {
            this.lock.lock();
            while (searchResults.hasMoreElements()) {
                SearchResult sr = searchResults.next();
                String dn = sr.getNameInNamespace();
                Attributes attributes = sr.getAttributes();
                BLdapUser user = this.makeLdapUser(ldapServer, dn, attributes);
                users.add(user);
            }
            resp.setUserList(users.toArray(new BLdapUser[users.size()]));
            resp.setResponseControls(context.getResponseControls());
            LdapUserListQueryResponse ldapUserListQueryResponse = resp;
            return ldapUserListQueryResponse;
        }
        finally {
            this.lock.unlock();
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLdapUser[] getPaginatedUserList(String searchBase, String searchFilter, byte[] cookie) throws NamingException {
        ArrayList<BLdapUser> users = new ArrayList<BLdapUser>();
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        DirContext context = ldapServer.connect();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchBase = searchBase != null && !"".equals(searchBase) ? searchBase : ldapServer.getUserSearchBase();
        searchFilter = searchFilter != null && !"".equals(searchFilter) ? searchFilter : ldapServer.getUserSearchFilter();
        NamingEnumeration<SearchResult> searchResults = context.search(searchBase, searchFilter, searchControls);
        try {
            this.lock.lock();
            while (searchResults.hasMoreElements()) {
                SearchResult sr = searchResults.next();
                String dn = sr.getNameInNamespace();
                Attributes attributes = sr.getAttributes();
                BLdapUser user = this.makeLdapUser(ldapServer, dn, attributes);
                users.add(user);
            }
        }
        finally {
            this.lock.unlock();
            if (context != null) {
                context.close();
            }
        }
        return users.toArray(new BLdapUser[users.size()]);
    }

    private BLdapUser makeLdapUser(BLdapServer ldapServer, String dn, Attributes attributes) throws NamingException {
        BLdapUser user = new BLdapUser();
        BComponent ocList = user.getObjectClassList();
        BComponent aList = user.getAttributeList();
        BVector groupList = user.getGroupNameList();
        user.setDistinguishedName(dn);
        NamingEnumeration<String> attrIdList = attributes.getIDs();
        while (attrIdList.hasMore()) {
            String oVal;
            String id = attrIdList.next();
            Attribute attr = attributes.get(id);
            String value = this.getAttributeValue(attr);
            if ("distinguishedName".equals(id)) continue;
            if ("objectClass".equals(id)) {
                NamingEnumeration<?> objectClasses = attr.getAll();
                while (objectClasses.hasMore()) {
                    oVal = (String)objectClasses.next();
                    ocList.add(null, (BValue)BLdapAttributeValuePair.make("objectClass", oVal));
                }
                continue;
            }
            if (ldapServer.getAttributes().getGroupAttribute().equals(id)) {
                NamingEnumeration<?> groupAttributes = attr.getAll();
                while (groupAttributes.hasMore()) {
                    oVal = (String)groupAttributes.next();
                    if (oVal == null || oVal.length() <= 0) continue;
                    groupList.add(null, (BValue)BLdapGroupValuePair.make("groupName", oVal));
                }
                continue;
            }
            if (aList.get(id) != null) continue;
            aList.add(SlotPath.escape((String)id), (BValue)BLdapAttributeValuePair.make(id, value));
        }
        return user;
    }

    public LdapUserListQueryResponse getUserList() throws NamingException {
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        String searchBase = ldapServer.getUserSearchBase();
        return this.getUserList(searchBase, ldapServer.getUserSearchFilter(), null);
    }

    public LdapUserListQueryResponse getUserList(Control[] reqControls) throws NamingException {
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        String searchBase = ldapServer.getUserSearchBase();
        return this.getUserList(searchBase, ldapServer.getUserSearchFilter(), reqControls);
    }

    public void doResetLastUpdateTime() {
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        LdapDriverUtil.checkFeatureLicense(ldapServer);
        this.setLastUpdateTime(BAbsTime.NULL);
    }

    private String getAttributeValue(Attribute attr) throws NamingException {
        String value = "";
        Object obj = attr.get();
        if (obj instanceof String) {
            value = (String)obj;
        } else if (obj instanceof byte[]) {
            value = new String((byte[])obj);
        }
        return value;
    }

    public BLdapUserOperationResponse[] addConcurrently(BLdapUser[] users) {
        int noOfThreadsToInsertData = this.getCountOfThreadsRequiredForProcessing(users.length);
        int noOfUsersPerThread = users.length / noOfThreadsToInsertData;
        ExecutorService pool = Executors.newFixedThreadPool(noOfThreadsToInsertData);
        ArrayList statusList = new ArrayList(users.length);
        AddUsersToLDAP callable = null;
        Future<List<BLdapUserOperationResponse>> future = null;
        ArrayList<Future<List<BLdapUserOperationResponse>>> futureList = new ArrayList<Future<List<BLdapUserOperationResponse>>>(noOfThreadsToInsertData);
        int chunkStartIndex = 0;
        int chunkEndIndex = noOfUsersPerThread;
        int remainingEntries = 0;
        for (int threadNum = 0; threadNum < noOfThreadsToInsertData; ++threadNum) {
            callable = new AddUsersToLDAP(Arrays.copyOfRange(users, chunkStartIndex, chunkEndIndex), threadNum);
            future = pool.submit(callable);
            futureList.add(future);
            chunkStartIndex += noOfUsersPerThread;
            if (threadNum == noOfThreadsToInsertData - 2) {
                if (users.length > noOfUsersPerThread) {
                    remainingEntries = users.length % noOfUsersPerThread;
                }
                chunkEndIndex = chunkStartIndex + noOfUsersPerThread + remainingEntries;
                continue;
            }
            chunkEndIndex = chunkStartIndex + noOfUsersPerThread;
        }
        for (Future future2 : futureList) {
            try {
                statusList.addAll((Collection)future2.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        pool.shutdown();
        while (!pool.isTerminated()) {
        }
        Array array = new Array(BLdapUserOperationResponse.class);
        for (BLdapUserOperationResponse status : statusList) {
            array.add((Object)status);
        }
        return (BLdapUserOperationResponse[])array.trim();
    }

    private int getCountOfThreadsRequiredForProcessing(int noOfUsersToInsert) {
        boolean isConnectionPoolEnabled = ((BLdapServer)this.getParent()).getLdapConnection().getEnableConnectionPooling();
        int noOfMaxLDAPThreads = isConnectionPoolEnabled ? ((BLdapServer)this.getParent()).getLdapConnection().getMaxSize() : 100;
        return noOfUsersToInsert < noOfMaxLDAPThreads ? noOfUsersToInsert : noOfMaxLDAPThreads;
    }

    private class AddUsersToLDAP
    implements Callable<List<BLdapUserOperationResponse>> {
        private BLdapUser[] users;
        private int threadNum;

        public AddUsersToLDAP(BLdapUser[] users, int threadNum) {
            this.users = users;
            this.threadNum = threadNum;
        }

        @Override
        public List<BLdapUserOperationResponse> call() throws Exception {
            ArrayList<BLdapUserOperationResponse> returnStatusList = new ArrayList<BLdapUserOperationResponse>(this.users.length);
            for (int i = 0; i < this.users.length; ++i) {
                returnStatusList.add(BLdapUsersDeviceExt.this.add(this.users[i]));
            }
            return returnStatusList;
        }
    }
}

