/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.spec;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class BerDecoder {
    private int origOffset;
    protected byte[] buf;
    protected int offset;
    protected int bufsize;

    public BerDecoder(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        this.buf = paramArrayOfByte;
        this.bufsize = paramInt2;
        this.origOffset = paramInt1;
        this.reset();
    }

    public void reset() {
        this.offset = this.origOffset;
    }

    public int getParsePosition() {
        return this.offset;
    }

    public int parseLength() throws DecodeException {
        int i = this.parseByte();
        if ((i & 0x80) == 128) {
            if ((i &= 0x7F) == 0) {
                throw new DecodeException("Indefinite length not supported");
            }
            if (i > 4) {
                throw new DecodeException("encoding too long");
            }
            if (this.bufsize - this.offset < i) {
                throw new DecodeException("Insufficient data");
            }
            int j = 0;
            for (int k = 0; k < i; ++k) {
                j = (j << 8) + (this.buf[this.offset++] & 0xFF);
            }
            return j;
        }
        return i;
    }

    public int parseSeq(int[] paramArrayOfInt) throws DecodeException {
        int i = this.parseByte();
        int j = this.parseLength();
        if (paramArrayOfInt != null) {
            paramArrayOfInt[0] = j;
        }
        return i;
    }

    void seek(int paramInt) throws DecodeException {
        if (this.offset + paramInt > this.bufsize || this.offset + paramInt < 0) {
            throw new DecodeException("array index out of bounds");
        }
        this.offset += paramInt;
    }

    public int parseByte() throws DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new DecodeException("Insufficient data");
        }
        return this.buf[this.offset++] & 0xFF;
    }

    public int peekByte() throws DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new DecodeException("Insufficient data");
        }
        return this.buf[this.offset] & 0xFF;
    }

    public boolean parseBoolean() throws DecodeException {
        return this.parseIntWithTag(1) != 0;
    }

    public int parseEnumeration() throws DecodeException {
        return this.parseIntWithTag(10);
    }

    public int parseInt() throws DecodeException {
        return this.parseIntWithTag(2);
    }

    private int parseIntWithTag(int paramInt) throws DecodeException {
        if (this.parseByte() != paramInt) {
            throw new DecodeException("Encountered ASN.1 tag " + Integer.toString(this.buf[this.offset - 1] & 0xFF) + " (expected tag " + Integer.toString(paramInt) + ")");
        }
        int i = this.parseLength();
        if (i > 4) {
            throw new DecodeException("INTEGER too long");
        }
        if (i > this.bufsize - this.offset) {
            throw new DecodeException("Insufficient data");
        }
        byte j = this.buf[this.offset++];
        int k = 0;
        k = j & 0x7F;
        for (int l = 1; l < i; ++l) {
            k <<= 8;
            k |= this.buf[this.offset++] & 0xFF;
        }
        if ((j & 0x80) == 128) {
            k = -k;
        }
        return k;
    }

    public String parseString(boolean paramBoolean) throws DecodeException {
        return this.parseStringWithTag(4, paramBoolean, null);
    }

    public String parseStringWithTag(int tag, boolean decodeUTF8, int[] rlen) throws DecodeException {
        String str;
        int j = this.offset;
        int i = this.parseByte();
        if (i != tag) {
            throw new DecodeException("Encountered ASN.1 tag " + Integer.toString((byte)i) + " (expected tag " + tag + ")");
        }
        int k = this.parseLength();
        if (k > this.bufsize - this.offset) {
            throw new DecodeException("Insufficient data");
        }
        if (k == 0) {
            str = "";
        } else {
            byte[] arrayOfByte = new byte[k];
            System.arraycopy(this.buf, this.offset, arrayOfByte, 0, k);
            if (decodeUTF8) {
                try {
                    str = new String(arrayOfByte, "UTF8");
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
                    throw new DecodeException("UTF8 not available on platform");
                }
            }
            try {
                str = new String(arrayOfByte, "8859_1");
            }
            catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                throw new DecodeException("8859_1 not available on platform");
            }
            this.offset += k;
        }
        if (rlen != null) {
            rlen[0] = this.offset - j;
        }
        return str;
    }

    public byte[] parseOctetString(int tag, int[] rlen) throws DecodeException {
        int i = this.offset;
        int j = this.parseByte();
        if (j != tag) {
            throw new DecodeException("Encountered ASN.1 tag " + Integer.toString(j) + " (expected tag " + Integer.toString(tag) + ")");
        }
        int k = this.parseLength();
        if (k > this.bufsize - this.offset) {
            throw new DecodeException("Insufficient data");
        }
        byte[] arrayOfByte = new byte[k];
        if (k > 0) {
            System.arraycopy(this.buf, this.offset, arrayOfByte, 0, k);
            this.offset += k;
        }
        if (rlen != null) {
            rlen[0] = this.offset - i;
        }
        return arrayOfByte;
    }

    public int bytesLeft() {
        return this.bufsize - this.offset;
    }

    static final class DecodeException
    extends IOException {
        private static final long serialVersionUID = 1L;

        DecodeException(String paramString) {
            super(paramString);
        }
    }
}

