/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.groups;

import com.tridium.ndriver.discover.BINDiscoveryHost;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridiumx.ldapDriver.BLdapEntryDeviceExt;
import com.tridiumx.ldapDriver.BLdapSearchControlScope;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.groups.BLdapGroup;
import com.tridiumx.ldapDriver.groups.BLdapGroupsDiscoveryLeaf;
import com.tridiumx.ldapDriver.groups.BLdapGroupsDiscoveryPreferences;
import com.tridiumx.ldapDriver.groups.BLdapGroupsFolder;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class BLdapGroupsDeviceExt
extends BLdapEntryDeviceExt
implements BIDeviceFolder,
BINDiscoveryHost {
    public static final Property discoveryPreferences = BLdapGroupsDeviceExt.newProperty((int)0, (BValue)new BLdapGroupsDiscoveryPreferences(), null);
    public static final Type TYPE = Sys.loadType(BLdapGroupsDeviceExt.class);
    private Lock lock = new ReentrantLock();

    public BNDiscoveryPreferences getDiscoveryPreferences() {
        return (BNDiscoveryPreferences)this.get(discoveryPreferences);
    }

    @Override
    public void setDiscoveryPreferences(BNDiscoveryPreferences v) {
        this.set(discoveryPreferences, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        this.lease();
        BLdapGroupsDiscoveryPreferences dp = (BLdapGroupsDiscoveryPreferences)prefs;
        BLdapGroup[] attributes = this.getGroupList(dp);
        BLdapGroupsDiscoveryLeaf[] discoveredObjects = new BLdapGroupsDiscoveryLeaf[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            BLdapGroupsDiscoveryLeaf discoveredObject = new BLdapGroupsDiscoveryLeaf();
            discoveredObject.setDistinguishedName(attributes[i].getDistinguishedName());
            discoveredObject.setCn(attributes[i].getCn());
            discoveredObjects[i] = discoveredObject;
        }
        return discoveredObjects;
    }

    public Type getDeviceType() {
        return BLdapGroup.TYPE;
    }

    public Type getDeviceFolderType() {
        return BLdapGroupsFolder.TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BLdapGroup[] getGroupList(BLdapGroupsDiscoveryPreferences prefs) throws NamingException {
        ArrayList<BLdapGroup> groups = new ArrayList<BLdapGroup>();
        BLdapServer ldapServer = (BLdapServer)this.getParent();
        DirContext context = ldapServer.connect();
        SearchControls searchControls = new SearchControls();
        BLdapSearchControlScope groupSearchControlScope = prefs.getGroupSearchScope();
        switch (groupSearchControlScope.getOrdinal()) {
            case 0: {
                searchControls.setSearchScope(0);
                break;
            }
            case 1: {
                searchControls.setSearchScope(1);
                break;
            }
            case 2: {
                searchControls.setSearchScope(2);
            }
        }
        NamingEnumeration<SearchResult> searchResults = context.search(prefs.getGroupSearchBase(), prefs.getGroupSearchFilter(), searchControls);
        try {
            this.lock.lock();
            while (searchResults.hasMoreElements()) {
                SearchResult sr = searchResults.next();
                BLdapGroup group = new BLdapGroup();
                group.setDistinguishedName(sr.getNameInNamespace());
                Attributes attributes = sr.getAttributes();
                NamingEnumeration<String> attrIdList = attributes.getIDs();
                while (attrIdList.hasMore()) {
                    String id = attrIdList.next();
                    Attribute attr = attributes.get(id);
                    String value = "";
                    Object obj = attr.get();
                    if (obj instanceof String) {
                        value = (String)obj;
                    } else {
                        if (!(obj instanceof byte[])) continue;
                        value = new String((byte[])obj);
                    }
                    if ("distinguishedName".equals(id)) continue;
                    if ("cn".equals(id)) {
                        group.setCn(value);
                        continue;
                    }
                    if (group.get(id) != null) continue;
                    group.addAttributeValue(id, value);
                }
                groups.add(group);
            }
        }
        finally {
            this.lock.unlock();
            if (context != null) {
                context.close();
            }
        }
        return groups.toArray(new BLdapGroup[groups.size()]);
    }
}

