/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import com.tridiumx.ldapDriver.BLdapAttributeValuePair;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.ldapDriver.BLdapServer;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BLdapEntry
extends BNDevice {
    public static final Property distinguishedName = BLdapEntry.newProperty((int)0, (String)"", (BFacets)SfUtil.incl());
    public static final Type TYPE = Sys.loadType(BLdapEntry.class);

    public String getDistinguishedName() {
        return this.getString(distinguishedName);
    }

    public void setDistinguishedName(String v) {
        this.setString(distinguishedName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BLdapNetwork.TYPE;
    }

    public void addAttributeValue(String key, String value) {
        BLdapAttributeValuePair a = new BLdapAttributeValuePair();
        a.setAttrName(key);
        a.setAttrValue(value);
        if (this.get(key) != null) {
            this.remove(key);
        }
        this.add(key, (BValue)a);
    }

    public synchronized boolean equivalent(Object arg) {
        BLdapEntry target = (BLdapEntry)((Object)arg);
        if (target == null) {
            return false;
        }
        return this.getDistinguishedName().equalsIgnoreCase(target.getDistinguishedName());
    }

    public BLdapServer getLdapDevice() {
        return (BLdapServer)DrUtil.getParent((BComplex)this, (Type)BLdapServer.TYPE);
    }

    public void doPing() {
        try {
            this.pingOk();
        }
        catch (Exception e) {
            this.pingFail(e.getLocalizedMessage());
        }
    }

    public void stopped() throws Exception {
        try {
            super.stopped();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

