/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver;

import com.tridium.ndriver.util.SfUtil;
import com.tridiumx.ldapDriver.BAuthenticationMechanism;
import com.tridiumx.ldapDriver.callbacks.LdapConnectionCallback;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;

public class BLdapConnection
extends BComponent {
    public static final Property connectionHost = BLdapConnection.newProperty((int)0, (String)"example.com", (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    public static final Property connectionPort = BLdapConnection.newProperty((int)0, (int)636, (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    public static final Property tls = BLdapConnection.newProperty((int)0, (boolean)true, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property authenticationMechanism = BLdapConnection.newProperty((int)0, (BValue)BAuthenticationMechanism.simple, null);
    public static final Property connectionUser = BLdapConnection.newProperty((int)0, (String)"uid=admin,ou=system", (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    public static final Property connectionPassword = BLdapConnection.newProperty((int)0, (BValue)BPassword.DEFAULT, (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    public static final Property initialContextFactory = BLdapConnection.newProperty((int)4, (String)"com.sun.jndi.ldap.LdapCtxFactory", null);
    public static final Property enableConnectionPooling = BLdapConnection.newProperty((int)0, (boolean)true, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property initialSize = BLdapConnection.newProperty((int)0, (int)0, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property maxSize = BLdapConnection.newProperty((int)0, (int)10, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property prefSize = BLdapConnection.newProperty((int)0, (int)0, (BFacets)SfUtil.incl((String)"ed"));
    public static final Property connectionPoolTimeout = BLdapConnection.newProperty((int)0, (int)0, (BFacets)SfUtil.incl((String)"ed"));
    public static final Type TYPE = Sys.loadType(BLdapConnection.class);
    private static final Map<String, String> AUTHENTICATION_MECHANISMS = new HashMap<String, String>();
    private static final String LDAPS = "ldaps://";
    private static final String LDAP = "ldap://";
    private static final String JNDI_LDAP_CONNECTION_POOL = "com.sun.jndi.ldap.connect.pool";
    public static final String JNDI_LDAP_CONNECT_POOL_INITSIZE = "com.sun.jndi.ldap.connect.pool.initsize";
    public static final String JNDI_LDAP_CONNECT_POOL_MAXSIZE = "com.sun.jndi.ldap.connect.pool.maxsize";
    public static final String JNDI_LDAP_CONNECT_POOL_PREFSIZE = "com.sun.jndi.ldap.connect.pool.prefsize";
    public static final String JNDI_LDAP_CONNECT_POOL_TIMEOUT = "com.sun.jndi.ldap.connect.pool.timeout";
    public static final String LDAP_FACTORY_SOCKET = "java.naming.ldap.factory.socket";
    public static final String BAJA_SECURITY_CRYPTO_SE_BAJA_SSLSOCKET_FACTORY = "javax.baja.security.crypto.se.BajaSSLSocketFactory";
    public static final String SECURITY_PROTOCOL_STRING = "ssl";
    private static final Logger LOG;
    private static Lexicon lex;

    public String getConnectionHost() {
        return this.getString(connectionHost);
    }

    public void setConnectionHost(String v) {
        this.setString(connectionHost, v, null);
    }

    public int getConnectionPort() {
        return this.getInt(connectionPort);
    }

    public void setConnectionPort(int v) {
        this.setInt(connectionPort, v, null);
    }

    public boolean getTls() {
        return this.getBoolean(tls);
    }

    public void setTls(boolean v) {
        this.setBoolean(tls, v, null);
    }

    public BAuthenticationMechanism getAuthenticationMechanism() {
        return (BAuthenticationMechanism)this.get(authenticationMechanism);
    }

    public void setAuthenticationMechanism(BAuthenticationMechanism v) {
        this.set(authenticationMechanism, (BValue)v, null);
    }

    public String getConnectionUser() {
        return this.getString(connectionUser);
    }

    public void setConnectionUser(String v) {
        this.setString(connectionUser, v, null);
    }

    public BPassword getConnectionPassword() {
        return (BPassword)this.get(connectionPassword);
    }

    public void setConnectionPassword(BPassword v) {
        this.set(connectionPassword, (BValue)v, null);
    }

    public String getInitialContextFactory() {
        return this.getString(initialContextFactory);
    }

    public void setInitialContextFactory(String v) {
        this.setString(initialContextFactory, v, null);
    }

    public boolean getEnableConnectionPooling() {
        return this.getBoolean(enableConnectionPooling);
    }

    public void setEnableConnectionPooling(boolean v) {
        this.setBoolean(enableConnectionPooling, v, null);
    }

    public int getInitialSize() {
        return this.getInt(initialSize);
    }

    public void setInitialSize(int v) {
        this.setInt(initialSize, v, null);
    }

    public int getMaxSize() {
        return this.getInt(maxSize);
    }

    public void setMaxSize(int v) {
        this.setInt(maxSize, v, null);
    }

    public int getPrefSize() {
        return this.getInt(prefSize);
    }

    public void setPrefSize(int v) {
        this.setInt(prefSize, v, null);
    }

    public int getConnectionPoolTimeout() {
        return this.getInt(connectionPoolTimeout);
    }

    public void setConnectionPoolTimeout(int v) {
        this.setInt(connectionPoolTimeout, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == tls) {
            return lex.getText("BLdapConnection.tls");
        }
        if (slot == connectionPoolTimeout) {
            return lex.getText("BLdapConnection.connectionPoolTimeout");
        }
        return super.getDisplayName(slot, cx);
    }

    public DirContext connect() throws NamingException {
        InitialLdapContext ctx = null;
        Hashtable<String, String> ldapConnectionParams = this.getLDAPConnectionParams();
        if (ldapConnectionParams != null) {
            ctx = new InitialLdapContext(ldapConnectionParams, new Control[0]);
        }
        return ctx;
    }

    public DirContext connect(LdapConnectionCallback[] connCallbacks) throws NamingException {
        DirContext ctx = this.connect();
        if (ctx != null) {
            this.executeCallbacks(connCallbacks, ctx);
        }
        return ctx;
    }

    void executeCallbacks(LdapConnectionCallback[] connCallbacks, DirContext ctx) {
        for (int index = 0; index < connCallbacks.length; ++index) {
            class CallbackThread
            implements Runnable {
                private LdapConnectionCallback callback;
                final Map<String, String> params;

                public CallbackThread(LdapConnectionCallback callback) {
                    this.params = BLdapConnection.this.getLDAPConnectionParams();
                    this.callback = callback;
                }

                @Override
                public void run() {
                    this.callback.setConnectionParams(this.params);
                    try {
                        this.callback.invoke();
                    }
                    catch (NamingException e) {
                        LOG.severe("Failed to execute the callback '" + this.callback.getName() + "' : " + e.getLocalizedMessage());
                    }
                }
            }
            CallbackThread callbackThread = new CallbackThread(connCallbacks[index]);
            try {
                new Thread(callbackThread).start();
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to execute the callback '" + connCallbacks[index].getName() + "' : " + e.getLocalizedMessage());
            }
        }
    }

    private Hashtable<String, String> getLDAPConnectionParams() {
        Hashtable<String, String> ldapConnectionParams = new Hashtable<String, String>();
        if (this.getConnectionUser() == null) {
            throw new IllegalArgumentException("Connection User info is not set");
        }
        ldapConnectionParams.put("java.naming.security.principal", this.getConnectionUser());
        if (this.getConnectionPassword() == null) {
            throw new IllegalArgumentException("Connection User password info is not set");
        }
        ldapConnectionParams.put("java.naming.security.credentials", AccessController.doPrivileged(() -> ((BPassword)this.getConnectionPassword()).getValue()));
        ldapConnectionParams.put("java.naming.factory.initial", this.getInitialContextFactory());
        if (this.getConnectionUrl() == null) {
            throw new IllegalArgumentException("Connection URL info is not set");
        }
        ldapConnectionParams.put("java.naming.provider.url", this.getConnectionUrl());
        if (this.getEnableConnectionPooling()) {
            LOG.fine("Connection pool enabled");
            ldapConnectionParams.put(JNDI_LDAP_CONNECTION_POOL, String.valueOf(this.getEnableConnectionPooling()));
            ldapConnectionParams.put(JNDI_LDAP_CONNECT_POOL_INITSIZE, String.valueOf(this.getInitialSize()));
            ldapConnectionParams.put(JNDI_LDAP_CONNECT_POOL_MAXSIZE, String.valueOf(this.getMaxSize()));
            ldapConnectionParams.put(JNDI_LDAP_CONNECT_POOL_PREFSIZE, String.valueOf(this.getPrefSize()));
            ldapConnectionParams.put(JNDI_LDAP_CONNECT_POOL_TIMEOUT, String.valueOf(this.getConnectionPoolTimeout()));
        }
        if (this.getTls()) {
            LOG.fine("SSL enabled");
            ldapConnectionParams.put("java.naming.security.protocol", SECURITY_PROTOCOL_STRING);
        }
        ldapConnectionParams.put("java.naming.security.authentication", AUTHENTICATION_MECHANISMS.get(this.getAuthenticationMechanism().getTag()));
        if ("digestMd5".equals(this.getAuthenticationMechanism().getTag())) {
            ldapConnectionParams.put("java.naming.security.sasl.realm", "honeywell");
            ldapConnectionParams.put("javax.security.sasl.maxbuf", "16384");
            ldapConnectionParams.put("javax.security.sasl.qop", "auth-int");
        }
        return ldapConnectionParams;
    }

    private String getProtocol() {
        return this.getTls() ? LDAPS : LDAP;
    }

    protected String getConnectionUrl() {
        String connectionUrl = null;
        if (this.getConnectionHost() != null) {
            connectionUrl = this.getProtocol() + this.getConnectionHost() + ":" + this.getConnectionPort();
        }
        return connectionUrl;
    }

    static {
        AUTHENTICATION_MECHANISMS.put("digestMd5", "DIGEST-MD5");
        AUTHENTICATION_MECHANISMS.put("cramMd5", "CRAM-MD5");
        AUTHENTICATION_MECHANISMS.put("simple", "simple");
        LOG = Logger.getLogger("ldapDriver");
        lex = Lexicon.make(BLdapConnection.class);
    }
}

