/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom.validation.validators;

import com.tridiumx.isom.InvalidInputDataException;
import java.util.function.Predicate;
import javax.baja.util.Lexicon;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class Validator {
    public static final Lexicon lex = Lexicon.make(Validator.class);

    public boolean validate(JSONObject jsonObject, String keyName) throws InvalidInputDataException {
        if (keyName == null) {
            throw new InvalidInputDataException(lex.getText("validation.keyname.not.null"));
        }
        String[] dataInKey = keyName.split("\\.");
        Object jsonObjectToValidate = jsonObject.get(dataInKey[0]);
        if (jsonObjectToValidate != null) {
            if (jsonObjectToValidate instanceof JSONArray) {
                return this.validateJsonArray((JSONArray)jsonObjectToValidate, dataInKey);
            }
            return this.validateJsonObject(jsonObject, dataInKey);
        }
        return true;
    }

    private boolean validateJsonObject(JSONObject jsonObjectToValidate, String[] dataInKey) throws InvalidInputDataException {
        if (dataInKey.length > 1) {
            for (int i = 0; i < dataInKey.length - 1; ++i) {
                jsonObjectToValidate = (JSONObject)jsonObjectToValidate.get(dataInKey[i]);
            }
        }
        return this.validateJsonObject(jsonObjectToValidate, dataInKey[dataInKey.length - 1]);
    }

    private boolean validateJsonArray(JSONArray jsonObject, String[] keyName) throws InvalidInputDataException {
        for (int i = 0; i < jsonObject.size(); ++i) {
            JSONObject jsonObject1 = (JSONObject)jsonObject.get(i);
            this.validateJsonObject(jsonObject1, keyName[keyName.length - 1]);
        }
        return true;
    }

    private boolean validateJsonObject(JSONObject jsonObject, String keyName) throws InvalidInputDataException {
        String value = null;
        value = String.valueOf(jsonObject.get(keyName));
        if (!this.getCondition().test(value)) {
            throw new InvalidInputDataException(this.getMessage(keyName));
        }
        return true;
    }

    public abstract Predicate<Object> getCondition();

    public abstract String getMessage(String var1);
}

