/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom.validation.validators;

import com.tridiumx.isom.InvalidInputDataException;
import com.tridiumx.isom.validation.validators.StringValidator;
import java.util.function.Predicate;
import org.json.simple.JSONObject;

public class EmailValidator
extends StringValidator {
    private Predicate<Object> emailCondition = s -> s == null || String.valueOf(s).indexOf("@") > 0 && String.valueOf(s).lastIndexOf(".") > String.valueOf(s).lastIndexOf("@");
    private boolean lengthConditionPassed;

    public EmailValidator(String minMaxLength) {
        super(minMaxLength);
    }

    @Override
    public boolean validate(JSONObject jsonObject, String keyName) throws InvalidInputDataException {
        this.lengthConditionPassed = false;
        this.lengthConditionPassed = super.validate(jsonObject, keyName);
        String value = (String)jsonObject.get(keyName);
        if (!this.emailCondition.test(value)) {
            throw new InvalidInputDataException(this.getMessage(keyName));
        }
        return true;
    }

    @Override
    public String getMessage(String keyName) {
        if (!this.lengthConditionPassed) {
            return super.getMessage(keyName);
        }
        return lex.getText("validation.email.not.valid.value", new Object[]{keyName});
    }
}

