/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb.orient;

import com.tridium.systemDb.orient.BDatabaseEncryptionState;
import com.tridium.systemDb.orient.BOrientSystemDb;
import java.util.ArrayList;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"orientSystemDb:OrientSystemDb"})})
public class BOrientSystemDbDashboardProvider
extends BObject
implements BISecurityDashboardProviderAgent {
    public static final Type TYPE = Sys.loadType(BOrientSystemDbDashboardProvider.class);
    private BOrientSystemDb orientSystemDb;
    private SecurityDashboardItemBuilder builder;
    private static final String SECTION_HEADER = "securityDashboard.orientDb.sectionHeader";
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    private static final String ENCRYPTION_ENABLED_SUMMARY = "securityDashboard.orientDb.encryption.enabled.summary";
    private static final String ENCRYPTION_DISABLED_SUMMARY = "securityDashboard.orientDb.encryption.disabled.summary";
    private static final String ENCRYPTION_DESCRIPTION = "securityDashboard.orientDb.encryption.description";

    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.orientSystemDb = (BOrientSystemDb)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.orientSystemDb.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        BDatabaseEncryptionState encryptionState = this.orientSystemDb.getDatabaseEncryption();
        if (encryptionState == BDatabaseEncryptionState.encrypted || encryptionState == BDatabaseEncryptionState.changingToEncrypted) {
            items.add(this.builder.makeOk(ENCRYPTION_ENABLED_SUMMARY, ENCRYPTION_DESCRIPTION));
        } else if (encryptionState == BDatabaseEncryptionState.unencrypted || encryptionState == BDatabaseEncryptionState.changingToUnencrypted) {
            items.add(this.builder.makeWarning(ENCRYPTION_DISABLED_SUMMARY, ENCRYPTION_DESCRIPTION));
        }
        return items;
    }
}

