/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsh;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nsh.Exec;
import com.tridium.nsh.Expr;
import com.tridium.sys.NreLib;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public class NShell {
    static final BModule module = Sys.getModuleForClass(NShell.class);
    PrintStream out;
    File cd;
    HashMap<String, String> env;
    boolean debug;
    Exec exec;
    private static final boolean HEADLESS = AccessController.doPrivileged(() -> Boolean.getBoolean("java.awt.headless"));

    public NShell(PrintStream out) {
        this.out = out;
        this.reset(null);
    }

    public PrintStream out() {
        return this.out;
    }

    public String getenv(String name) {
        return this.env.get(name);
    }

    public void setenv(String name, String value) {
        if (value == null) {
            this.env.remove(name);
        } else {
            this.env.put(name, value);
        }
    }

    public String[] envp() {
        String[] envp = new String[this.env.size()];
        Iterator<String> it = this.env.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = it.next();
            String val = this.env.get(key);
            envp[i] = key + "=" + val;
            ++i;
        }
        return envp;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void debug(String s) {
        this.out.println("-- " + s);
    }

    public void debug(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" debug [on | off]");
            this.out.println("   Turn debug on and off");
            this.out.println();
            return;
        }
        if (expr.args.length > 0) {
            String s = TextUtil.toUpperCase((String)expr.args[0]);
            if (s.equals("ON") || s.equals("TRUE")) {
                this.debug = true;
            }
            if (s.equals("OFF") || s.equals("FALSE")) {
                this.debug = false;
            }
        }
        this.out.println("debug = " + (this.debug ? "on" : "off"));
    }

    public File cd() {
        return this.cd;
    }

    public void cd(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" cd");
            this.out.println("   Dump current working directory");
            this.out.println(" cd <dir>");
            this.out.println("   Change to the specified directory");
            this.out.println();
            return;
        }
        if (expr.args.length > 0) {
            File old = this.cd;
            String filename = expr.args[0];
            if (this.debug) {
                this.debug("filename: " + filename);
            }
            if (this.debug) {
                this.debug("old: " + old);
            }
            try {
                boolean abs;
                boolean bl = abs = filename.startsWith("/") || filename.startsWith("\\") || filename.length() >= 2 && filename.charAt(1) == ':';
                if (this.debug) {
                    this.debug("abs: " + abs);
                }
                this.cd = abs ? new File(filename) : new File(old, filename);
                if (this.debug) {
                    this.debug("new: " + this.cd);
                }
                this.cd = new File(this.cd.getCanonicalPath());
                if (this.debug) {
                    this.debug("canonical: " + this.cd);
                }
                if (!this.cd.exists()) {
                    throw new IOException();
                }
            }
            catch (IOException e) {
                this.out.println("Cannot find path specified");
                if (this.debug) {
                    this.debug("fallback:  " + this.cd);
                }
                this.cd = old;
            }
        } else {
            this.out.println(this.cd.toString());
        }
    }

    public void set(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" set");
            this.out.println("   Dumps all the environment variables");
            this.out.println(" set <prefix>");
            this.out.println("   Dumps all the environment variables starting with prefix");
            this.out.println(" set <name>=");
            this.out.println("   Removes the specified environment variable");
            this.out.println(" set <name>=<value>");
            this.out.println("   Sets the specified environment variable");
            this.out.println();
            return;
        }
        if (expr.args.length == 0) {
            this.setdump("");
            return;
        }
        String arg = expr.args[0];
        int eq = arg.indexOf(61);
        if (eq < 0) {
            this.setdump(arg);
            return;
        }
        String key = arg.substring(0, eq);
        String val = arg.substring(eq + 1);
        if (val.length() == 0) {
            if (this.debug) {
                this.debug("set remove " + key);
            }
            this.setenv(key, null);
        } else {
            if (this.debug) {
                this.debug("set " + key + "=" + val);
            }
            this.setenv(key, val);
        }
    }

    private void setdump(String prefix) {
        prefix = TextUtil.toUpperCase((String)prefix);
        Object[] envp = this.envp();
        SortUtil.sort((Object[])envp);
        for (int i = 0; i < envp.length; ++i) {
            if (!TextUtil.toUpperCase((String)envp[i]).startsWith(prefix)) continue;
            this.out.println("  " + (String)envp[i]);
        }
    }

    public void reset(Expr expr) {
        if (expr != null && expr.help()) {
            this.out.println();
            this.out.println(" reset");
            this.out.println("   Reset the environment to its default state");
            this.out.println();
            return;
        }
        this.env = new HashMap();
        this.env.put("BAJAHOME", Sys.getNiagaraHome().toString());
        this.env.put("niagara_home", Sys.getNiagaraHome().toString());
        this.env.put("NIAGARA_USER_HOME", Sys.getNiagaraUserHome().toString());
        this.env.put("JAVA_HOME", Sys.getNiagaraHome().toString() + File.separator + "jre");
        this.mapenv("PATH");
        if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
            this.mapenv("USERDNSDOMAIN");
            this.mapenv("USERDOMAIN");
            this.mapenv("USERNAME");
            this.mapenv("SYSTEMROOT");
            this.mapenv("TEMP");
        } else {
            this.mapenv("LD_LIBRARY_PATH");
            this.env.put("niagara_home", Sys.getNiagaraHome().toString());
        }
        String currentPath = this.getenv("PATH");
        String relBin = Sys.getNiagaraHome().toString() + File.separator + "bin";
        boolean putInPath = true;
        if (currentPath != null && currentPath.contains(relBin)) {
            putInPath = false;
        }
        if (putInPath) {
            this.setenv("PATH", relBin + File.pathSeparator + this.getenv("PATH"));
        }
        this.cd = Sys.getNiagaraUserHome();
    }

    private void mapenv(String key) {
        this.setenv(key, NreLib.getenv((String)key));
    }

    public File[] path() {
        String s = this.getenv("PATH");
        if (s == null) {
            return new File[0];
        }
        String[] tok = TextUtil.split((String)s, (char)File.pathSeparatorChar);
        File[] result = new File[tok.length];
        for (int i = 0; i < tok.length; ++i) {
            result[i] = new File(tok[i]);
        }
        return result;
    }

    public File which(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            return f;
        }
        File[] path = this.path();
        for (int i = 0; i < path.length; ++i) {
            f = new File(path[i], filename);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public void which(Expr expr) {
        if (expr.help() || expr.args.length == 0) {
            this.out.println();
            this.out.println(" which <filename>");
            this.out.println("   Find the first occurrence of filename in path list");
            this.out.println();
            return;
        }
        File file = this.which(expr.args[0]);
        if (file == null) {
            this.out.println("Not found");
        } else {
            this.out.println(file);
        }
    }

    public void run(Expr expr) throws Exception {
        File file = this.which(expr.cmd);
        if (file == null) {
            this.out.print("Not Found: " + expr.cmd);
            return;
        }
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                this.exec(line);
            }
        }
    }

    public void print(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" print <message>");
            this.out.println("   Echo message to output stream");
            this.out.println();
            return;
        }
        String s = expr.string;
        int space = s.indexOf(32);
        String msg = "";
        if (space > 0) {
            msg = s.substring(space + 1);
        }
        this.out.println(msg);
    }

    public void help(Expr expr) {
        if (expr.help()) {
            this.out.println();
            this.out.println(" help");
            this.out.println("   Display help summary");
            this.out.println();
            return;
        }
        this.out.println();
        this.out.println("Niagara Shell Help (Version " + BModule.getClassVersion(NShell.class) + ")");
        this.out.println("  cd     View and change current directory");
        this.out.println("  debug  Turn debug tracing on and off");
        this.out.println("  print  Print to the output stream");
        this.out.println("  reset  Reset the environment to its default state");
        this.out.println("  set    View and modify environment variables");
        this.out.println("  which  Resolve a filename in path");
        this.out.println();
        this.out.println("Additional help available via <cmd> -?");
        this.out.println();
    }

    public void exec(String exprStr) throws Exception {
        if (HEADLESS) {
            throw new UnsupportedOperationException("Display required to launch external application");
        }
        if (exprStr.equals("")) {
            return;
        }
        Expr expr = Expr.parse(this, exprStr);
        String cmd = expr.cmd;
        if (cmd.equals("?")) {
            this.help(expr);
            return;
        }
        if (cmd.equals("cd")) {
            this.cd(expr);
            return;
        }
        if (cmd.equals("debug")) {
            this.debug(expr);
            return;
        }
        if (cmd.equals("help")) {
            this.help(expr);
            return;
        }
        if (cmd.equals("print")) {
            this.print(expr);
            return;
        }
        if (cmd.equals("reset")) {
            this.reset(expr);
            return;
        }
        if (cmd.equals("set")) {
            this.set(expr);
            return;
        }
        if (cmd.equals("which")) {
            this.which(expr);
            return;
        }
        if (cmd.endsWith(".nsh")) {
            this.run(expr);
            return;
        }
        String[] syscmd = OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows) ? new String[]{"cmd.exe", "/c", "\"" + exprStr + "\""} : NShell.splitIgnoreSpacesInQuotes(exprStr);
        this.exec = new Exec(this, syscmd, this.envp(), this.cd, this.out);
        this.exec.start();
    }

    static String[] splitIgnoreSpacesInQuotes(String s) {
        char[] chars = s.toCharArray();
        Array split = new Array(String.class);
        StringBuffer buf = new StringBuffer();
        boolean inQuotes = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"') {
                if (!inQuotes && chars[i + 1] == '\"') {
                    split.add((Object)"\"\"");
                }
                inQuotes = !inQuotes;
                continue;
            }
            if (!inQuotes && chars[i] == ' ') {
                if (buf.length() <= 0) continue;
                split.add((Object)buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(chars[i]);
        }
        if (buf.length() > 0) {
            split.add((Object)buf.toString());
        }
        return (String[])split.trim();
    }

    public boolean inExec() {
        return this.exec != null;
    }

    public void execWaitUntilDone() throws Exception {
        this.exec.waitUntilDone();
    }

    public void execDone(int exitCode) {
        this.exec = null;
    }

    public void execKill() {
        this.out.println("***Kill***");
        if (this.exec != null) {
            this.exec.kill();
        }
    }
}

