/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.authn.BAuthenticationService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.workbench.auth.PasswordUtils;
import com.tridium.workbench.user.BUserMgrTable;
import com.tridium.workbench.util.WbUtil;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.naming.BISession;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTagDictionary;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BUserManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BUserManager.class);
    static final Lexicon lex = Lexicon.make(BUserManager.class);
    static final String lexNever = lex.getText("never");
    static final String lexExpired = lex.getText("expired");
    MgrColumn colName = new UserNameColumn();
    MgrColumn colFullName = new UserProp(BUser.fullName, 1);
    MgrColumn colEnabled = new UserProp(BUser.enabled, 1);
    MgrColumn colExpiration = new ExpirationColumn();
    MgrColumn colLockOut = new UserProp(BUser.lockOut, 2);
    MgrColumn colRoles = new UserProp(BUser.roles, 3);
    MgrColumn colAllowConcurrentSession = new UserProp(BUser.allowConcurrentSessions, 1);
    MgrColumn colAutoLogoffSettings = new UserProp(BUser.autoLogoffSettings, 1);
    MgrColumn colLanguage = new UserProp(BUser.language, 1);
    MgrColumn colNetworkUser = new UserProp(BUser.networkUser, 1);
    MgrColumn colPrototype = new UserProp(BUser.prototypeName, 1);
    MgrColumn colAuthScheme = new UserProp(BUser.authenticationSchemeName, 1);
    MgrColumn colAuth = new AuthenticatorColumn();
    MgrColumn colEmail = new UserProp(BUser.email, 1);
    MgrColumn colFacets = new UserProp(BUser.facets, 3);
    MgrColumn colNavFile = new UserProp(BUser.navFile, 3);
    MgrColumn colCellPhoneNumber = new UserProp(BUser.cellPhoneNumber, 3);
    protected MgrColumn[] cols = new MgrColumn[]{this.colName, this.colFullName, this.colEnabled, this.colExpiration, this.colLockOut, this.colRoles, this.colAllowConcurrentSession, this.colAutoLogoffSettings, this.colNetworkUser, this.colPrototype, this.colLanguage, this.colAuthScheme, this.colAuth, this.colEmail, this.colCellPhoneNumber, this.colFacets, this.colNavFile};
    BUserService service;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.service = (BUserService)value;
        super.doLoadValue(value, cx);
    }

    protected MgrTagDictionary makeTagDictionary() {
        return null;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    void validate(MgrEditRow row) throws Exception {
        BUser user = (BUser)row.getTarget();
        BAbstractAuthenticator auth = (BAbstractAuthenticator)row.getCell(this.colAuth);
        auth.lease(1);
        String authName = ((BString)row.getCell(this.colAuthScheme)).getString();
        BAuthenticationService service = (BAuthenticationService)WbUtil.findService((BWidget)this, (Type)BAuthenticationService.TYPE);
        service.lease(1);
        BAuthenticationScheme scheme = service.getAuthenticationScheme(authName);
        if (scheme instanceof BPasswordAuthenticationScheme && auth instanceof BPasswordAuthenticator) {
            BPasswordAuthenticationScheme passScheme = (BPasswordAuthenticationScheme)scheme;
            passScheme.lease(1);
            BPasswordAuthenticator passAuth = (BPasswordAuthenticator)auth;
            BPassword pass = passAuth.getPassword();
            if (pass.getPasswordEncoder().isReversible()) {
                BPasswordAuthenticator.checkPassword((BUser)user, (BPasswordAuthenticationScheme)passScheme, (BUserPasswordConfiguration)passAuth.getPasswordConfig(), (BPassword)pass, (Context)this.getCurrentContext());
            }
        }
    }

    class ExpirationColumn
    extends UserProp {
        ExpirationColumn() {
            super(BUser.expiration, 1);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BWbEditor editor = super.toEditor(rows, colIndex, currentEditor);
            boolean enabled = true;
            for (int i = 0; i < rows.length; ++i) {
                enabled &= !"admin".equals(((BUser)rows[i].getTarget()).getUsername());
            }
            if (editor != null) {
                editor.setEnabled(enabled);
            }
            return editor;
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BAbsTime t = (BAbsTime)value;
            if (t.isNull()) {
                return lexNever;
            }
            if (BUser.isExpired((BAbsTime)t)) {
                return lexExpired;
            }
            return t.toDateString(cx);
        }
    }

    class AuthenticatorColumn
    extends UserProp {
        AuthenticatorColumn() {
            super(BUser.authenticator, 3);
        }

        public BValue load(MgrEditRow row) {
            BPassword pass;
            BValue auth = row.getTarget().get(this.prop);
            if (auth instanceof BPasswordCache && !((BPasswordCache)auth).isMounted() && (pass = ((BPasswordCache)auth).getPassword()).isDefault()) {
                ((BPasswordCache)auth).setPassword(BPassword.make((String)""));
            }
            return auth;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            BValue old = target.get(this.prop);
            if (!old.equivalent((Object)value)) {
                BValue authCopy = value.newCopy();
                if (authCopy instanceof BPasswordCache) {
                    ((BPasswordCache)authCopy).setPassword(((BPasswordCache)value).getPassword());
                }
                target.set(this.prop, authCopy, cx);
            }
        }
    }

    class UserNameColumn
    extends MgrColumn.Name {
        UserNameColumn() {
        }

        public Object get(Object target) {
            String s = (String)super.get(target);
            if (s.equals("Admin")) {
                return BString.make((String)"admin");
            }
            if (s.equals("Guest")) {
                return BString.make((String)"guest");
            }
            return s;
        }
    }

    static class UserProp
    extends MgrColumn.Prop {
        public UserProp(Property prop, int flags) {
            super(prop, flags);
        }

        public Property getProperty() {
            return this.prop;
        }
    }

    class Edit
    extends MgrEdit {
        Edit(BAbstractManager mgr, String label) {
            super(mgr, label);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact invoke(Context cx) throws Exception {
            BFoxSession foxSession = null;
            BISession session = BUserManager.this.getCurrentValueSession();
            if (session instanceof BFoxSession) {
                foxSession = (BFoxSession)session;
                foxSession.setThreadLocalSessionId();
            }
            try {
                CommandArtifact commandArtifact = super.invoke(cx);
                return commandArtifact;
            }
            finally {
                if (foxSession != null) {
                    foxSession.clearThreadLocalSessionId();
                }
            }
        }

        public void validate(MgrEditRow row) throws Exception {
            BUserManager.this.validate(row);
        }

        public boolean isReadonly(MgrEditRow[] selectedRows, MgrColumn col) {
            boolean readonly = super.isReadonly(selectedRows, col);
            if (!readonly) {
                Property colProp;
                BUser currentUser = null;
                Property property = colProp = col instanceof UserProp ? ((UserProp)col).getProperty() : null;
                if (colProp != null || col instanceof MgrColumn.MixIn) {
                    try {
                        BString username;
                        Context cx = this.getManager().getCurrentContext();
                        BString bString = username = cx != null ? (BString)cx.getFacet("username") : null;
                        if (username != null) {
                            currentUser = BUserManager.this.service.getUser(username.toString());
                        }
                    }
                    catch (Exception cx) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < selectedRows.length; ++i) {
                    Object mixin;
                    BUser user = (BUser)selectedRows[i].getTarget();
                    BComponent parentComp = (BComponent)user.getParent();
                    Property prop = user.getPropertyInParent();
                    if (parentComp != null && prop != null && !prop.isFrozen() && Flags.isReadonly((BComplex)parentComp, (Slot)prop)) {
                        readonly = true;
                        break;
                    }
                    if (currentUser != null && colProp != null) {
                        try {
                            currentUser.checkWrite((BComponent)user, (Slot)colProp);
                            continue;
                        }
                        catch (PermissionException pe) {
                            readonly = true;
                            break;
                        }
                    }
                    if (colProp != null) {
                        readonly = Flags.isReadonly((BComplex)user, (Slot)colProp);
                        continue;
                    }
                    if (currentUser == null || !(col instanceof MgrColumn.MixIn) || !((mixin = ((MgrColumn.MixIn)col).get((Object)user)) instanceof BComplex) || (prop = ((BComplex)mixin).getPropertyInParent()) == null) continue;
                    try {
                        currentUser.checkWrite((BComponent)user, (Slot)prop);
                        continue;
                    }
                    catch (PermissionException pe) {
                        readonly = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return readonly;
        }
    }

    class Controller
    extends MgrController {
        Controller(BUserManager mgr) {
            super((BAbstractManager)mgr);
            BISession session = this.getManager().getCurrentValueSession();
            if (!PasswordUtils.isPasswordChangeAllowed((BISession)session)) {
                this.newCommand.setEnabled(false);
            }
        }

        public MgrEdit makeEdit(String label) {
            return new Edit(this.getManager(), label);
        }
    }

    class Model
    extends MgrModel {
        Model(BUserManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected BMgrTable makeTable() {
            return new BUserMgrTable(this);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(BUserManager.this.cols, BUser.TYPE);
        }

        public int getSubscribeDepth() {
            return 3;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BUser.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((BComponent)new BUser())};
        }

        public BComponent newInstance(MgrTypeInfo type) {
            BUser def = (BUser)BUserManager.this.service.getUserPrototypes().getDefaultPrototype().newCopy();
            return def;
        }
    }
}

