/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.workbench.fieldeditors.BDialogFE;
import com.tridium.workbench.user.BPermissionGrid;
import com.tridium.workbench.util.WbUtil;
import javax.baja.role.BIRoleService;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public class BPermissionsMapFE
extends BDialogFE {
    public static final Type TYPE = Sys.loadType(BPermissionsMapFE.class);
    static final Lexicon lex = Lexicon.make(BPermissionsMapFE.class);
    BCheckBox superUser = new BCheckBox((ToggleCommand)new SuperUserToggle((BWidget)this));
    boolean isSuperUserProfile;
    BTextField field = new BTextField("", 40, false);
    BPermissionsMap map;
    BPermissionsMap max = BPermissionsMap.SUPER_USER;

    public Type getType() {
        return TYPE;
    }

    public BPermissionsMapFE() {
        BGridPane pane = new BGridPane(3);
        pane.add(null, (BValue)this.superUser);
        pane.add(null, (BValue)this.field);
        pane.add(null, (BValue)this.getEditButton());
        this.getEditButton().computePreferredSize();
        BConstrainedPane constraint = new BConstrainedPane((BWidget)pane);
        constraint.setMinHeight(this.getEditButton().getPreferredHeight());
        this.setContent((BWidget)constraint);
    }

    public void doSetReadonly(boolean readonly) {
        super.doSetReadonly(readonly);
        this.superUser.setEnabled(!readonly);
        this.updateDisplay();
    }

    protected void doLoadValue(BObject v, Context cx) {
        try {
            BIRoleService roleService;
            BUser user;
            BUserService userService;
            BString username;
            BString bString = username = cx != null ? (BString)cx.getFacet("username") : null;
            if (username != null && (userService = (BUserService)WbUtil.findService((BWidget)this, (Type)BUserService.TYPE)) != null && (user = userService.getUser(username.toString())) != null && (roleService = (BIRoleService)WbUtil.findService((BWidget)this, (Type)BIRoleService.TYPE)) != null) {
                roleService.lease(1, 30000L);
                user.lease();
                this.max = user.getPermissions(roleService);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.map = (BPermissionsMap)v;
        this.superUser.setSelected(this.map.isSuperUser());
        this.field.setText(this.map.toString(cx));
        this.superUser.setEnabled(!this.isReadonly() && this.max.isSuperUser());
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        return this.map;
    }

    public void doEditPressed() {
        BPermissionsMap result = BPermissionGrid.open(this.getWbShell(), this.map, this.max);
        if (result != null) {
            this.map = result;
            this.setModified();
            this.updateDisplay();
        }
    }

    void updateDisplay() {
        this.getEditButton().setVisible(!this.isReadonly() && !this.superUser.isSelected());
        if (this.map != null) {
            this.field.setText(this.map.toString());
        }
        this.relayout();
    }

    class SuperUserToggle
    extends ToggleCommand {
        SuperUserToggle(BWidget owner) {
            super(owner, lex.getText("superUser"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BPermissionsMapFE.this.map = sel ? BPermissionsMap.SUPER_USER : BPermissionsMap.DEFAULT;
            BPermissionsMapFE.this.setModified();
            BPermissionsMapFE.this.updateDisplay();
        }
    }
}

