/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.user.BPermissionsBrowser;
import java.util.Map;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.LexiconModule;
import javax.baja.util.PatternFilter;

@NiagaraType
@NiagaraProperty(name="content", type="BWidget", defaultValue="new BNullWidget()", flags=4)
@NiagaraActions(value={@NiagaraAction(name="updateList", flags=4), @NiagaraAction(name="updateSelections", flags=4)})
public class BPermissionsBrowserFilteredCheckListPane
extends BPane {
    public static final Property content = BPermissionsBrowserFilteredCheckListPane.newProperty((int)4, (BValue)new BNullWidget(), null);
    public static final Action updateList = BPermissionsBrowserFilteredCheckListPane.newAction((int)4, null);
    public static final Action updateSelections = BPermissionsBrowserFilteredCheckListPane.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BPermissionsBrowserFilteredCheckListPane.class);
    public static final LexiconModule LEXICON = LexiconModule.make(BPermissionsBrowser.class);
    private final Map<BComplex, Boolean> selectedItemsMap;
    private final Context context;
    private final BTextField searchField;
    private final BCheckList checkList;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public void updateList() {
        this.invoke(updateList, null, null);
    }

    public void updateSelections() {
        this.invoke(updateSelections, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPermissionsBrowserFilteredCheckListPane() {
        throw new IllegalStateException();
    }

    public BPermissionsBrowserFilteredCheckListPane(String title, Map<BComplex, Boolean> selectedItemsMap, Context context) {
        this.selectedItemsMap = selectedItemsMap;
        this.context = context;
        BEdgePane selPane = new BEdgePane();
        selPane.setLeft((BWidget)new BLabel(title));
        this.searchField = new BTextField("", title.length());
        this.searchField.setRenderer((TextRenderer)new SearchFieldRenderer());
        this.linkTo((BComponent)this.searchField, (Slot)BTextEditor.textModified, (Slot)updateList);
        BGridPane searchFieldGrid = new BGridPane(2);
        searchFieldGrid.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"filter.png"))));
        searchFieldGrid.add(null, (BValue)this.searchField);
        BEdgePane top = new BEdgePane();
        top.setTop((BWidget)selPane);
        top.setLeft((BWidget)new BBorderPane((BWidget)searchFieldGrid, 5.0, 0.0, 0.0, 0.0));
        this.checkList = new BCheckList();
        this.checkList.setRenderer((ListRenderer)new BrowserItemsRenderer());
        this.doUpdateList();
        this.linkTo((BComponent)this.checkList, (Slot)BList.selectionModified, (Slot)updateSelections);
        BConstrainedPane center = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.checkList, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        center.setMinWidth(selPane.getWidth());
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)top, 0.0, 0.0, 10.0, 0.0));
        edge.setCenter((BWidget)center);
        this.setContent((BWidget)new BBorderPane((BWidget)edge, 10.0, 10.0, 10.0, 10.0));
    }

    public void started() throws Exception {
        this.searchField.requestFocus();
    }

    public void computePreferredSize() {
        BWidget cn = this.getContent();
        cn.computePreferredSize();
        this.setPreferredSize(cn.getPreferredWidth(), cn.getPreferredHeight());
    }

    public void doLayout(BWidget[] children) {
        this.getContent().setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void doUpdateList() {
        this.checkList.removeAllItems();
        String searchText = this.searchField.getText().trim().toLowerCase();
        if (!searchText.isEmpty()) {
            searchText = searchText + "*";
            PatternFilter filter = new PatternFilter(searchText);
            this.selectedItemsMap.entrySet().stream().filter(e -> filter.accept(((BComplex)e.getKey()).getDisplayName(this.context).toLowerCase())).forEach(e -> this.addItem((BComplex)e.getKey(), (Boolean)e.getValue()));
        } else {
            this.selectedItemsMap.forEach(this::addItem);
        }
    }

    private void addItem(BComplex complex, Boolean isSelected) {
        this.checkList.addItem((Object)complex);
        int index = this.checkList.indexOfItem((Object)complex);
        if (isSelected.booleanValue()) {
            this.checkList.getSelection().select(index);
        } else {
            this.checkList.getSelection().deselect(index);
        }
    }

    public void doUpdateSelections() {
        int len = this.checkList.getItemCount();
        for (int i = 0; i < len; ++i) {
            Object item = this.checkList.getItem(i);
            if (!(item instanceof BComplex)) continue;
            this.selectedItemsMap.replace((BComplex)item, this.checkList.isSelected(i));
        }
    }

    private class SearchFieldRenderer
    extends TextRenderer {
        private SearchFieldRenderer() {
        }

        public void paintLine(Graphics g, TextRenderer.LineInfo info) {
            if (info.line.segments.length == 0) {
                TextRenderer.LineInfo info2 = new TextRenderer.LineInfo();
                info2.lineIndex = 0;
                info2.selectionStartColumn = 0;
                info2.selectionEndColumn = 0;
                String filterText = LEXICON.getText("permissions.filterBoxText", BPermissionsBrowserFilteredCheckListPane.this.context);
                info2.line = new Line(filterText.toCharArray(), new Segment[]{new Segment(-1, 0, filterText.length())});
                super.paintLine(g, info2);
            } else {
                super.paintLine(g, info);
            }
        }

        public BBrush getForeground(Segment seg) {
            if (seg.type == -1) {
                return Theme.textEditor().getDisabledTextBrush();
            }
            return super.getForeground(seg);
        }
    }

    private class BrowserItemsRenderer
    extends BCheckList.CheckListRenderer {
        private BrowserItemsRenderer() {
        }

        public String getItemText(ListRenderer.Item item) {
            if (item.value instanceof BComplex) {
                return ((BComplex)item.value).getDisplayName(BPermissionsBrowserFilteredCheckListPane.this.context);
            }
            return super.getItemText(item);
        }
    }
}

