/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.category.Category;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BPermissionGrid
extends BWidget {
    public static final Type TYPE = Sys.loadType(BPermissionGrid.class);
    static final int CHECK_COUNT = 6;
    static final double CHECKW = 20.0;
    static final Lexicon lex = Lexicon.make(BPermissionGrid.class);
    static final String lexTitle = lex.getText("permission.permissions");
    static final String lexCategory = lex.getText("category.category");
    static final String lexOperator = UiLexicon.bajaui().getText("security.operator");
    static final String lexAdmin = UiLexicon.bajaui().getText("security.admin");
    static final String[] lexPermissions = new String[]{UiLexicon.bajaui().getText("security.r").trim(), UiLexicon.bajaui().getText("security.w").trim(), UiLexicon.bajaui().getText("security.i").trim(), UiLexicon.bajaui().getText("security.r").trim(), UiLexicon.bajaui().getText("security.w").trim(), UiLexicon.bajaui().getText("security.i").trim()};
    protected static final BBrush headerGrid = BColor.make((int)50, (int)50, (int)50).toBrush();
    protected static final BBrush gridColor = Theme.table().getGridBrush();
    protected static final BBrush impliedColor = BColor.make((int)-6710887).toBrush();
    static final int OR = 0;
    static final int OW = 1;
    static final int OI = 2;
    static final int AR = 3;
    static final int AW = 4;
    static final int AI = 5;
    Model model;
    protected BTable table;
    BPermissionsMap map;
    protected Row[] rows;
    protected double blockWidth = 0.0;

    public Type getType() {
        return TYPE;
    }

    public static BPermissionsMap open(BWbShell shell, BPermissionsMap map, BPermissionsMap max) {
        return BPermissionGrid.open(shell, map, max, lexTitle);
    }

    public static BPermissionsMap open(BWbShell shell, BPermissionsMap map, BPermissionsMap max, String title) {
        try {
            Category[] categories = Category.load((BWbShell)shell, (int)map.size()).categories;
            BPermissionGrid grid = new BPermissionGrid(categories, map, max);
            int r = BDialog.open((BWidget)shell, (String)title, (Object)((Object)grid), (int)3);
            if (r != 1) {
                return null;
            }
            return grid.save();
        }
        catch (Throwable e) {
            BDialog.error((BWidget)shell, (String)BDialog.TITLE_ERROR, (Object)"Cannot config permissions", (Throwable)e);
            return null;
        }
    }

    public BPermissionGrid() {
        throw new IllegalStateException();
    }

    public BPermissionGrid(Category[] categories, BPermissionsMap map, BPermissionsMap maxMap) {
        this.map = map;
        this.model = new Model();
        this.table = new BTable((TableModel)this.model);
        this.table.setHeaderRenderer((TableHeaderRenderer)new HeaderRenderer());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.table.setController((TableController)new Controller());
        this.table.setOptionsButtonVisible(false);
        this.rows = new Row[categories.length];
        for (int i = 1; i < this.rows.length; ++i) {
            BPermissions categoryMax = BPermissions.all;
            if (maxMap != null && maxMap.getPermissions(i) != null) {
                categoryMax = maxMap.getPermissions(i);
            }
            this.rows[i] = new Row(categories[i], map.getPermissions(i), categoryMax);
        }
        this.add("table", (BValue)this.table);
    }

    public BPermissionsMap save() {
        BPermissions[] p = new BPermissions[this.rows.length];
        for (int i = 1; i < p.length; ++i) {
            p[i] = BPermissions.make((int)this.rows[i].toMask());
        }
        return BPermissionsMap.make((BPermissions[])p);
    }

    public Row[] getSelectedRows() {
        int[] indices = this.table.getSelection().getRows();
        Row[] x = new Row[indices.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.rows[indices[i] + 1];
        }
        return x;
    }

    public void computePreferredSize() {
        this.blockWidth = 20.0;
        BFont hf = Theme.table().getHeaderFont();
        double tw = Math.max(hf.width(lexOperator), hf.width(lexAdmin)) + 10.0;
        this.blockWidth = Math.max(this.blockWidth, (double)((int)(tw / 3.0)));
        BFont cf = Theme.table().getCellFont();
        double cw = 0.0;
        for (int i = 0; i < lexPermissions.length; ++i) {
            cw = Math.max(cw, cf.width(lexPermissions[i]) + 10.0);
        }
        this.blockWidth = Math.max(this.blockWidth, cw);
        this.table.computePreferredSize();
        double pw = this.table.getPreferredWidth();
        if (pw > 800.0) {
            pw = 800.0;
        }
        if (pw < 300.0) {
            pw = 300.0;
        }
        this.setPreferredSize(pw, 300.0);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.table.setBounds(0.0, 0.0, w, h);
    }

    public static class Row {
        public BPermissions max;
        public int index;
        public String display;
        public boolean[] enabled = new boolean[6];
        public boolean[] checks = new boolean[6];
        public boolean[] implied = new boolean[6];

        public Row(Category category, BPermissions cur, BPermissions max) {
            this.index = category.index;
            this.display = category.display;
            this.max = max;
            this.setPermissions(cur);
        }

        public String toString() {
            return this.display;
        }

        public int toMask() {
            int mask = 0;
            if (this.checks[0]) {
                mask |= 1;
            }
            if (this.checks[1]) {
                mask |= 2;
            }
            if (this.checks[2]) {
                mask |= 4;
            }
            if (this.checks[3]) {
                mask |= 0x10;
            }
            if (this.checks[4]) {
                mask |= 0x20;
            }
            if (this.checks[5]) {
                mask |= 0x40;
            }
            return mask;
        }

        public void setPermissions(BPermissions cur) {
            this.checks[0] = cur.hasOperatorRead();
            this.checks[1] = cur.hasOperatorWrite();
            this.checks[2] = cur.hasOperatorInvoke();
            this.checks[3] = cur.hasAdminRead();
            this.checks[4] = cur.hasAdminWrite();
            this.checks[5] = cur.hasAdminInvoke();
            this.enabled[0] = this.max.hasOperatorRead() || this.max.hasAdminRead() || cur.hasOperatorRead();
            this.enabled[1] = this.max.hasOperatorWrite() || this.max.hasAdminWrite() || cur.hasOperatorWrite();
            this.enabled[2] = this.max.hasOperatorInvoke() || this.max.hasAdminInvoke() || cur.hasOperatorInvoke();
            this.enabled[3] = this.max.hasAdminRead() || cur.hasAdminRead();
            this.enabled[4] = this.max.hasAdminWrite() || cur.hasAdminWrite();
            this.enabled[5] = this.max.hasAdminInvoke() || cur.hasAdminInvoke();
            this.calculateImplied();
        }

        public void setCheck(int checkIndex, boolean state) {
            if (this.enabled[checkIndex]) {
                this.checks[checkIndex] = state;
            }
            this.calculateImplied();
        }

        public void calculateImplied() {
            int i;
            for (i = 0; i < this.implied.length; ++i) {
                this.implied[i] = false;
            }
            if (this.checks[1]) {
                this.implied[0] = true;
            }
            if (this.checks[3]) {
                this.implied[0] = true;
            }
            if (this.checks[4]) {
                this.implied[3] = true;
                this.implied[1] = true;
                this.implied[0] = true;
            }
            if (this.checks[5]) {
                this.implied[2] = true;
            }
            for (i = 0; i < this.implied.length; ++i) {
                if (!this.implied[i]) continue;
                this.checks[i] = false;
            }
        }
    }

    protected class Controller
    extends TableController {
        protected Controller() {
        }

        protected void headerPressed(BMouseEvent event, int column) {
            if (column != 1) {
                super.headerPressed(event, column);
                return;
            }
            RectGeom r = BPermissionGrid.this.table.getHeaderBounds(column);
            double x = event.getX() - r.x;
            double y = event.getY() - r.y;
            if (y < 18.0) {
                return;
            }
            int index = (int)(x / BPermissionGrid.this.blockWidth);
            if (index >= 6) {
                return;
            }
            Row[] rows = BPermissionGrid.this.getSelectedRows();
            if (rows.length == 0) {
                return;
            }
            boolean state = !rows[0].checks[index];
            for (int i = 0; i < rows.length; ++i) {
                rows[i].setCheck(index, state);
            }
            BPermissionGrid.this.repaint();
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (column != 1) {
                super.cellPressed(event, row, column);
                return;
            }
            RectGeom r = BPermissionGrid.this.table.getCellBounds(row, column);
            double x = event.getX() - r.x;
            int index = (int)(x / BPermissionGrid.this.blockWidth);
            if (index >= 6) {
                return;
            }
            Row active = BPermissionGrid.this.rows[row + 1];
            boolean state = !active.checks[index];
            active.setCheck(index, state);
            this.getTable().fireTableModified((BWidgetEvent)event);
            BPermissionGrid.this.repaint();
        }
    }

    protected class CellRenderer
    extends TableCellRenderer {
        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            Row row = (Row)cell.value;
            if (cell.column == 1) {
                return BPermissionGrid.this.blockWidth * 6.0;
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            Row row = (Row)cell.value;
            BTable table = this.getTable();
            BBrush fg = Theme.table().getTextBrush((IStylable)table);
            BBrush bg = Theme.table().getControlBackground((IStylable)table);
            if (cell.column == 0 && cell.selected) {
                fg = Theme.table().getSelectionForeground((IStylable)table);
                bg = Theme.table().getSelectionBackground((IStylable)table);
            }
            g.setBrush(bg);
            g.fillRect(0.0, 0.0, cell.width, cell.height);
            g.setBrush(fg);
            g.setFont(Theme.table().getCellFont());
            if (cell.column == 0) {
                g.drawString(row.display, 3.0, cell.height - 10.0);
            } else if (cell.column == 1) {
                this.paintPermission(g, cell, row);
            }
        }

        public void paintPermission(Graphics g, TableCellRenderer.Cell cell, Row row) {
            for (int i = 0; i < row.checks.length; ++i) {
                double x = (double)i * BPermissionGrid.this.blockWidth;
                boolean check = row.checks[i];
                boolean implied = row.implied[i];
                boolean enabled = row.enabled[i];
                if (!enabled) {
                    BBrush grid = this.getTable().getGridBrush();
                    if (!grid.isNull()) {
                        g.setBrush(grid);
                    } else {
                        g.setBrush(Theme.table().getGridBrush());
                    }
                    g.fillRect(x + 1.0, 0.0, BPermissionGrid.this.blockWidth - 1.0, BPermissionGrid.this.blockWidth);
                }
                if (check || implied) {
                    if (implied) {
                        g.setBrush(impliedColor);
                    } else {
                        g.setBrush(BColor.make((int)-16744448));
                    }
                    double dx = x + (BPermissionGrid.this.blockWidth - 6.0) / 2.0;
                    double dy = 10.0;
                    g.strokeLine(dx, dy + 4.0, dx + 2.0, dy + 6.0);
                    g.strokeLine(dx + 1.0, dy + 4.0, dx + 2.0, dy + 5.0);
                    g.strokeLine(dx + 1.0, dy + 3.0, dx + 3.0, dy + 5.0);
                    g.strokeLine(dx + 2.0, dy + 4.0, dx + 6.0, dy);
                    g.strokeLine(dx + 2.0, dy + 5.0, dx + 6.0, dy + 1.0);
                    g.strokeLine(dx + 3.0, dy + 5.0, dx + 7.0, dy + 1.0);
                }
                g.setBrush(gridColor);
                g.strokeLine(x + BPermissionGrid.this.blockWidth, 0.0, x + BPermissionGrid.this.blockWidth, cell.height);
            }
        }
    }

    protected class HeaderRenderer
    extends TableHeaderRenderer {
        protected HeaderRenderer() {
        }

        public double getHeaderHeight() {
            return 35.0;
        }

        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            if (header.column == 1) {
                return BPermissionGrid.this.blockWidth * 6.0;
            }
            return super.getPreferredHeaderWidth(header) + 20.0;
        }

        public void paintHeader(Graphics g, TableHeaderRenderer.Header header) {
            Theme.table().paintHeaderBackground(g, header, this.getBackground(header));
            BFont font = Theme.table().getHeaderFont();
            g.setFont(font);
            BBrush fg = this.getForeground(header);
            g.setBrush(fg);
            if (header.column == 0) {
                g.drawString(lexCategory, 5.0, 22.0);
                if (this.getTable().getSortColumn() == header.column) {
                    boolean ascending = this.getTable().isSortAscending();
                    Theme.table().paintSortIcon(g, header, ascending);
                }
            } else {
                double tw = font.width(lexOperator);
                g.drawString(lexOperator, (BPermissionGrid.this.blockWidth * 3.0 - tw) / 2.0, 15.0);
                tw = font.width(lexAdmin);
                g.drawString(lexAdmin, BPermissionGrid.this.blockWidth * 3.0 + (BPermissionGrid.this.blockWidth * 3.0 - tw) / 2.0, 15.0);
                for (int i = 0; i < 6; ++i) {
                    double x = BPermissionGrid.this.blockWidth * (double)i;
                    String t = lexPermissions[i];
                    tw = font.width(t);
                    g.setBrush(fg);
                    g.drawString(t, x + 2.0 + (BPermissionGrid.this.blockWidth - tw) / 2.0, 31.0);
                    g.setBrush(headerGrid);
                    g.strokeLine(x + BPermissionGrid.this.blockWidth + 1.0, 19.0, x + BPermissionGrid.this.blockWidth + 1.0, 31.0);
                }
                g.setBrush(headerGrid);
                g.strokeLine(BPermissionGrid.this.blockWidth * 3.0 + 1.0, 3.0, BPermissionGrid.this.blockWidth * 3.0 + 1.0, 31.0);
            }
        }
    }

    protected class Model
    extends TableModel {
        protected Model() {
        }

        public int getRowCount() {
            return BPermissionGrid.this.rows.length - 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return "?";
        }

        public Object getSubject(int row) {
            return BPermissionGrid.this.rows[row + 1];
        }

        public Object getValueAt(int row, int col) {
            return BPermissionGrid.this.rows[row + 1];
        }
    }
}

