/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors.gx;

import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import com.tridium.workbench.colorchooser.BGradientEditor;
import com.tridium.workbench.fieldeditors.BOrdFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BBrushFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BBrushFE.class);
    static BModule module = Sys.getModuleForClass(BBrushFE.class);
    private BBrushSwatch swatch = new BBrushSwatch();
    private BLabel label;
    private BButton button;

    public Type getType() {
        return TYPE;
    }

    public BBrushFE() {
        this.swatch.setPreferredSize(24.0, 16.0);
        this.swatch.setController(new SwatchController());
        this.label = new BLabel();
        this.button = new BButton(BImage.make((String)"module://icons/x16/edit.png"));
        this.button.setButtonStyle(BButtonStyle.toolBar);
        this.button.setMenuController((BAbstractButton.MenuController)new MenuController());
        BGridPane grid = new BGridPane(3);
        grid.setColumnGap(5.0);
        grid.add(null, (BValue)new BBorderPane((BWidget)this.swatch, BBorder.inset, BInsets.DEFAULT));
        grid.add(null, (BValue)this.label);
        grid.add(null, (BValue)this.button);
        this.setContent((BWidget)grid);
    }

    protected void doSetReadonly(boolean readonly) {
        this.label.setEnabled(!readonly);
        this.button.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BBrush brush = (BBrush)value;
        this.update(brush);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        return this.swatch.getBrush();
    }

    void doSolid() {
        BColor c;
        BBrush brush = this.swatch.getBrush();
        BBrush.Paint paint = brush.getPaint();
        BColor bColor = c = !brush.isNull() && paint instanceof BBrush.Solid ? BColorChooser.openInDialog((BWidget)this, ((BBrush.Solid)paint).getColor()) : BColorChooser.openInDialog((BWidget)this);
        if (c != null) {
            this.update(c.toBrush());
        }
    }

    void doGradient() {
        BBrush brush = this.swatch.getBrush();
        BBrush.Paint paint = brush.getPaint();
        BBrush bBrush = brush = paint instanceof BBrush.Gradient ? BGradientEditor.openInDialog((BWidget)this, brush) : BGradientEditor.openInDialog((BWidget)this, BBrush.NULL);
        if (brush != null) {
            this.update(brush);
        }
    }

    void doImage() {
        try {
            BBrush brush = this.swatch.getBrush();
            BBrush.Paint paint = brush.getPaint();
            if (!(paint instanceof BBrush.Image)) {
                brush = BBrush.NULL;
            }
            BOrd ord = brush.isNull() ? BOrd.NULL : ((BBrush.Image)paint).getImage().getOrdList().get(0);
            BFacets facets = BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IFile"));
            BOrdFE fe = new BOrdFE();
            fe.loadValue((BObject)ord, (Context)facets);
            if (1 == BDialog.open((BWidget)this, (String)"Texture", (Object)fe, (int)3)) {
                brush = BBrush.makeImage((BImage)BImage.make((BOrd)((BOrd)fe.saveValue())));
                this.update(brush);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void doNull() {
        this.update(BBrush.NULL);
    }

    void update(BBrush brush) {
        this.swatch.setBrush(brush);
        if (brush.isNull()) {
            this.label.setText("(null)");
        } else {
            BBrush.Paint paint = brush.getPaint();
            if (paint instanceof BBrush.Solid) {
                this.label.setText(((BBrush.Solid)paint).getColor().toString());
            } else if (paint instanceof BBrush.Gradient) {
                this.label.setText("(gradient)");
            } else if (paint instanceof BBrush.Image) {
                this.label.setText("(image)");
            }
        }
        this.setModified();
        this.relayout();
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton button) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new SolidCommand((BWidget)button));
            menu.add(null, (Command)new GradientCommand((BWidget)button));
            menu.add(null, (Command)new ImageCommand((BWidget)button));
            menu.add(null, (Command)new NullCommand((BWidget)button));
            return menu;
        }
    }

    class SwatchController
    extends BBrushSwatch.Controller {
        SwatchController() {
        }

        @Override
        public void mousePressed(BMouseEvent event) {
            if (BBrushFE.this.isReadonly()) {
                return;
            }
            BBrush brush = this.swatch.getBrush();
            BBrush.Paint paint = brush.getPaint();
            if (paint instanceof BBrush.Solid) {
                BBrushFE.this.doSolid();
            } else if (paint instanceof BBrush.Gradient) {
                BBrushFE.this.doGradient();
            } else if (paint instanceof BBrush.Image) {
                BBrushFE.this.doImage();
            }
        }

        @Override
        public void mouseEntered(BMouseEvent event) {
            if (!BBrushFE.this.isReadonly()) {
                this.swatch.setMouseCursor(MouseCursor.dropper);
            }
        }

        @Override
        public void mouseExited(BMouseEvent event) {
            if (!BBrushFE.this.isReadonly()) {
                this.swatch.setMouseCursor(MouseCursor.normal);
            }
        }
    }

    class NullCommand
    extends Command {
        public NullCommand(BWidget owner) {
            super(owner, module, "brushFE.commands.null");
        }

        public CommandArtifact doInvoke() {
            BBrushFE.this.doNull();
            return null;
        }
    }

    class ImageCommand
    extends Command {
        public ImageCommand(BWidget owner) {
            super(owner, module, "brushFE.commands.image");
        }

        public CommandArtifact doInvoke() {
            BBrushFE.this.doImage();
            return null;
        }
    }

    class GradientCommand
    extends Command {
        public GradientCommand(BWidget owner) {
            super(owner, module, "brushFE.commands.gradient");
        }

        public CommandArtifact doInvoke() {
            BBrushFE.this.doGradient();
            return null;
        }
    }

    class SolidCommand
    extends Command {
        public SolidCommand(BWidget owner) {
            super(owner, module, "brushFE.commands.solid");
        }

        public CommandArtifact doInvoke() {
            BBrushFE.this.doSolid();
            return null;
        }
    }
}

