/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors.facets;

import com.tridium.util.ObjectUtil;
import com.tridium.workbench.cellmini.BMiniListDropDown;
import com.tridium.workbench.cellmini.BMiniTextField;
import com.tridium.workbench.celltable.BCellTable;
import com.tridium.workbench.fieldeditors.facets.BFacetsKeyCE;
import com.tridium.workbench.fieldeditors.facets.BFacetsTypeCE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.data.DataTypes;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.celleditor.BListDropDownCE;
import javax.baja.workbench.celleditor.BTextDropDownCE;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BFacetsEditor
extends BEdgePane {
    public static final Action tableSelectionModified = BFacetsEditor.newAction((int)0, null);
    public static final Action rowKeyModified = BFacetsEditor.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action rowTypeModified = BFacetsEditor.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BFacetsEditor.class);
    private static Lexicon wbLex = Lexicon.make((String)"wbutil");
    private static String lexKey = wbLex.getText("facetsFE.key");
    private static String lexType = wbLex.getText("facetsFE.type");
    private static String lexValue = wbLex.getText("facetsFE.value");
    private BCellTable table;
    private TableSelection tableSel;
    private BButton btnRemove;
    private BButton btnAdd;
    private BMruButton history;
    private List<Row> rows = new ArrayList<Row>();
    private Map<BFacetsKeyCE, Row> keyToRow = new HashMap<BFacetsKeyCE, Row>();
    private Map<BFacetsTypeCE, Row> typeToRow = new HashMap<BFacetsTypeCE, Row>();
    private boolean readonly = false;

    public void tableSelectionModified() {
        this.invoke(tableSelectionModified, null, null);
    }

    public void rowKeyModified(BWidgetEvent event) {
        this.invoke(rowKeyModified, (BValue)event, null);
    }

    public void rowTypeModified(BWidgetEvent event) {
        this.invoke(rowTypeModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BFacets open(BWidget owner, BFacets facets) throws Exception {
        return BFacetsEditor.open(owner, facets, false);
    }

    public static BFacets open(BWidget owner, BFacets facets, boolean readonly) throws Exception {
        String title = UiLexicon.bajaui().getText("commands.configFacets.label");
        return BFacetsEditor.open(owner, title, facets, readonly);
    }

    public static BFacets open(BWidget owner, String title, BFacets facets, boolean readonly) throws Exception {
        BFacetsEditor editor = new BFacetsEditor(facets, readonly);
        int r = BDialog.open((BWidget)owner, (String)title, (Object)((Object)editor), (int)3);
        if (r != 1) {
            return null;
        }
        return editor.save();
    }

    public BFacetsEditor() {
        throw new IllegalStateException();
    }

    public BFacetsEditor(BFacets facets, boolean readonly) {
        this.table = new BCellTable(new String[]{lexKey, lexType, lexValue}, new double[]{120.0, 100.0, 75.0});
        this.tableSel = this.table.getSelection();
        this.table.setCellsEnabled(!readonly);
        this.readonly = readonly;
        String[] names = facets.list();
        BFacets cx = null;
        BObject precision = facets.get("precision");
        if (precision != null) {
            cx = BFacets.make((String)"precision", (BIDataValue)((BIDataValue)precision));
        }
        for (int i = 0; i < names.length; ++i) {
            this.table.addRow(new Row(SlotPath.unescape((String)names[i]), facets.getFacet(names[i]), true, (Context)cx).toArray());
        }
        BConstrainedPane tablePane = new BConstrainedPane((BWidget)this.table);
        tablePane.setMinHeight(150.0);
        tablePane.setMinWidth(300.0);
        this.history = new BMruButton("facetsFE");
        this.history.setMruController((BMruButton.MruController)new MruController());
        this.history.setEnabled(!readonly);
        BGridPane buttons = new BGridPane(4);
        buttons.setHalign(BHalign.right);
        this.btnAdd = BFacetsEditor.newButton(new Add((BWidget)this));
        buttons.add(null, (BValue)this.btnAdd);
        this.btnRemove = BFacetsEditor.newButton(new Remove((BWidget)this));
        buttons.add(null, (BValue)this.btnRemove);
        buttons.add(null, (BValue)this.history);
        this.btnRemove.setEnabled(false);
        this.btnAdd.setEnabled(!readonly);
        BEdgePane buttonPane = new BEdgePane();
        buttonPane.setCenter((BWidget)buttons);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)tablePane);
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 3.0, 0.0, 6.0, 0.0));
        this.setCenter((BWidget)edge);
        this.linkTo("linkTable", (BComponent)this.table, (Slot)BCellTable.selectionModified, (Slot)tableSelectionModified);
    }

    private static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    public BFacets save() throws Exception {
        String[] keys = new String[this.rows.size()];
        BIDataValue[] values = new BIDataValue[this.rows.size()];
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.rows.get(i);
            keys[i] = SlotPath.escape((String)row.keyCe.saveValue().toString());
            values[i] = (BIDataValue)row.valCe.saveValue();
        }
        BFacets facets = BFacets.make((String[])keys, (BIDataValue[])values);
        this.history.getMruOptions().save(facets.encodeToString());
        return facets;
    }

    public void doTableSelectionModified() {
        if (!this.readonly) {
            int n = this.tableSel.getRow();
            this.btnRemove.setEnabled(n != -1);
        }
    }

    public void doRowKeyModified(BWidgetEvent event) {
        Type type;
        BMiniTextField editor = (BMiniTextField)event.getWidget();
        String sym = BFacetsKeyCE.getPredefinedKeys().getProperty(editor.getText());
        if (sym != null && (type = DataTypes.getBySymbol((char)sym.charAt(0))) != null) {
            Row row = this.keyToRow.get(editor.getParent().getParent());
            this.remove((BComplex)row.typeLink);
            row.typeCe.loadValue((BObject)type.getTypeSpec());
            row.typeLink = this.linkTo((BComponent)row.typeCe, (Slot)BListDropDownCE.dropDownModified, (Slot)rowTypeModified);
            BObject instance = type.getInstance();
            row.valCe = BWbCellEditor.makeFor((BObject)instance);
            row.valCe.loadValue(instance);
            int idx = this.rows.indexOf(row);
            this.table.removeRow(idx);
            this.table.insertRow(idx, row.toArray());
            this.table.relayout();
        }
    }

    public void doRowTypeModified(BWidgetEvent event) {
        BMiniListDropDown drop = (BMiniListDropDown)event.getWidget();
        Row row = this.typeToRow.get(drop.getParent());
        int sel = drop.getSelectedIndex();
        BObject instance = BFacetsTypeCE.TYPES[sel].getInstance();
        row.valCe = BWbCellEditor.makeFor((BObject)instance);
        row.valCe.loadValue(instance);
        int idx = this.rows.indexOf(row);
        this.table.removeRow(idx);
        this.table.insertRow(idx, row.toArray());
        this.table.relayout();
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public String toDisplayString(String value) {
            try {
                return BFacets.make((String)value).toString(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return value;
            }
        }

        public void select(String value) {
            try {
                while (BFacetsEditor.this.rows.size() > 0) {
                    Row row = (Row)BFacetsEditor.this.rows.get(0);
                    BFacetsEditor.this.remove((BComplex)row.keyLink);
                    BFacetsEditor.this.remove((BComplex)row.typeLink);
                    BFacetsEditor.this.keyToRow.remove((Object)row.keyCe);
                    BFacetsEditor.this.typeToRow.remove((Object)row.typeCe);
                    BFacetsEditor.this.rows.remove(0);
                    BFacetsEditor.this.table.removeRow(0);
                }
                BFacetsEditor.this.tableSel.deselectAll();
                BFacetsEditor.this.table.relayout();
                BFacets facets = BFacets.make((String)value);
                String[] names = facets.list();
                BFacets cx = null;
                BObject precision = facets.get("precision");
                if (precision != null) {
                    cx = BFacets.make((String)"precision", (BIDataValue)((BIDataValue)precision));
                }
                for (int i = 0; i < names.length; ++i) {
                    BFacetsEditor.this.table.addRow(new Row(names[i], facets.getFacet(names[i]), true, (Context)cx).toArray());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class Row {
        BFacetsKeyCE keyCe = new BFacetsKeyCE();
        BFacetsTypeCE typeCe = new BFacetsTypeCE();
        BWbCellEditor valCe;
        BLink keyLink;
        BLink typeLink;

        Row(String key, BObject value, boolean readOnly, Context cx) {
            this.valCe = BWbCellEditor.makeFor((BObject)value);
            this.keyCe.setReadonly(readOnly);
            this.typeCe.setReadonly(readOnly);
            this.keyCe.loadValue((BObject)BString.make((String)key));
            this.typeCe.loadValue((BObject)value.getType().getTypeSpec());
            this.valCe.loadValue(value, cx);
            this.keyLink = BFacetsEditor.this.linkTo((BComponent)this.keyCe, (Slot)BTextDropDownCE.textModified, (Slot)rowKeyModified);
            this.typeLink = BFacetsEditor.this.linkTo((BComponent)this.typeCe, (Slot)BListDropDownCE.dropDownModified, (Slot)rowTypeModified);
            BFacetsEditor.this.rows.add(this);
            BFacetsEditor.this.keyToRow.put(this.keyCe, this);
            BFacetsEditor.this.typeToRow.put(this.typeCe, this);
        }

        BWbCellEditor[] toArray() {
            return new BWbCellEditor[]{this.keyCe, this.typeCe, this.valCe};
        }
    }

    private class Remove
    extends Command {
        Remove(BWidget owner) {
            super(owner, wbLex, "facetsFE.remove");
        }

        public CommandArtifact doInvoke() {
            if (BFacetsEditor.this.readonly) {
                return null;
            }
            int n = BFacetsEditor.this.tableSel.getRow();
            if (n == -1) {
                throw new IllegalStateException();
            }
            Row row = (Row)BFacetsEditor.this.rows.get(n);
            BFacetsEditor.this.remove((BComplex)row.keyLink);
            BFacetsEditor.this.remove((BComplex)row.typeLink);
            BFacetsEditor.this.keyToRow.remove((Object)row.keyCe);
            BFacetsEditor.this.typeToRow.remove((Object)row.typeCe);
            BFacetsEditor.this.rows.remove(n);
            BFacetsEditor.this.table.removeRow(n);
            BFacetsEditor.this.tableSel.deselectAll();
            int len = BFacetsEditor.this.table.getRowCount();
            if (len > 0) {
                BFacetsEditor.this.tableSel.select(n == len ? n - 1 : n);
            }
            BFacetsEditor.this.table.relayout();
            return null;
        }
    }

    private class Add
    extends Command
    implements ObjectUtil.NameContainer {
        Add(BWidget owner) {
            super(owner, wbLex, "facetsFE.add");
        }

        public boolean contains(String name) {
            try {
                for (int i = 0; i < BFacetsEditor.this.rows.size(); ++i) {
                    Row row = (Row)BFacetsEditor.this.rows.get(i);
                    String key = row.keyCe.saveValue().toString();
                    if (!key.equals(name)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public CommandArtifact doInvoke() {
            int count = BFacetsEditor.this.table.getRowCount();
            BFacetsEditor.this.table.addRow(new Row(ObjectUtil.generateUniqueSlotName((String)"key", (ObjectUtil.NameContainer)this), (BObject)BString.DEFAULT, false, null).toArray());
            BFacetsEditor.this.tableSel.deselectAll();
            BFacetsEditor.this.tableSel.select(count - 1);
            BFacetsEditor.this.table.relayout();
            return null;
        }
    }
}

