/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.ColorModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class BSatBrightBox
extends BWidget
implements ColorModel.Agent {
    public static final Type TYPE = Sys.loadType(BSatBrightBox.class);
    private float lastHue = -1.0f;
    private ColorModel model;
    private BImage image;
    private BBrush brush = BColor.red.toBrush();
    private int[] sample = new int[4];

    public Type getType() {
        return TYPE;
    }

    public BSatBrightBox() {
        throw new IllegalStateException();
    }

    public BSatBrightBox(ColorModel model) {
        this.model = model;
        model.addAgent(this);
    }

    public void computePreferredSize() {
        this.setPreferredSize(300.0, 300.0);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth() - 5.0;
        double h = this.getHeight() - 5.0;
        if (this.image == null || this.image.getWidth() != w || this.image.getHeight() != h) {
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = BImage.make((double)w, (double)h);
            this.createImage();
        }
    }

    public void paint(javax.baja.gx.Graphics g) {
        if (this.image != null) {
            double w = this.getWidth() - 1.0;
            double h = this.getHeight() - 1.0;
            g.setBrush(this.brush);
            g.fillRect(2.0, 2.0, w - 3.0, h - 3.0);
            g.drawImage(this.image, 2.0, 2.0);
            double x = 2.0 + (double)this.model.getSat() * (w - 3.0);
            double y = 2.0 + (double)(1.0f - this.model.getBri()) * (h - 3.0);
            g.setBrush(BColor.white);
            g.strokeRect(x - 5.0, y - 5.0, 9.0, 9.0);
            g.setBrush(BColor.black);
            g.strokeRect(x - 6.0, y - 6.0, 11.0, 11.0);
            g.setBrush(BColor.black);
            g.strokeRect(1.0, 1.0, w - 2.0, h - 2.0);
            g.setBrush(Theme.widget().getControlHighlight());
            g.strokeLine(w, 0.0, w, h);
            g.strokeLine(0.0, h, w, h);
            g.setBrush(Theme.widget().getControlShadow());
            g.strokeLine(0.0, 0.0, w, 0.0);
            g.strokeLine(0.0, 0.0, 0.0, h);
        }
    }

    private void createImage() {
        if (this.image == null) {
            return;
        }
        if (UiEnv.get().isMicroEdition()) {
            return;
        }
        double width = this.image.getWidth();
        double height = this.image.getHeight();
        BufferedImage bufimg = (BufferedImage)AwtEnv.peer((BImage)this.image).image();
        Graphics g = bufimg.getGraphics();
        WritableRaster data = bufimg.getRaster();
        int y = 0;
        while ((double)y < height) {
            int v = 255 - (int)((double)(255 * y) / height);
            int x = 0;
            while ((double)x < width) {
                this.sample[0] = v;
                this.sample[1] = v;
                this.sample[2] = v;
                this.sample[3] = 255 - (int)((double)(255 * x) / width);
                data.setPixel(x, y, this.sample);
                ++x;
            }
            ++y;
        }
        g.dispose();
    }

    public void mousePressed(BMouseEvent event) {
        this.doEvent(event);
    }

    public void mouseDragged(BMouseEvent event) {
        this.doEvent(event);
    }

    public void doEvent(BMouseEvent event) {
        float sat = (float)(event.getX() / (this.getWidth() - 1.0));
        float bri = 1.0f - (float)(event.getY() / (this.getHeight() - 1.0));
        if (sat < 0.0f) {
            sat = 0.0f;
        }
        if (bri < 0.0f) {
            bri = 0.0f;
        }
        if (sat > 1.0f) {
            sat = 1.0f;
        }
        if (bri > 1.0f) {
            bri = 1.0f;
        }
        this.model.set(this.model.getHue(), sat, bri);
        this.repaint();
    }

    @Override
    public void colorChanged() {
        float newHue = this.model.getHue();
        if (this.lastHue != newHue) {
            Color c = Color.getHSBColor(newHue, 1.0f, 1.0f);
            BColor color = BColor.make((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
            this.brush = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)0.0, (BColor)color), BBrush.stop((double)100.0, (BColor)BColor.black)}, (int)1, (double)-90.0);
            this.repaint();
        }
        this.lastHue = newHue;
    }
}

