/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.celleditors;

import com.tridium.workbench.util.FloatingPointHelper;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BTextFieldCE;

public class BFloatCE
extends BTextFieldCE {
    public static final Type TYPE = Sys.loadType(BFloatCE.class);
    private FloatingPointHelper helper;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.helper = FloatingPointHelper.makeFloat((Context)cx);
        super.doLoadValue(value, cx);
    }

    protected String valueToString(BObject value, Context cx) {
        return this.helper.format((double)((BNumber)value).getFloat());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String text = this.getTextField().getText();
        if (text.isEmpty()) {
            return BFloat.DEFAULT;
        }
        try {
            float f = (float)this.helper.parseAndValidate(text);
            if (Float.isNaN(f)) {
                f = 0.0f;
            }
            return BFloat.make((float)f);
        }
        catch (CannotSaveException e) {
            System.out.println("BFloatCE: CannotSaveException (" + e.getMessage() + ')');
            return value;
        }
    }
}

