/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import com.tridium.workbench.category.Category;
import com.tridium.workbench.util.WbUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.baja.category.BCategoryService;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.workbench.BWbEditor;

public class CategoryViewSupport {
    protected boolean hasAdminRead;
    protected boolean hasAdminWrite;
    protected Context loadContext;
    protected Map<Integer, UserCategoryPermissions> namedCategoryMap;
    protected BCategoryService service;
    static final boolean debugClickEnabled = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.category.assignments.allow"));
    private BPermissionsMap userPermissions;
    private BISession session;
    private BWbEditor editor;
    private boolean hasInitialized;

    public CategoryViewSupport(BWbEditor w) {
        this.editor = w;
    }

    public void init(Object value, Context cx) {
        if (this.hasInitialized) {
            return;
        }
        this.service = value instanceof BCategoryService ? (BCategoryService)value : (BCategoryService)WbUtil.findService((BWidget)this.editor, (Type)BCategoryService.TYPE);
        if (null != this.service) {
            this.loadContext = cx;
            this.hasAdminRead = this.service.getPermissions(cx).hasAdminRead();
            this.hasAdminWrite = this.service.getPermissions(cx).hasAdminWrite();
            this.session = BOrd.toSession((BObject)this.service);
            this.loadNamedCategories(cx);
            this.loadUserPermissions(cx);
        }
        this.hasInitialized = true;
    }

    public boolean hasCategoryPermissions(Category category) {
        this.init(this.editor.getCurrentValue(), null);
        if (null != this.userPermissions) {
            boolean hasRoleBasedCategoryPermissions = this.userPermissions.getPermissions(category.index).hasAdminWrite();
            boolean hasCategoryPermissions = null != category.category ? category.category.getPermissions(this.loadContext).hasAdminWrite() : true;
            return hasCategoryPermissions && hasRoleBasedCategoryPermissions;
        }
        return false;
    }

    public BCategoryService getCategoryService() {
        this.init(this.editor.getCurrentValue(), null);
        return this.service;
    }

    public boolean hasAdminRead() {
        this.init(this.editor.getCurrentValue(), null);
        return this.hasAdminRead;
    }

    public boolean hasAdminWrite() {
        this.init(this.editor.getCurrentValue(), null);
        return this.hasAdminWrite;
    }

    public boolean hasDebugClickEnabled() {
        this.init(this.editor.getCurrentValue(), null);
        return debugClickEnabled;
    }

    public void updateNamedCategories(Category[] categories) {
        this.init(this.editor.getCurrentValue(), null);
        if (!this.namedCategoryMap.isEmpty()) {
            Arrays.stream(categories).forEach(category -> {
                if (this.namedCategoryMap.containsKey(category.index)) {
                    category.display = this.namedCategoryMap.get((Object)Integer.valueOf((int)category.index)).name;
                }
            });
        }
    }

    private void loadNamedCategories(Context cx) {
        List namedCategories = Collections.emptyList();
        try {
            Optional namedCategoriesRpcResult;
            if (this.session instanceof BFoxProxySession && (namedCategoriesRpcResult = ((BFoxProxySession)this.session).rpc(BOrd.make((String)"type:baja:CategoryRpcUtil"), "getCategoryPermissionsForUser", new Object[0])).isPresent()) {
                namedCategories = (List)namedCategoriesRpcResult.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.namedCategoryMap = new HashMap<Integer, UserCategoryPermissions>();
        Arrays.stream(namedCategories.toArray()).forEach(nCategory -> {
            String userCPs = nCategory.toString();
            String categoryStr = userCPs.substring(0, userCPs.lastIndexOf("|"));
            String categoryPermissions = userCPs.substring(userCPs.lastIndexOf("|") + 1);
            String categoryName = categoryStr.substring(0, categoryStr.lastIndexOf("["));
            int index = Integer.valueOf(categoryStr.substring(categoryStr.lastIndexOf("[") + 1, categoryStr.length() - 1));
            this.namedCategoryMap.put(index, new UserCategoryPermissions(index, categoryName, categoryPermissions));
        });
    }

    private void loadUserPermissions(Context cx) {
        BUserService userService = (BUserService)WbUtil.findService((BWidget)this.editor, (Type)BUserService.TYPE);
        if (null != userService && cx instanceof BFacets) {
            BUser user;
            userService.lease();
            BObject userObj = ((BFacets)cx).get("username");
            if (null != userObj && null != (user = userService.getUser(userObj.toString()))) {
                user.lease();
                this.userPermissions = user.getPermissions();
            }
        } else if (null != cx && null != cx.getUser()) {
            this.userPermissions = cx.getUser().getPermissions();
        }
        if (null == this.userPermissions) {
            try {
                if (this.session instanceof BFoxProxySession) {
                    Optional userCategoryPermissionsResult = ((BFoxProxySession)this.session).rpc(BOrd.make((String)"type:baja:CategoryRpcUtil"), "getUserPermissions", new Object[0]);
                    if (userCategoryPermissionsResult.isPresent()) {
                        String encodedUserPermissions = (String)userCategoryPermissionsResult.get();
                        try {
                            this.userPermissions = (BPermissionsMap)BPermissionsMap.DEFAULT.decodeFromString(encodedUserPermissions);
                        }
                        catch (IOException iOException) {}
                    }
                } else if (this.session instanceof BLocalHost) {
                    this.userPermissions = BPermissionsMap.SUPER_USER;
                    this.hasAdminRead = true;
                    this.hasAdminWrite = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class UserCategoryPermissions {
        int index;
        String name;
        BPermissions permissions;

        public UserCategoryPermissions(int categoryIndex, String categoryName, String encodedPermissions) {
            this.index = categoryIndex;
            this.name = categoryName;
            try {
                this.permissions = BPermissions.make((String)encodedPermissions);
            }
            catch (Exception e) {
                this.permissions = BPermissions.DEFAULT;
            }
        }
    }
}

