/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import javax.baja.category.BAbstractCategory;
import javax.baja.category.BCategory;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BCategoryManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BCategoryManager.class);
    MgrColumn colIndex = new MgrColumn.Prop(BCategory.index, 1);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colStatus = new MgrColumn.Prop(BAbstractCategory.status, 0);
    MgrColumn colFaultCause = new MgrColumn.Prop(BAbstractCategory.faultCause, 0);
    protected MgrColumn[] cols = new MgrColumn[]{this.colIndex, this.colName, this.colStatus, this.colFaultCause};
    static final Lexicon WBUTIL_LEX = Lexicon.make((String)"wbutil");

    public Type getType() {
        return TYPE;
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    class Model
    extends MgrModel {
        Model(BCategoryManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        protected MgrColumn[] makeColumns() {
            return BCategoryManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BCategory.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((BComponent)new BCategory())};
        }
    }

    class Controller
    extends MgrController {
        Controller(BCategoryManager mgr) {
            super((BAbstractManager)mgr);
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrEdit edit = super.promptForNew(cx);
            if (edit == null) {
                return null;
            }
            int maxIndex = this.findMaxIndex();
            for (int i = 0; i < edit.getRowCount(); ++i) {
                MgrEditRow row = edit.getRow(i);
                int index = maxIndex + i + 1;
                row.setDefaultName(WBUTIL_LEX.getText("category.category") + index);
                row.setCell(BCategoryManager.this.colIndex, (BValue)BInteger.make((int)index));
            }
            return edit;
        }

        int findMaxIndex() {
            int max = 0;
            BComponent[] cats = BCategoryManager.this.getModel().getTable().getComponentModel().getRows();
            for (int i = 0; i < cats.length; ++i) {
                BCategory category = (BCategory)cats[i];
                max = Math.max(max, category.getIndex());
            }
            return max;
        }
    }
}

