/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import com.tridium.workbench.category.Category;
import com.tridium.workbench.category.CategoryViewSupport;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;

public class BCategoryCheckList
extends BWbPlugin {
    public static final Type TYPE = Sys.loadType(BCategoryCheckList.class);
    static final Lexicon lex = Lexicon.make(BCategoryCheckList.class);
    static final String lexCategories = lex.getText("Categories");
    static final BImage check = BImage.make((String)"module://icons/x16/check.png");
    static final int inset = 20;
    static final BBrush trumpForeground = BColor.gray.toBrush();
    BTable table;
    boolean trump;
    BCategoryMask mask;
    BCategoryMask trumpMask;
    Row[] rows = new Row[1];
    BCategoryService service;
    private CategoryViewSupport viewSupport;
    private Category[] categories;

    public Type getType() {
        return TYPE;
    }

    public BCategoryCheckList() {
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setOptionsButtonVisible(false);
        this.setContent((BWidget)this.table);
    }

    public BCategoryCheckList(CategoryViewSupport support) {
        this();
        this.viewSupport = support;
    }

    public boolean isTrump() {
        return this.trump;
    }

    public void setTrump(boolean trump) {
        this.trump = trump;
        this.repaint();
    }

    public void selectAll() {
        for (int i = 1; i < this.rows.length; ++i) {
            this.rows[i].selected = this.hasCategoryPermissions(this.rows[i].index);
        }
        this.repaint();
    }

    public void deselectAll() {
        for (int i = 1; i < this.rows.length; ++i) {
            this.rows[i].selected = false;
        }
        this.repaint();
    }

    public void load(BWbShell shell, BCategoryMask mask, BCategoryMask trumpMask) {
        this.mask = mask;
        this.trumpMask = trumpMask;
        Category.Result result = Category.load(shell, mask.size() + 1);
        if (null != this.viewSupport) {
            int len = result.categories.length - 1;
            this.categories = new Category[len];
            System.arraycopy(result.categories, 1, this.categories, 0, len);
            this.viewSupport.updateNamedCategories(this.categories);
        }
        Row[] rows = new Row[result.categories.length];
        for (int i = 1; i < rows.length; ++i) {
            rows[i] = new Row(this, result.categories[i]);
        }
        this.rows = rows;
        this.service = result.service;
        this.table.relayout();
    }

    public BCategoryMask save() {
        if (this.trump) {
            throw new IllegalStateException("Cannot call save() in trump model");
        }
        int numsel = 0;
        for (int i = 1; i < this.rows.length; ++i) {
            if (!this.rows[i].selected) continue;
            ++numsel;
        }
        int pos = 0;
        int[] indices = new int[numsel];
        for (int i = 1; i < this.rows.length; ++i) {
            if (!this.rows[i].selected) continue;
            indices[pos++] = i;
        }
        this.clearModified();
        return BCategoryMask.make((int[])indices);
    }

    private boolean hasCategoryPermissions(int categoryIndex) {
        return null != this.viewSupport ? this.viewSupport.hasCategoryPermissions(this.categories[categoryIndex - 1]) : true;
    }

    static class Row {
        int index;
        String display;
        boolean selected;
        boolean trump;

        Row(BCategoryCheckList list, Category cat) {
            this.index = cat.index;
            this.display = cat.display;
            if (this.index > 0) {
                this.selected = list.mask.get(this.index);
                this.trump = list.trumpMask.get(this.index);
            }
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (BCategoryCheckList.this.trump || !BCategoryCheckList.this.hasCategoryPermissions(BCategoryCheckList.this.rows[cell.row + 1].index)) {
                return trumpForeground;
            }
            return super.getForeground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return 20.0 + super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            boolean sel;
            this.paintCellBackground(g, cell);
            g.translate(20.0, 0.0);
            super.paintCell(g, cell);
            g.translate(-20.0, 0.0);
            Row row = BCategoryCheckList.this.rows[cell.row + 1];
            boolean bl = sel = BCategoryCheckList.this.trump ? row.trump : row.selected;
            if (sel && BCategoryCheckList.this.hasCategoryPermissions(BCategoryCheckList.this.rows[cell.row + 1].index)) {
                g.drawImage(check, 2.0, 0.0);
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellReleased(BMouseEvent event, int r, int c) {
            if (!CategoryViewSupport.debugClickEnabled && !BCategoryCheckList.this.hasCategoryPermissions(BCategoryCheckList.this.rows[r + 1].index)) {
                return;
            }
            if (BCategoryCheckList.this.trump) {
                return;
            }
            if (!event.isPopupTrigger()) {
                Row row = BCategoryCheckList.this.rows[r + 1];
                row.selected = !row.selected;
                BCategoryCheckList.this.setModified();
                BCategoryCheckList.this.repaint();
            }
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BCategoryCheckList.this.rows.length - 1;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return lexCategories;
        }

        public Object getSubject(int row) {
            return BCategoryCheckList.this.rows[row + 1];
        }

        public Object getValueAt(int row, int col) {
            return BCategoryCheckList.this.rows[row + 1].display;
        }
    }
}

