/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.offnormal;

import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.alarm.ext.offnormal.BTwoStateAlgorithm;
import javax.baja.control.BStringPoint;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStringChangeOfStateAlgorithm
extends BTwoStateAlgorithm {
    public static final Property expression = BStringChangeOfStateAlgorithm.newProperty((int)0, (String)".*", null);
    public static final Property normalOnMatch = BStringChangeOfStateAlgorithm.newProperty((int)0, (boolean)true, null);
    public static final Property caseSensitive = BStringChangeOfStateAlgorithm.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BStringChangeOfStateAlgorithm.class);
    private Pattern pattern;

    public String getExpression() {
        return this.getString(expression);
    }

    public void setExpression(String v) {
        this.setString(expression, v, null);
    }

    public boolean getNormalOnMatch() {
        return this.getBoolean(normalOnMatch);
    }

    public void setNormalOnMatch(boolean v) {
        this.setBoolean(normalOnMatch, v, null);
    }

    public boolean getCaseSensitive() {
        return this.getBoolean(caseSensitive);
    }

    public void setCaseSensitive(boolean v) {
        this.setBoolean(caseSensitive, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BStringPoint;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(expression) || p.equals(caseSensitive)) {
            this.init();
        }
        this.executePoint();
    }

    @Override
    public void started() {
        this.init();
        super.started();
    }

    private void init() {
        try {
            int flags = 32;
            if (!this.getCaseSensitive()) {
                flags |= 2;
            }
            this.pattern = Pattern.compile(this.getExpression(), flags);
        }
        catch (PatternSyntaxException e) {
            log.log(Level.SEVERE, "Invalid expression: " + this.getExpression(), e);
            this.pattern = null;
        }
    }

    @Override
    protected boolean isNormal(BStatusValue o) {
        BStatusString out = (BStatusString)o;
        if (out.getStatus().isNull() || this.pattern == null) {
            return true;
        }
        Matcher matcher = this.pattern.matcher(out.getValue());
        boolean found = matcher.find();
        return this.getNormalOnMatch() ? found : !found;
    }

    @Override
    public void writeAlarmData(BStatusValue out, Map map) {
        map.put("status", BString.make((String)out.getStatus().toString(null)));
    }
}

