/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.offnormal;

import java.util.Map;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

public class BOutOfRangeAlgorithm
extends BOffnormalAlgorithm {
    public static final Property highLimit = BOutOfRangeAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property lowLimit = BOutOfRangeAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property deadband = BOutOfRangeAlgorithm.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.0f)));
    public static final Property highLimitText = BOutOfRangeAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property lowLimitText = BOutOfRangeAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property limitEnable = BOutOfRangeAlgorithm.newProperty((int)0, (BValue)new BLimitEnable(), null);
    public static final Type TYPE = Sys.loadType(BOutOfRangeAlgorithm.class);
    OutOfRangeState current = new NormalState();

    public double getHighLimit() {
        return this.getDouble(highLimit);
    }

    public void setHighLimit(double v) {
        this.setDouble(highLimit, v, null);
    }

    public double getLowLimit() {
        return this.getDouble(lowLimit);
    }

    public void setLowLimit(double v) {
        this.setDouble(lowLimit, v, null);
    }

    public double getDeadband() {
        return this.getDouble(deadband);
    }

    public void setDeadband(double v) {
        this.setDouble(deadband, v, null);
    }

    public BFormat getHighLimitText() {
        return (BFormat)this.get(highLimitText);
    }

    public void setHighLimitText(BFormat v) {
        this.set(highLimitText, (BValue)v, null);
    }

    public BFormat getLowLimitText() {
        return (BFormat)this.get(lowLimitText);
    }

    public void setLowLimitText(BFormat v) {
        this.set(lowLimitText, (BValue)v, null);
    }

    public BLimitEnable getLimitEnable() {
        return (BLimitEnable)this.get(limitEnable);
    }

    public void setLimitEnable(BLimitEnable v) {
        this.set(limitEnable, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private boolean isHighLimitEnabled() {
        return this.getLimitEnable().isHighLimitEnabled();
    }

    private boolean isLowLimitEnabled() {
        return this.getLimitEnable().isLowLimitEnabled();
    }

    public void started() {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (currentState == BAlarmState.highLimit) {
            this.current = new HighAlarmState();
        }
        if (currentState == BAlarmState.lowLimit) {
            this.current = new LowAlarmState();
        }
    }

    @Override
    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BNumericPoint;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == highLimit || slot == lowLimit) {
            return this.getPointFacets();
        }
        if (slot == deadband) {
            BFacets facets = this.getPointFacets();
            BUnit unit = (BUnit)facets.getFacet("units");
            if (unit != null) {
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)unit.getDifferentialUnit());
            }
            return BFacets.make((BFacets)facets, (BFacets)super.getSlotFacets((Slot)deadband));
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public BAlarmState checkAlarms(BStatusValue o, long toAlarmTimeDelay, long toNormalTimeDelay) {
        BStatusNumeric out = (BStatusNumeric)o;
        if (out.getStatus().isNull()) {
            if (this.current instanceof NormalState) {
                return null;
            }
            if (toNormalTimeDelay > 0L && this.current instanceof HighAlarmState) {
                this.current = new ValidateReturnFromHighState(toNormalTimeDelay);
            } else if (toNormalTimeDelay > 0L && this.current instanceof LowAlarmState) {
                this.current = new ValidateReturnFromLowState(toNormalTimeDelay);
            } else {
                this.current = new NormalState();
                return BAlarmState.normal;
            }
            return null;
        }
        return this.evaluate(out.getValue(), toAlarmTimeDelay, toNormalTimeDelay);
    }

    private BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (!(this.current instanceof ValidationState)) {
            this.current = currentState == BAlarmState.highLimit ? new HighAlarmState() : (currentState == BAlarmState.lowLimit ? new LowAlarmState() : new NormalState());
        }
        return this.current.evaluate(presentValue, toAlarmTimeDelay, toNormalTimeDelay);
    }

    @Override
    public void writeAlarmData(BStatusValue out, Map map) {
        BFacets facets = this.getPointFacets();
        map.put("status", BString.make((String)out.getStatus().toString(null)));
        map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)facets)));
        if (this.current instanceof HighAlarmState) {
            if (!this.getHighLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getHighLimitText().getFormat()));
            }
            map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)facets)));
            if (this.isLowLimitEnabled()) {
                map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)facets)));
            }
        } else if (this.current instanceof LowAlarmState) {
            if (!this.getLowLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getLowLimitText().getFormat()));
            }
            if (this.isHighLimitEnabled()) {
                map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)facets)));
            }
            map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)facets)));
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        this.executePoint();
    }

    void transition(OutOfRangeState state) {
        this.current = state;
    }

    private class ValidateReturnFromLowState
    extends ValidationState {
        public ValidateReturnFromLowState(long timeDelay) {
            BOutOfRangeAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateReturnFromLowState";
        }

        @Override
        public BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (presentValue <= BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
            } else if (presentValue > BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isTimerExpired()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    private class LowAlarmState
    extends OutOfRangeState {
        @Override
        public String tag() {
            return "LowAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (presentValue <= BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband()) {
                if (!BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            } else if (presentValue > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (toNormalTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromLowState(toNormalTimeDelay));
            } else if (presentValue > BOutOfRangeAlgorithm.this.getLowLimit() + BOutOfRangeAlgorithm.this.getDeadband()) {
                if (toNormalTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromLowState(toNormalTimeDelay));
            }
            return null;
        }
    }

    private class ValidateLowAlarmState
    extends ValidationState {
        public ValidateLowAlarmState(long timeDelay) {
            BOutOfRangeAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateLowAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (presentValue < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (BOutOfRangeAlgorithm.this.isTimerExpired()) {
                    BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.lowLimit;
                }
            } else if (presentValue > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (toAlarmTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.highLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateHighAlarmState(toAlarmTimeDelay));
            } else if (presentValue >= BOutOfRangeAlgorithm.this.getLowLimit()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
            }
            return null;
        }
    }

    private class ValidateReturnFromHighState
    extends ValidationState {
        public ValidateReturnFromHighState(long timeDelay) {
            BOutOfRangeAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateReturnFromHighState";
        }

        @Override
        public BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (toNormalTimeDelay > 0L && !BOutOfRangeAlgorithm.this.isTimerExpired()) {
                return null;
            }
            if (presentValue >= BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
            } else if (presentValue < BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband() && BOutOfRangeAlgorithm.this.isTimerExpired()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    private class HighAlarmState
    extends OutOfRangeState {
        @Override
        public String tag() {
            return "HighAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (presentValue >= BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband()) {
                if (!BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            } else if (presentValue < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (toNormalTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromHighState(toNormalTimeDelay));
            } else if (presentValue < BOutOfRangeAlgorithm.this.getHighLimit() - BOutOfRangeAlgorithm.this.getDeadband()) {
                if (toNormalTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateReturnFromHighState(toNormalTimeDelay));
            }
            return null;
        }
    }

    private class ValidateHighAlarmState
    extends ValidationState {
        public ValidateHighAlarmState(long timeDelay) {
            BOutOfRangeAlgorithm.this.startTimer(timeDelay);
        }

        @Override
        public String tag() {
            return "ValidateHighAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (presentValue < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (toAlarmTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.lowLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateLowAlarmState(toAlarmTimeDelay));
            } else if (presentValue > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (BOutOfRangeAlgorithm.this.isTimerExpired()) {
                    BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.highLimit;
                }
            } else if (presentValue <= BOutOfRangeAlgorithm.this.getHighLimit()) {
                BOutOfRangeAlgorithm.this.transition(new NormalState());
            }
            return null;
        }
    }

    private class NormalState
    extends OutOfRangeState {
        @Override
        public String tag() {
            return "Normal";
        }

        @Override
        public BAlarmState evaluate(double presentValue, long toAlarmTimeDelay, long toNormalTimeDelay) {
            if (presentValue < BOutOfRangeAlgorithm.this.getLowLimit() && BOutOfRangeAlgorithm.this.isLowLimitEnabled()) {
                if (toAlarmTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.lowLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateLowAlarmState(toAlarmTimeDelay));
            } else if ((!(presentValue >= BOutOfRangeAlgorithm.this.getLowLimit()) || !(presentValue <= BOutOfRangeAlgorithm.this.getHighLimit())) && presentValue > BOutOfRangeAlgorithm.this.getHighLimit() && BOutOfRangeAlgorithm.this.isHighLimitEnabled()) {
                if (toAlarmTimeDelay == 0L) {
                    BOutOfRangeAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.highLimit;
                }
                BOutOfRangeAlgorithm.this.transition(new ValidateHighAlarmState(toAlarmTimeDelay));
            }
            return null;
        }
    }

    private abstract class ValidationState
    extends OutOfRangeState {
        private ValidationState() {
        }
    }

    private abstract class OutOfRangeState {
        public OutOfRangeState() {
            BOutOfRangeAlgorithm.this.cancelTimer();
        }

        public abstract String tag();

        public abstract BAlarmState evaluate(double var1, long var3, long var5);
    }
}

