/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.fault;

import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BTwoStateFaultAlgorithm
extends BFaultAlgorithm {
    public static final Type TYPE = Sys.loadType(BTwoStateFaultAlgorithm.class);
    TwoState current = new NormalState();

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (currentState == BAlarmState.fault) {
            this.current = new FaultState();
        }
    }

    @Override
    public BAlarmState checkFault(BStatusValue out) {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        this.current = currentState == BAlarmState.fault ? new FaultState() : new NormalState();
        boolean isNorm = this.isNormal(out);
        return this.current.evaluate(isNorm);
    }

    protected abstract boolean isNormal(BStatusValue var1);

    protected boolean isCurrentFault() {
        return this.current instanceof FaultState;
    }

    private void transition(TwoState state) {
        this.current = state;
    }

    private class ValidateReturnFromFaultState
    extends TwoState {
        @Override
        public String tag() {
            return "ValidateReturnFromFaultState";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV) {
            if (normalPV) {
                BTwoStateFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            BTwoStateFaultAlgorithm.this.transition(new FaultState());
            return null;
        }
    }

    private class FaultState
    extends TwoState {
        private FaultState() {
        }

        @Override
        public String tag() {
            return "FaultState";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV) {
            if (normalPV) {
                BTwoStateFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    private class ValidateFaultState
    extends TwoState {
        @Override
        public String tag() {
            return "ValidateFaultState";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV) {
            if (normalPV) {
                BTwoStateFaultAlgorithm.this.transition(new NormalState());
                return null;
            }
            BTwoStateFaultAlgorithm.this.transition(new FaultState());
            return BAlarmState.fault;
        }
    }

    private class NormalState
    extends TwoState {
        private NormalState() {
        }

        @Override
        public String tag() {
            return "Normal";
        }

        @Override
        public BAlarmState evaluate(boolean normalPV) {
            if (!normalPV) {
                BTwoStateFaultAlgorithm.this.transition(new FaultState());
                return BAlarmState.fault;
            }
            return null;
        }
    }

    private abstract class TwoState {
        public abstract String tag();

        public abstract BAlarmState evaluate(boolean var1);
    }
}

