/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext.fault;

import java.util.Map;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BLimitEnable;
import javax.baja.control.BNumericPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

public class BOutOfRangeFaultAlgorithm
extends BFaultAlgorithm {
    public static final Property highLimit = BOutOfRangeFaultAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property lowLimit = BOutOfRangeFaultAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property deadband = BOutOfRangeFaultAlgorithm.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BFloat.make((float)0.0f)));
    public static final Property highLimitText = BOutOfRangeFaultAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property lowLimitText = BOutOfRangeFaultAlgorithm.newProperty((int)0, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property limitEnable = BOutOfRangeFaultAlgorithm.newProperty((int)0, (BValue)new BLimitEnable(), null);
    public static final Property inHighState = BOutOfRangeFaultAlgorithm.newProperty((int)4, (boolean)false, null);
    public static final Property inLowState = BOutOfRangeFaultAlgorithm.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BOutOfRangeFaultAlgorithm.class);
    OutOfRangeState current = new NormalState();

    public double getHighLimit() {
        return this.getDouble(highLimit);
    }

    public void setHighLimit(double v) {
        this.setDouble(highLimit, v, null);
    }

    public double getLowLimit() {
        return this.getDouble(lowLimit);
    }

    public void setLowLimit(double v) {
        this.setDouble(lowLimit, v, null);
    }

    public double getDeadband() {
        return this.getDouble(deadband);
    }

    public void setDeadband(double v) {
        this.setDouble(deadband, v, null);
    }

    public BFormat getHighLimitText() {
        return (BFormat)this.get(highLimitText);
    }

    public void setHighLimitText(BFormat v) {
        this.set(highLimitText, (BValue)v, null);
    }

    public BFormat getLowLimitText() {
        return (BFormat)this.get(lowLimitText);
    }

    public void setLowLimitText(BFormat v) {
        this.set(lowLimitText, (BValue)v, null);
    }

    public BLimitEnable getLimitEnable() {
        return (BLimitEnable)this.get(limitEnable);
    }

    public void setLimitEnable(BLimitEnable v) {
        this.set(limitEnable, (BValue)v, null);
    }

    public boolean getInHighState() {
        return this.getBoolean(inHighState);
    }

    public void setInHighState(boolean v) {
        this.setBoolean(inHighState, v, null);
    }

    public boolean getInLowState() {
        return this.getBoolean(inLowState);
    }

    public void setInLowState(boolean v) {
        this.setBoolean(inLowState, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private boolean isHighLimitEnabled() {
        return this.getLimitEnable().isHighLimitEnabled();
    }

    private boolean isLowLimitEnabled() {
        return this.getLimitEnable().isLowLimitEnabled();
    }

    public void started() {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (currentState == BAlarmState.fault) {
            if (this.getInHighState()) {
                this.current = new HighAlarmState();
            } else if (this.getInLowState()) {
                this.current = new LowAlarmState();
            }
        }
    }

    @Override
    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BNumericPoint;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == highLimit || slot == lowLimit) {
            return this.getPointFacets();
        }
        if (slot == deadband) {
            BFacets facets = this.getPointFacets();
            BUnit unit = (BUnit)facets.getFacet("units");
            if (unit != null) {
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)unit.getDifferentialUnit());
            }
            return BFacets.make((BFacets)facets, (BFacets)super.getSlotFacets((Slot)deadband));
        }
        return super.getSlotFacets(slot);
    }

    @Override
    public BAlarmState checkFault(BStatusValue o) {
        BStatusNumeric out = (BStatusNumeric)o;
        return this.evaluate(out.getValue());
    }

    private BAlarmState evaluate(double presentValue) {
        BAlarmState currentState = ((BAlarmSourceExt)this.getParent()).getAlarmState();
        if (currentState == BAlarmState.fault) {
            if (this.getInHighState()) {
                this.current = new HighAlarmState();
            } else if (this.getInLowState()) {
                this.current = new LowAlarmState();
            }
        } else {
            this.current = new NormalState();
        }
        return this.current.evaluate(presentValue);
    }

    @Override
    public void writeAlarmData(BStatusValue out, Map map) {
        BFacets facets = this.getPointFacets();
        map.put("status", BString.make((String)out.getStatus().toString(null)));
        map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)facets)));
        if (this.current instanceof HighAlarmState) {
            if (!this.getHighLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getHighLimitText().getFormat()));
            }
            map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)facets)));
            if (this.isLowLimitEnabled()) {
                map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)facets)));
            }
        } else if (this.current instanceof LowAlarmState) {
            if (!this.getLowLimitText().equals((Object)BFormat.DEFAULT)) {
                map.put("msgText", BString.make((String)this.getLowLimitText().getFormat()));
            }
            if (this.isHighLimitEnabled()) {
                map.put("highLimit", BString.make((String)BDouble.toString((double)this.getHighLimit(), (Context)facets)));
            }
            map.put("lowLimit", BString.make((String)BDouble.toString((double)this.getLowLimit(), (Context)facets)));
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        this.executePoint();
    }

    void transition(OutOfRangeState state) {
        this.current = state;
    }

    private class ValidateReturnFromLowState
    extends OutOfRangeState {
        @Override
        public String tag() {
            return "ValidateReturnFromLowState";
        }

        @Override
        public BAlarmState evaluate(double presentValue) {
            if (presentValue <= BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
            } else {
                if (presentValue > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.fault;
                }
                if (presentValue > BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            }
            return null;
        }
    }

    private class LowAlarmState
    extends OutOfRangeState {
        public LowAlarmState() {
            BOutOfRangeFaultAlgorithm.this.setInHighState(false);
            BOutOfRangeFaultAlgorithm.this.setInLowState(true);
        }

        @Override
        public String tag() {
            return "LowAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue) {
            if (!(presentValue < BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband())) {
                if (presentValue > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                    return BAlarmState.fault;
                }
                if (presentValue >= BOutOfRangeFaultAlgorithm.this.getLowLimit() + BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            }
            return null;
        }
    }

    private class ValidateLowAlarmState
    extends OutOfRangeState {
        @Override
        public String tag() {
            return "ValidateLowAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue) {
            if (presentValue < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if (presentValue > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            if (presentValue >= BOutOfRangeFaultAlgorithm.this.getLowLimit()) {
                BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    private class ValidateReturnFromHighState
    extends OutOfRangeState {
        @Override
        public String tag() {
            return "ValidateReturnFromHighState";
        }

        @Override
        public BAlarmState evaluate(double presentValue) {
            if (presentValue > BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            if (presentValue < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if (presentValue < BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    private class HighAlarmState
    extends OutOfRangeState {
        public HighAlarmState() {
            BOutOfRangeFaultAlgorithm.this.setInHighState(true);
            BOutOfRangeFaultAlgorithm.this.setInLowState(false);
        }

        @Override
        public String tag() {
            return "HighAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue) {
            if (!(presentValue > BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband())) {
                if (presentValue < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                    return BAlarmState.fault;
                }
                if (presentValue <= BOutOfRangeFaultAlgorithm.this.getHighLimit() - BOutOfRangeFaultAlgorithm.this.getDeadband()) {
                    BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                    return BAlarmState.normal;
                }
            }
            return null;
        }
    }

    private class ValidateHighAlarmState
    extends OutOfRangeState {
        @Override
        public String tag() {
            return "ValidateHighAlarmState";
        }

        @Override
        public BAlarmState evaluate(double presentValue) {
            if (presentValue < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if (presentValue > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            if (presentValue <= BOutOfRangeFaultAlgorithm.this.getHighLimit()) {
                BOutOfRangeFaultAlgorithm.this.transition(new NormalState());
                return BAlarmState.normal;
            }
            return null;
        }
    }

    private class NormalState
    extends OutOfRangeState {
        public NormalState() {
            BOutOfRangeFaultAlgorithm.this.setInHighState(false);
            BOutOfRangeFaultAlgorithm.this.setInLowState(false);
        }

        @Override
        public String tag() {
            return "Normal";
        }

        @Override
        public BAlarmState evaluate(double presentValue) {
            if (presentValue < BOutOfRangeFaultAlgorithm.this.getLowLimit() && BOutOfRangeFaultAlgorithm.this.isLowLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new LowAlarmState());
                return BAlarmState.fault;
            }
            if ((!(presentValue >= BOutOfRangeFaultAlgorithm.this.getLowLimit()) || !(presentValue <= BOutOfRangeFaultAlgorithm.this.getHighLimit())) && presentValue > BOutOfRangeFaultAlgorithm.this.getHighLimit() && BOutOfRangeFaultAlgorithm.this.isHighLimitEnabled()) {
                BOutOfRangeFaultAlgorithm.this.transition(new HighAlarmState());
                return BAlarmState.fault;
            }
            return null;
        }
    }

    private abstract class OutOfRangeState {
        public abstract String tag();

        public abstract BAlarmState evaluate(double var1);
    }
}

