/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm.ext;

import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.alarm.ext.BAlarmTimestamps;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BIAlarmMessages;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.control.BControlPoint;
import javax.baja.control.BDiscretePoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public class BAlarmSourceExt
extends BPointExtension
implements BIAlarmSource,
BIAlarmMessages {
    public static final Topic toNormal = BAlarmSourceExt.newTopic((int)0, null);
    public static final Property alarmInhibit = BAlarmSourceExt.newProperty((int)0, (BValue)new BStatusBoolean(false), null);
    public static final Property inhibitTime = BAlarmSourceExt.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property alarmState = BAlarmSourceExt.newProperty((int)65, (BValue)BAlarmState.normal, null);
    public static final Property timeDelay = BAlarmSourceExt.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property timeDelayToNormal = BAlarmSourceExt.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property alarmEnable = BAlarmSourceExt.newProperty((int)0, (BValue)BAlarmTransitionBits.DEFAULT, (BFacets)BFacets.make((String[])new String[]{"showNormal", "showAlert"}, (BIDataValue[])new BBoolean[]{BBoolean.FALSE, BBoolean.FALSE}));
    public static final Property ackedTransitions = BAlarmSourceExt.newProperty((int)69, (BValue)BAlarmTransitionBits.ALL, null);
    public static final Property toOffnormalTimes = BAlarmSourceExt.newProperty((int)1, (BValue)new BAlarmTimestamps(), null);
    public static final Property toFaultTimes = BAlarmSourceExt.newProperty((int)1, (BValue)new BAlarmTimestamps(), null);
    public static final Property timeInCurrentState = BAlarmSourceExt.newProperty((int)3, (BValue)BRelTime.DEFAULT, null);
    public static final Property sourceName = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%"), null);
    public static final Property toFaultText = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property toOffnormalText = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property toNormalText = BAlarmSourceExt.newProperty((int)0, (BValue)BFormat.make((String)""), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property hyperlinkOrd = BAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE, (String)"chooseView", (BIDataValue)BBoolean.TRUE));
    public static final Property soundFile = BAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:AudioFile")));
    public static final Property alarmIcon = BAlarmSourceExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:ImageFile")));
    public static final Property alarmInstructions = BAlarmSourceExt.newProperty((int)0, (BValue)BAlarmInstructions.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:InstructionsFE")));
    public static final Property faultAlgorithm = BAlarmSourceExt.newProperty((int)0, (BValue)new BFaultAlgorithm(), null);
    public static final Property offnormalAlgorithm = BAlarmSourceExt.newProperty((int)0, (BValue)new BOffnormalAlgorithm(), null);
    public static final Property alarmClass = BAlarmSourceExt.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Property metaData = BAlarmSourceExt.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property status = BAlarmSourceExt.newProperty((int)7, (BValue)BStatus.DEFAULT, null);
    public static final Action timerExpired = BAlarmSourceExt.newAction((int)4, null);
    public static final Action inhibitTimerExpired = BAlarmSourceExt.newAction((int)4, null);
    public static final Action ackAlarm = BAlarmSourceExt.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Topic toOffnormal = BAlarmSourceExt.newTopic((int)0, null);
    public static final Topic toFault = BAlarmSourceExt.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BAlarmSourceExt.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"control/controlExtension.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final int NON_ALARM_BITS = -139;
    private Clock.Ticket ticket;
    private Clock.Ticket inhibitTicket;
    private long timeOfLastStateChange;
    private AlarmSupport support;
    private BAbsTime lastOffnormalTime = BAbsTime.NULL;
    private BAbsTime lastFaultTime = BAbsTime.NULL;
    private BAbsTime lastToNormalTime = BAbsTime.NULL;
    private BAbsTime lastAckTime = BAbsTime.NULL;
    private static final Logger log = Logger.getLogger("alarm");
    private boolean atSteadyState;

    public BStatusBoolean getAlarmInhibit() {
        return (BStatusBoolean)this.get(alarmInhibit);
    }

    public void setAlarmInhibit(BStatusBoolean v) {
        this.set(alarmInhibit, (BValue)v, null);
    }

    public BRelTime getInhibitTime() {
        return (BRelTime)this.get(inhibitTime);
    }

    public void setInhibitTime(BRelTime v) {
        this.set(inhibitTime, (BValue)v, null);
    }

    public BAlarmState getAlarmState() {
        return (BAlarmState)this.get(alarmState);
    }

    public void setAlarmState(BAlarmState v) {
        this.set(alarmState, (BValue)v, null);
    }

    public BRelTime getTimeDelay() {
        return (BRelTime)this.get(timeDelay);
    }

    public void setTimeDelay(BRelTime v) {
        this.set(timeDelay, (BValue)v, null);
    }

    public BRelTime getTimeDelayToNormal() {
        return (BRelTime)this.get(timeDelayToNormal);
    }

    public void setTimeDelayToNormal(BRelTime v) {
        this.set(timeDelayToNormal, (BValue)v, null);
    }

    public BAlarmTransitionBits getAlarmEnable() {
        return (BAlarmTransitionBits)this.get(alarmEnable);
    }

    public void setAlarmEnable(BAlarmTransitionBits v) {
        this.set(alarmEnable, (BValue)v, null);
    }

    public BAlarmTransitionBits getAckedTransitions() {
        return (BAlarmTransitionBits)this.get(ackedTransitions);
    }

    public void setAckedTransitions(BAlarmTransitionBits v) {
        this.set(ackedTransitions, (BValue)v, null);
    }

    public BAlarmTimestamps getToOffnormalTimes() {
        return (BAlarmTimestamps)this.get(toOffnormalTimes);
    }

    public void setToOffnormalTimes(BAlarmTimestamps v) {
        this.set(toOffnormalTimes, (BValue)v, null);
    }

    public BAlarmTimestamps getToFaultTimes() {
        return (BAlarmTimestamps)this.get(toFaultTimes);
    }

    public void setToFaultTimes(BAlarmTimestamps v) {
        this.set(toFaultTimes, (BValue)v, null);
    }

    public BRelTime getTimeInCurrentState() {
        return (BRelTime)this.get(timeInCurrentState);
    }

    public void setTimeInCurrentState(BRelTime v) {
        this.set(timeInCurrentState, (BValue)v, null);
    }

    public BFormat getSourceName() {
        return (BFormat)this.get(sourceName);
    }

    public void setSourceName(BFormat v) {
        this.set(sourceName, (BValue)v, null);
    }

    @Override
    public BFormat getToFaultText() {
        return (BFormat)this.get(toFaultText);
    }

    public void setToFaultText(BFormat v) {
        this.set(toFaultText, (BValue)v, null);
    }

    @Override
    public BFormat getToOffnormalText() {
        return (BFormat)this.get(toOffnormalText);
    }

    public void setToOffnormalText(BFormat v) {
        this.set(toOffnormalText, (BValue)v, null);
    }

    @Override
    public BFormat getToNormalText() {
        return (BFormat)this.get(toNormalText);
    }

    public void setToNormalText(BFormat v) {
        this.set(toNormalText, (BValue)v, null);
    }

    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    public void setHyperlinkOrd(BOrd v) {
        this.set(hyperlinkOrd, (BValue)v, null);
    }

    public BOrd getSoundFile() {
        return (BOrd)this.get(soundFile);
    }

    public void setSoundFile(BOrd v) {
        this.set(soundFile, (BValue)v, null);
    }

    public BOrd getAlarmIcon() {
        return (BOrd)this.get(alarmIcon);
    }

    public void setAlarmIcon(BOrd v) {
        this.set(alarmIcon, (BValue)v, null);
    }

    public BAlarmInstructions getAlarmInstructions() {
        return (BAlarmInstructions)this.get(alarmInstructions);
    }

    public void setAlarmInstructions(BAlarmInstructions v) {
        this.set(alarmInstructions, (BValue)v, null);
    }

    public BFaultAlgorithm getFaultAlgorithm() {
        return (BFaultAlgorithm)this.get(faultAlgorithm);
    }

    public void setFaultAlgorithm(BFaultAlgorithm v) {
        this.set(faultAlgorithm, (BValue)v, null);
    }

    public BOffnormalAlgorithm getOffnormalAlgorithm() {
        return (BOffnormalAlgorithm)this.get(offnormalAlgorithm);
    }

    public void setOffnormalAlgorithm(BOffnormalAlgorithm v) {
        this.set(offnormalAlgorithm, (BValue)v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BFacets getMetaData() {
        return (BFacets)this.get(metaData);
    }

    public void setMetaData(BFacets v) {
        this.set(metaData, (BValue)v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public void inhibitTimerExpired() {
        this.invoke(inhibitTimerExpired, null, null);
    }

    @Override
    public BBoolean ackAlarm(BAlarmRecord ackRequest) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)ackRequest, null);
    }

    public void fireToOffnormal(BAlarmRecord event) {
        this.fire(toOffnormal, (BValue)event, null);
    }

    public void fireToFault(BAlarmRecord event) {
        this.fire(toFault, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        this.timeOfLastStateChange = Clock.ticks();
        this.initScheduler();
        if (Sys.atSteadyState()) {
            this.atSteadyState = true;
        }
    }

    public void atSteadyState() throws Exception {
        this.atSteadyState = true;
        this.executePoint();
    }

    public boolean requiresPointSubscription() {
        return this.getAlarmEnable().isToOffnormal() || this.getAlarmEnable().isToFault();
    }

    public void checkPointSubscription() {
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            point.checkExtensionsRequireSubscription();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BControlPoint && this.getOffnormalAlgorithm().isGrandparentLegal(parent) && this.getFaultAlgorithm().isGrandparentLegal(parent);
    }

    protected boolean isSiblingLegal(BComponent sibling) {
        return true;
    }

    private void initScheduler() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)10000L), (Action)timerExpired, null);
    }

    public BOrdList getSourceOrd() {
        return this.support.getSourceOrd();
    }

    public void doTimerExpired() {
        this.setTimeInCurrentState(BRelTime.make((long)(Clock.ticks() - this.timeOfLastStateChange)));
    }

    public void doInhibitTimerExpired() {
        this.inhibitTicket = null;
        this.checkPointSubscription();
        this.executePoint();
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        if (!this.isRunning()) {
            return BBoolean.make((boolean)false);
        }
        try {
            boolean validNormalAck;
            boolean validAck = this.support.ackAlarm(ackRequest);
            this.lastAckTime = ackRequest.getAckTime();
            if (validAck) {
                this.updateAckedTransitions(ackRequest.getAlarmTransition());
                this.updateAckTime(ackRequest);
            }
            if (validNormalAck = this.support.isValidNormalAck(ackRequest)) {
                this.updateAckedTransitions(BSourceState.normal);
            }
            if ((validAck || validNormalAck) && this.getStatus().isUnackedAlarm()) {
                this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)false));
            }
            this.executePoint();
            return BBoolean.make((boolean)validAck);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception thrown while acking alarm", e);
            return BBoolean.make((boolean)false);
        }
    }

    private void updateAckedTransitions(BSourceState state) {
        BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
        ackedTrans = BAlarmTransitionBits.make(ackedTrans, state.getAlarmTransitionBits(), true);
        this.setAckedTransitions(ackedTrans);
    }

    private void updateAckTime(BAlarmRecord ackRequest) {
        BAlarmTimestamps alarmTimes = null;
        BSourceState initialState = ackRequest.getAlarmTransition();
        if (initialState == BSourceState.offnormal) {
            alarmTimes = this.getToOffnormalTimes();
        } else if (initialState == BSourceState.fault) {
            alarmTimes = this.getToFaultTimes();
        }
        if (alarmTimes != null && !alarmTimes.getAlarmTime().isNull()) {
            alarmTimes.setAckTime(ackRequest.getAckTime());
        }
    }

    private void updateNormalTimes(BAlarmRecord record) {
        BAlarmTimestamps alarmTimes = this.getToOffnormalTimes();
        if (!alarmTimes.getAlarmTime().isNull()) {
            alarmTimes.setNormalTime(record.getNormalTime());
        }
        if (!(alarmTimes = this.getToFaultTimes()).getAlarmTime().isNull()) {
            alarmTimes.setNormalTime(record.getNormalTime());
        }
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!this.isRunning() || !this.atSteadyState) {
            return;
        }
        boolean isWorkingVariableAlarm = out.getStatus().isAlarm();
        boolean isWorkingVariableFault = out.getStatus().isFault();
        this.checkAlarms(out);
        String inhibitFacet = Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("alarm.alarmInhibit.facet");
        if (this.inhibitTicket == null || this.inhibitTicket.isExpired()) {
            this.setStatus(this.getAlarmInhibit().getBoolean() || this.isTimerActive() ? BStatus.make((BStatus)this.getStatus(), (String)inhibitFacet, (boolean)true) : BStatus.make((int)this.getStatus().getBits(), (BFacets)BFacets.makeRemove((BFacets)this.getStatus().getFacets(), (String)inhibitFacet)));
        } else {
            this.setStatus(this.getAlarmInhibit().getBoolean() || this.isTimerActive() ? BStatus.make((int)this.getStatus().getBits(), (BFacets)BFacets.makeRemove((BFacets)this.getStatus().getFacets(), (String)inhibitFacet)) : BStatus.make((BStatus)this.getStatus(), (String)inhibitFacet, (boolean)true));
        }
        BControlPoint point = this.getParentPoint();
        BAlarmSourceExt[] exts = (BAlarmSourceExt[])point.getChildren(BAlarmSourceExt.class);
        int bits = out.getStatus().getBits() & 0xFFFFFF75;
        boolean hasInhibit = false;
        for (BAlarmSourceExt ext : exts) {
            bits |= ext.getStatus().getBits();
            if (ext.getStatus().getb(inhibitFacet, false)) {
                hasInhibit = true;
            }
            if (ext == this) break;
        }
        out.setStatus(hasInhibit ? BStatus.make((int)bits, (BFacets)BFacets.make((BFacets)out.getStatus().getFacets(), (String)inhibitFacet, (BIDataValue)BBoolean.TRUE)) : BStatus.make((int)bits, (BFacets)BFacets.makeRemove((BFacets)out.getStatus().getFacets(), (String)inhibitFacet)));
        if (isWorkingVariableAlarm) {
            out.setStatusInAlarm(true);
        }
        if (isWorkingVariableFault) {
            out.setStatusFault(true);
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(alarmClass) && this.support != null) {
            this.support.setAlarmClass(this.getAlarmClass());
        } else if (p.equals(timeDelay)) {
            this.executePoint();
        } else if (p.equals(alarmInhibit)) {
            this.checkPointSubscription();
            if (this.getInhibitTime().getMillis() > 0L) {
                if (this.inhibitTicket != null) {
                    this.inhibitTicket.cancel();
                }
                if (!this.getAlarmInhibit().getBoolean()) {
                    this.inhibitTicket = Clock.schedule((BComponent)this, (BRelTime)this.getInhibitTime(), (Action)inhibitTimerExpired, null);
                } else if (this.getParent() instanceof BDiscretePoint) {
                    this.inhibitTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)(this.getInhibitTime().getMillis() * 3L)), (Action)inhibitTimerExpired, null);
                }
            } else {
                this.executePoint();
            }
        } else if (p.equals(alarmEnable)) {
            this.checkPointSubscription();
            this.executePoint();
        }
    }

    protected boolean isTimerActive() {
        try {
            return !this.getOffnormalAlgorithm().isTimerExpired();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected boolean isInhibitTimerActive() {
        try {
            return this.inhibitTicket != null && !this.inhibitTicket.isExpired();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected void checkAlarms(BStatusValue out) {
        boolean useInhibit;
        BAlarmState newAlarmState = null;
        BAlarmState alarmState = this.getAlarmState();
        if (Sys.getService((Type)BAlarmService.TYPE) == null) {
            return;
        }
        if (out.getStatus().isDisabled() || out.getStatus().isStale()) {
            return;
        }
        boolean bl = useInhibit = this.getInhibitTime().getMillis() == 0L && this.getAlarmInhibit().getBoolean() || (this.inhibitTicket == null || this.inhibitTicket.isExpired()) && this.getAlarmInhibit().getBoolean() || this.inhibitTicket != null && !this.inhibitTicket.isExpired() && !this.getAlarmInhibit().getBoolean();
        if (useInhibit) {
            if (alarmState != BAlarmState.normal) {
                newAlarmState = BAlarmState.normal;
            }
        } else {
            if (this.getAlarmEnable().isToFault()) {
                newAlarmState = this.getFaultAlgorithm().checkFault(out);
            }
            if (alarmState == BAlarmState.fault && !this.getAlarmEnable().isToFault()) {
                newAlarmState = BAlarmState.normal;
            }
            if (newAlarmState != BAlarmState.fault && this.getAlarmEnable().isToOffnormal()) {
                if (newAlarmState == null) {
                    if (alarmState != BAlarmState.fault) {
                        newAlarmState = this.getOffnormalAlgorithm().checkAlarmState(out, this.getTimeDelay().getMillis(), this.getTimeDelayToNormal().getMillis());
                    }
                } else if (newAlarmState == BAlarmState.normal && (newAlarmState = this.getOffnormalAlgorithm().checkAlarmState(out, this.getTimeDelay().getMillis(), this.getTimeDelayToNormal().getMillis())) == null) {
                    newAlarmState = BAlarmState.normal;
                }
            }
            if (alarmState.isOffnormal() && !this.getAlarmEnable().isToOffnormal()) {
                newAlarmState = BAlarmState.normal;
            }
        }
        boolean ackRequired = true;
        if (newAlarmState != null) {
            if (this.getAlarmEnable().isToOffnormal() && newAlarmState.isInAlarm()) {
                this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)true));
            } else if (!newAlarmState.isInAlarm()) {
                this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)false));
            }
            if (this.getAlarmEnable().isToFault() && newAlarmState == BAlarmState.fault) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            } else if (newAlarmState != BAlarmState.fault) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            }
            if (newAlarmState == BAlarmState.normal) {
                ackRequired = this.alarmStateTransition(BSourceState.normal, BAlarmState.normal, out);
                if (alarmState.isOffnormal()) {
                    ackRequired |= this.support.isAckRequired(BSourceState.offnormal);
                } else if (alarmState.isInAlarm()) {
                    ackRequired |= this.support.isAckRequired(BSourceState.fault);
                }
            } else {
                ackRequired = newAlarmState == BAlarmState.fault ? this.alarmStateTransition(BSourceState.fault, BAlarmState.fault, out) : this.alarmStateTransition(BSourceState.offnormal, newAlarmState, out);
            }
            this.setAlarmState(newAlarmState);
            this.timeOfLastStateChange = Clock.ticks();
            this.setTimeInCurrentState(BRelTime.DEFAULT);
        } else {
            if (this.getAlarmEnable().isToOffnormal()) {
                this.setStatus(BStatus.makeAlarm((BStatus)this.getStatus(), (boolean)alarmState.isInAlarm()));
            }
            if (this.getAlarmEnable().isToFault()) {
                this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (alarmState == BAlarmState.fault ? 1 : 0) != 0));
            }
            this.setTimeInCurrentState(BRelTime.make((long)(Clock.ticks() - this.timeOfLastStateChange)));
        }
        BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
        if (this.getAlarmEnable().isToOffnormal() || this.getAlarmEnable().isToFault()) {
            if (!(ackedTrans.isToOffnormal() && ackedTrans.isToFault() && ackedTrans.isToNormal() || !ackRequired)) {
                this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)true));
            } else {
                this.setStatus(BStatus.makeUnackedAlarm((BStatus)this.getStatus(), (boolean)false));
            }
        }
        if ((alarmState == BAlarmState.lowLimit || alarmState == BAlarmState.highLimit) && newAlarmState == BAlarmState.normal) {
            this.checkAlarms(out);
        }
    }

    private boolean alarmStateTransition(BSourceState sourceState, BAlarmState newAlarmState, BStatusValue out) {
        String[] keys;
        HashMap<String, Object> map = new HashMap<String, Object>();
        BOrd ord = this.getHyperlinkOrd();
        Property alarmTimesProp = null;
        if (sourceState == BSourceState.offnormal) {
            map.put("offnormalValue", BString.make((String)out.valueToString((Context)this.getPointFacets())));
            map.put("alarmValue", (BIDataValue)out.getValueValue());
        } else if (sourceState == BSourceState.fault) {
            map.put("faultValue", BString.make((String)out.valueToString((Context)this.getPointFacets())));
            map.put("alarmValue", (BIDataValue)out.getValueValue());
        }
        map.put("presentValue", BString.make((String)out.valueToString((Context)this.getPointFacets())));
        map.put("fromState", BString.make((String)this.getAlarmState().getTag()));
        map.put("toState", BString.make((String)newAlarmState.getTag()));
        map.put("sourceName", BString.make((String)this.getSourceName().format((Object)this)));
        map.put("timeDelay", this.getTimeDelay());
        map.put("timeDelayToNormal", this.getTimeDelayToNormal());
        if (!ord.isNull()) {
            map.put("hyperlinkOrd", BString.make((String)ord.toString()));
        }
        if (!this.getSoundFile().isNull()) {
            map.put("soundFile", BString.make((String)this.getSoundFile().toString()));
        }
        if (!this.getAlarmIcon().isNull()) {
            map.put("icon", BString.make((String)this.getAlarmIcon().toString()));
        }
        try {
            if (!this.getAlarmInstructions().equals((Object)BAlarmInstructions.NULL)) {
                map.put("instructions", BString.make((String)this.getAlarmInstructions().encodeToString()));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not encode Alarm Instructions", e);
        }
        BFacets alarmMetaData = this.getMetaData();
        for (String key : keys = alarmMetaData.list()) {
            map.put(key, (BIDataValue)alarmMetaData.get(key));
        }
        if (sourceState == BSourceState.normal) {
            map.put("msgText", BString.make((String)this.getToNormalText().getFormat()));
            if (this.getAlarmState().isInAlarm()) {
                this.getOffnormalAlgorithm().writeAlarmData(out, map);
            } else {
                this.getFaultAlgorithm().writeAlarmData(out, map);
            }
        } else if (sourceState == BSourceState.offnormal) {
            map.put("msgText", BString.make((String)this.getToOffnormalText().getFormat()));
            map.put(BAlarmTimestamps.count.getDefaultDisplayName(null), BInteger.make((int)(this.getToOffnormalTimes().getCount() + 1)));
            this.getOffnormalAlgorithm().writeAlarmData(out, map);
            alarmTimesProp = toOffnormalTimes;
        } else if (sourceState == BSourceState.fault) {
            map.put("msgText", BString.make((String)this.getToFaultText().getFormat()));
            map.put(BAlarmTimestamps.count.getDefaultDisplayName(null), BInteger.make((int)(this.getToFaultTimes().getCount() + 1)));
            this.getFaultAlgorithm().writeAlarmData(out, map);
            alarmTimesProp = toFaultTimes;
        } else {
            throw new IllegalStateException();
        }
        boolean ackRequired = false;
        try {
            ackRequired = this.support.isAckRequired(sourceState);
            BAlarmRecord rec = null;
            if (sourceState == BSourceState.normal) {
                this.support.toNormal(BFacets.make(map), null);
            } else if (sourceState == BSourceState.offnormal) {
                rec = this.support.newOffnormalAlarm(BFacets.make(map));
                this.lastOffnormalTime = rec.getTimestamp();
                this.fireToOffnormal(rec);
            } else if (sourceState == BSourceState.fault) {
                rec = this.support.newFaultAlarm(BFacets.make(map));
                this.lastFaultTime = rec.getTimestamp();
                this.fireToFault(rec);
            }
            if (rec != null) {
                if (sourceState == BSourceState.normal) {
                    this.updateNormalTimes(rec);
                }
                if (alarmTimesProp != null) {
                    BAlarmTimestamps alarmTimes = (BAlarmTimestamps)this.get(alarmTimesProp);
                    alarmTimes.setAlarmTime(rec.getTimestamp());
                    alarmTimes.setAckTime(BAbsTime.NULL);
                    alarmTimes.setNormalTime(BAbsTime.NULL);
                    alarmTimes.setCount(alarmTimes.getCount() + 1);
                }
            }
            if (ackRequired) {
                BAlarmTransitionBits ackedTrans = this.getAckedTransitions();
                this.setAckedTransitions(BAlarmTransitionBits.make(ackedTrans, sourceState.getAlarmTransitionBits(), false));
            }
        }
        catch (ServiceNotFoundException e) {
            log.severe("AlarmState Transition Failed - AlarmService not found.");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "AlarmState Transition Failed: " + e, e);
        }
        return ackRequired;
    }

    public void fireToNormal(BAlarmRecord record) {
        this.lastToNormalTime = record.getNormalTime();
        if (record.getSourceState().getOrdinal() == 0) {
            this.updateNormalTimes(record);
        }
        this.fire(toNormal, (BValue)record, null);
    }

    public boolean isLastNormalRecord(BAlarmRecord alarmRecord) {
        Objects.requireNonNull(alarmRecord, "alarmRecord parameter must not be null");
        BAlarmRecord lastNormal = this.support.getLastNormal();
        if (lastNormal != null) {
            return alarmRecord.getUuid().equals((Object)lastNormal.getUuid());
        }
        BOrdList source = alarmRecord.getSource();
        if (alarmRecord.getSourceState().equals((Object)BSourceState.normal) && source.size() > 0) {
            try {
                return source.get(0).get().equals((Object)this);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Could not resolve alarm record's source while checking whether it is the last normal record; source: [" + source + ']', e);
            }
        }
        return false;
    }

    public BAbsTime getLastOffnormalTime() {
        return this.lastOffnormalTime;
    }

    public BAbsTime getLastFaultTime() {
        return this.lastFaultTime;
    }

    public BAbsTime getLastToNormalTime() {
        return this.lastToNormalTime;
    }

    public BAbsTime getLastAckTime() {
        return this.lastAckTime;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static void dump(String s) {
        System.out.println(s);
    }
}

