/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BAlarmSourceInfo
extends BComponent {
    public static final Property alarmClass = BAlarmSourceInfo.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    public static final Property sourceName = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%"), null);
    public static final Property toFaultText = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    public static final Property toOffnormalText = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    public static final Property toNormalText = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    public static final Property hyperlinkOrd = BAlarmSourceInfo.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE, (String)"chooseView", (BIDataValue)BBoolean.TRUE));
    public static final Property soundFile = BAlarmSourceInfo.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:AudioFile")));
    public static final Property alarmIcon = BAlarmSourceInfo.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:ImageFile")));
    public static final Property alarmInstructions = BAlarmSourceInfo.newProperty((int)0, (BValue)BAlarmInstructions.make(""), null);
    public static final Property metaData = BAlarmSourceInfo.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAlarmSourceInfo.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/alarmService.png");

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BFormat getSourceName() {
        return (BFormat)this.get(sourceName);
    }

    public void setSourceName(BFormat v) {
        this.set(sourceName, (BValue)v, null);
    }

    public BFormat getToFaultText() {
        return (BFormat)this.get(toFaultText);
    }

    public void setToFaultText(BFormat v) {
        this.set(toFaultText, (BValue)v, null);
    }

    public BFormat getToOffnormalText() {
        return (BFormat)this.get(toOffnormalText);
    }

    public void setToOffnormalText(BFormat v) {
        this.set(toOffnormalText, (BValue)v, null);
    }

    public BFormat getToNormalText() {
        return (BFormat)this.get(toNormalText);
    }

    public void setToNormalText(BFormat v) {
        this.set(toNormalText, (BValue)v, null);
    }

    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    public void setHyperlinkOrd(BOrd v) {
        this.set(hyperlinkOrd, (BValue)v, null);
    }

    public BOrd getSoundFile() {
        return (BOrd)this.get(soundFile);
    }

    public void setSoundFile(BOrd v) {
        this.set(soundFile, (BValue)v, null);
    }

    public BOrd getAlarmIcon() {
        return (BOrd)this.get(alarmIcon);
    }

    public void setAlarmIcon(BOrd v) {
        this.set(alarmIcon, (BValue)v, null);
    }

    public BAlarmInstructions getAlarmInstructions() {
        return (BAlarmInstructions)this.get(alarmInstructions);
    }

    public void setAlarmInstructions(BAlarmInstructions v) {
        this.set(alarmInstructions, (BValue)v, null);
    }

    public BFacets getMetaData() {
        return (BFacets)this.get(metaData);
    }

    public void setMetaData(BFacets v) {
        this.set(metaData, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets makeAlarmData(BSourceState state) {
        String[] keys;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.getSourceName().toString().equals("")) {
            map.put("sourceName", BString.make((String)this.getSourceName().format((Object)this)));
        }
        String msgTxt = "";
        if (state == BSourceState.offnormal) {
            msgTxt = this.getToOffnormalText().toString();
        } else if (state == BSourceState.fault) {
            msgTxt = this.getToFaultText().toString();
        } else if (state == BSourceState.normal) {
            msgTxt = this.getToNormalText().toString();
        } else if (state == BSourceState.alert) {
            msgTxt = this.getToOffnormalText().toString();
        }
        if (!msgTxt.equals("")) {
            map.put("msgText", BString.make((String)msgTxt));
        }
        if (this.getHyperlinkOrd() != BOrd.NULL) {
            map.put("hyperlinkOrd", BString.make((String)this.getHyperlinkOrd().toString()));
        }
        if (this.getSoundFile() != BOrd.NULL) {
            map.put("soundFile", BString.make((String)this.getSoundFile().toString()));
        }
        if (this.getAlarmIcon() != BOrd.NULL) {
            map.put("icon", BString.make((String)this.getAlarmIcon().toString()));
        }
        try {
            if (!this.getAlarmInstructions().equals((Object)BAlarmInstructions.NULL)) {
                map.put("instructions", BString.make((String)this.getAlarmInstructions().encodeToString()));
            }
        }
        catch (Exception e) {
            Logger.getLogger("alarm").log(Level.SEVERE, "Could not encode Alarm Instructions", e);
        }
        for (String key : keys = this.getMetaData().list()) {
            map.put(key, (BIDataValue)this.getMetaData().get(key));
        }
        return BFacets.make(map);
    }

    public BIcon getIcon() {
        return icon;
    }
}

