/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.BAlarmExtStatusJob;
import com.tridium.alarm.BIUpdatableAlarmSource;
import com.tridium.alarm.db.file.BFileAlarmDatabase;
import com.tridium.alarm.db.file.BFileAlarmDbConfig;
import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.BPlatformServiceSourceState;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.sys.station.Station;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BIRemoteAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySourceService;
import javax.baja.license.Feature;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.util.Array;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BIProtected;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BUuid;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Version;
import javax.baja.util.Worker;

@NiagaraProperties(value={@NiagaraProperty(name="alarmDbConfig", type="BAlarmDbConfig", defaultValue="new BFileAlarmDbConfig()"), @NiagaraProperty(name="defaultAlarmClass", type="BAlarmClass", defaultValue="new BAlarmClass()"), @NiagaraProperty(name="masterAlarmInstructions", type="BAlarmInstructions", defaultValue="BAlarmInstructions.make(\"\")"), @NiagaraProperty(name="escalationTimeTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(1)))", flags=4), @NiagaraProperty(name="coalesceAlarms", type="BBoolean", defaultValue="BBoolean.TRUE")})
@NiagaraActions(value={@NiagaraAction(name="routeAlarm", parameterType="BAlarmRecord", flags=4, defaultValue="new BAlarmRecord()"), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", flags=4, defaultValue="new BAlarmRecord()"), @NiagaraAction(name="enableToOffnormal", parameterType="BVector", returnType="BOrd", flags=4, defaultValue="new BVector()"), @NiagaraAction(name="disableToOffnormal", parameterType="BVector", returnType="BOrd", flags=4, defaultValue="new BVector()"), @NiagaraAction(name="enableToFault", parameterType="BVector", returnType="BOrd", flags=4, defaultValue="new BVector()"), @NiagaraAction(name="disableToFault", parameterType="BVector", returnType="BOrd", flags=4, defaultValue="new BVector()"), @NiagaraAction(name="auditForceClear", parameterType="BAlarmRecord", flags=2052, defaultValue="new BAlarmRecord()"), @NiagaraAction(name="escalateAlarms", flags=2068)})
@NiagaraTopic(name="alarm", eventType="BAlarmRecord", flags=8)
public class BAlarmService
extends BAbstractService
implements BIAlarmClassFolder,
BIDataRecoverySourceService,
BIRestrictedComponent {
    public static final Property alarmDbConfig = BAlarmService.newProperty((int)0, (BValue)new BFileAlarmDbConfig(), null);
    public static final Property defaultAlarmClass = BAlarmService.newProperty((int)0, (BValue)new BAlarmClass(), null);
    public static final Property masterAlarmInstructions = BAlarmService.newProperty((int)0, (BValue)BAlarmInstructions.make(""), null);
    public static final Property escalationTimeTrigger = BAlarmService.newProperty((int)4, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)1))), null);
    public static final Property coalesceAlarms = BAlarmService.newProperty((int)0, (boolean)BBoolean.TRUE.getBoolean(), null);
    public static final Action routeAlarm = BAlarmService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action ackAlarm = BAlarmService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action enableToOffnormal = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action disableToOffnormal = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action enableToFault = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action disableToFault = BAlarmService.newAction((int)4, (BValue)new BVector(), null);
    public static final Action auditForceClear = BAlarmService.newAction((int)2052, (BValue)new BAlarmRecord(), null);
    public static final Action escalateAlarms = BAlarmService.newAction((int)2068, null);
    public static final Topic alarm = BAlarmService.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BAlarmService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    HashMap<Object, String> alarmClassDisplayNames = new HashMap();
    private Version remoteVersion = null;
    private static final BIcon icon = BIcon.std((String)"navOnly/alarmService.png");
    public static final Logger logger = Logger.getLogger("alarm");
    private static final BString LEVEL_1_STRING = BString.make((String)"level1");
    private static final BString LEVEL_2_STRING = BString.make((String)"level2");
    private static final BString LEVEL_3_STRING = BString.make((String)"level3");
    private final PlatformServiceListener listener = new PlatformServiceListener();
    private BAlarmDatabase alarmDb;
    private final Queue alarmQueue = new CoalesceQueue();
    private Worker alarmWorker;
    private final Station.SaveListener saveListener = new Station.SaveListener(){

        public void stationSave() {
            try {
                BAlarmService.this.getAlarmDb().save();
            }
            catch (Exception e) {
                BAlarmDatabase.log.log(Level.SEVERE, "Alarm database save failed.", e);
            }
        }

        public void stationSaveOk() {
        }

        public void stationSaveFail(String cause) {
        }

        public String toString() {
            return "AlarmService " + BAlarmService.this.getNavOrd();
        }
    };

    public BAlarmDbConfig getAlarmDbConfig() {
        return (BAlarmDbConfig)this.get(alarmDbConfig);
    }

    public void setAlarmDbConfig(BAlarmDbConfig v) {
        this.set(alarmDbConfig, (BValue)v, null);
    }

    public BAlarmClass getDefaultAlarmClass() {
        return (BAlarmClass)this.get(defaultAlarmClass);
    }

    public void setDefaultAlarmClass(BAlarmClass v) {
        this.set(defaultAlarmClass, (BValue)v, null);
    }

    public BAlarmInstructions getMasterAlarmInstructions() {
        return (BAlarmInstructions)this.get(masterAlarmInstructions);
    }

    public void setMasterAlarmInstructions(BAlarmInstructions v) {
        this.set(masterAlarmInstructions, (BValue)v, null);
    }

    public BTimeTrigger getEscalationTimeTrigger() {
        return (BTimeTrigger)this.get(escalationTimeTrigger);
    }

    public void setEscalationTimeTrigger(BTimeTrigger v) {
        this.set(escalationTimeTrigger, (BValue)v, null);
    }

    public boolean getCoalesceAlarms() {
        return this.getBoolean(coalesceAlarms);
    }

    public void setCoalesceAlarms(boolean v) {
        this.setBoolean(coalesceAlarms, v, null);
    }

    public void routeAlarm(BAlarmRecord parameter) {
        this.invoke(routeAlarm, (BValue)parameter, null);
    }

    public void ackAlarm(BAlarmRecord parameter) {
        this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public BOrd enableToOffnormal(BVector parameter) {
        return (BOrd)this.invoke(enableToOffnormal, (BValue)parameter, null);
    }

    public BOrd disableToOffnormal(BVector parameter) {
        return (BOrd)this.invoke(disableToOffnormal, (BValue)parameter, null);
    }

    public BOrd enableToFault(BVector parameter) {
        return (BOrd)this.invoke(enableToFault, (BValue)parameter, null);
    }

    public BOrd disableToFault(BVector parameter) {
        return (BOrd)this.invoke(disableToFault, (BValue)parameter, null);
    }

    public void auditForceClear(BAlarmRecord parameter) {
        this.invoke(auditForceClear, (BValue)parameter, null);
    }

    public void escalateAlarms() {
        this.invoke(escalateAlarms, null, null);
    }

    public void fireAlarm(BAlarmRecord event) {
        this.fire(alarm, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        if (this.isOperational()) {
            try {
                BPlatformService[] platSvcs;
                BPlatformServiceContainer container = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
                for (BPlatformService platSvc : platSvcs = (BPlatformService[])container.getChildren(BPlatformService.class)) {
                    if (!(platSvc instanceof BIAlarmablePlatformService)) continue;
                    ((BIAlarmablePlatformService)platSvc).addPlatformServiceAlarmListener((PlatformServiceAlarmListener)this.listener);
                }
            }
            catch (Exception e) {
                logger.severe("Cannot setup alarming for platform service\n  " + e);
            }
            if (this.alarmWorker == null) {
                this.alarmWorker = new Worker((Worker.ITodo)this.alarmQueue);
            }
            this.alarmWorker.start("Alarm:ServiceWorker");
            this.initAlarmDb();
            BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
            if (registry.get("alarmdb") == null) {
                registry.add("alarmdb", (BValue)new BAlarmDbChannel());
            }
            Station.addSaveListener((Station.SaveListener)this.saveListener);
            try {
                BLocalHost.INSTANCE.addNavChild((BINavNode)this.getAlarmDb());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void atSteadyState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStopped() {
        BPlatformService[] platSvcs;
        BFoxChannelRegistry registry;
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
        if (this.alarmWorker != null) {
            this.alarmWorker.stop();
        }
        if ((registry = BFoxChannelRegistry.getPrototype()).get("alarmdb") != null) {
            registry.remove("alarmdb");
        }
        if (this.alarmDb != null) {
            try {
                this.alarmDb.flush();
            }
            catch (IOException e) {
                String msg = "Alarm database save failed";
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.SEVERE, msg, e);
                } else {
                    logger.severe(msg);
                }
            }
            finally {
                this.alarmDb.close();
                this.alarmDb = null;
            }
        }
        BPlatformServiceContainer container = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
        for (BPlatformService platSvc : platSvcs = (BPlatformService[])container.getChildren(BPlatformService.class)) {
            if (!(platSvc instanceof BIAlarmablePlatformService)) continue;
            ((BIAlarmablePlatformService)platSvc).removePlatformServiceAlarmListener((PlatformServiceAlarmListener)this.listener);
        }
    }

    public Feature getLicenseFeature() {
        Feature feature = Sys.getLicenseManager().getFeature("tridium", "alarm");
        String alarmType = feature.get("type", "");
        if (alarmType.isEmpty()) {
            this.configFatal("Unlicensed for all alarm types. Alarms are disabled.");
        }
        return feature;
    }

    protected final void enabled() {
        this.serviceStarted();
    }

    protected final void disabled() {
        this.serviceStopped();
    }

    public void initDataRecoverySource(BIDataRecoveryService service) {
        if (this.alarmWorker == null) {
            this.alarmWorker = new Worker((Worker.ITodo)this.alarmQueue);
            this.alarmWorker.start("Alarm:ServiceWorker");
        }
        this.initAlarmDb();
    }

    private void initAlarmDb() {
        if (!this.isOperational()) {
            throw new NotRunningException("The AlarmService is not operational");
        }
        if (this.alarmDb == null) {
            this.alarmDb = this.createAlarmDb();
            try {
                this.alarmDb.open();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot open alarm database.", e);
            }
        }
    }

    public final BAlarmDatabase getAlarmDb() throws AlarmException {
        if (this.alarmDb == null) {
            throw new AlarmException("Alarm database is not open.");
        }
        return this.alarmDb;
    }

    protected BAlarmDatabase createAlarmDb() {
        return new BFileAlarmDatabase();
    }

    protected void alarmDbConfigChanged(Property p) throws AlarmException {
        this.getAlarmDb().updateConfig(this.getAlarmDbConfig(), p);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(escalateAlarms)) {
            this.alarmQueue.enqueue((Object)new Invocation((BComponent)this, action, null, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void doEscalateAlarms() {
        if (!this.isRunning() || !this.isOperational()) {
            return;
        }
        try {
            StringBuilder bql = new StringBuilder("alarm:|bql:select from openAlarms ");
            int classCount = 0;
            boolean escalationInUse = false;
            for (BAlarmClass alarmClass : this.getAlarmClasses()) {
                if (!alarmClass.getEscalationLevel1Enabled() && !alarmClass.getEscalationLevel2Enabled() && !alarmClass.getEscalationLevel3Enabled()) continue;
                escalationInUse = true;
                if (classCount != 0) {
                    bql.append("or ");
                } else {
                    bql.append("where (");
                }
                ++classCount;
                bql.append("alarmClass='");
                bql.append(SlotPath.escape((String)alarmClass.getName()));
                bql.append("' ");
            }
            if (classCount > 0) {
                bql.append(')');
            }
            if (!escalationInUse) {
                return;
            }
            BITable table = (BITable)BOrd.make((String)bql.toString()).get((BObject)this);
            TableCursor cur = table.cursor();
            HashMap<BUuid, BAlarmRecord> updates = new HashMap<BUuid, BAlarmRecord>();
            while (cur.next()) {
                BAlarmRecord record = (BAlarmRecord)((Object)cur.get());
                if (record.getAckState() != BAckState.unacked) continue;
                BAlarmClass alarmClass = this.lookupAlarmClass(record.getAlarmClass());
                BObject escalatedValue = record.getAlarmData().get("escalated");
                if (alarmClass.getEscalationLevel1Enabled() && escalatedValue.equals((Object)BString.DEFAULT)) {
                    if (!record.getTimestamp().add(alarmClass.getEscalationLevel1Delay()).isBefore(BAbsTime.now())) continue;
                    record.addAlarmFacet("escalated", (BIDataValue)BString.make((String)"level1"));
                    updates.put(record.getUuid(), (BAlarmRecord)record.newCopy());
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Escalating " + record.getUuid() + " to level 1");
                    continue;
                }
                if (alarmClass.getEscalationLevel2Enabled() && (escalatedValue.equals((Object)LEVEL_1_STRING) || escalatedValue.equals((Object)BString.DEFAULT))) {
                    if (!record.getTimestamp().add(alarmClass.getEscalationLevel2Delay()).isBefore(BAbsTime.now())) continue;
                    record.addAlarmFacet("escalated", (BIDataValue)BString.make((String)"level2"));
                    updates.put(record.getUuid(), (BAlarmRecord)record.newCopy());
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Escalating " + record.getUuid() + " to level 2");
                    continue;
                }
                if (!alarmClass.getEscalationLevel3Enabled() || !escalatedValue.equals((Object)LEVEL_2_STRING) && !escalatedValue.equals((Object)LEVEL_1_STRING) && !escalatedValue.equals((Object)BString.DEFAULT) || !record.getTimestamp().add(alarmClass.getEscalationLevel3Delay()).isBefore(BAbsTime.now())) continue;
                record.addAlarmFacet("escalated", (BIDataValue)BString.make((String)"level3"));
                updates.put(record.getUuid(), (BAlarmRecord)record.newCopy());
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Escalating " + record.getUuid() + " to level 3");
            }
            try (AlarmDbConnection connection = this.getAlarmDb().getDbConnection(null);){
                for (BAlarmRecord record : updates.values()) {
                    connection.update(record);
                    BAlarmClass alarmClass = this.lookupAlarmClass(record.getAlarmClass());
                    BObject escalatedValue = record.getAlarmData().get("escalated");
                    if (escalatedValue.equals((Object)LEVEL_1_STRING)) {
                        alarmClass.fireAlarm(record);
                        alarmClass.fireEscalatedAlarm1(record);
                        continue;
                    }
                    if (escalatedValue.equals((Object)LEVEL_2_STRING)) {
                        alarmClass.fireAlarm(record);
                        alarmClass.fireEscalatedAlarm1(record);
                        alarmClass.fireEscalatedAlarm2(record);
                        continue;
                    }
                    if (!escalatedValue.equals((Object)LEVEL_3_STRING)) continue;
                    alarmClass.fireAlarm(record);
                    alarmClass.fireEscalatedAlarm1(record);
                    alarmClass.fireEscalatedAlarm2(record);
                    alarmClass.fireEscalatedAlarm3(record);
                }
            }
        }
        catch (Exception e) {
            BAlarmService.logThrowable("Exception while checking for alarms to escalate", e);
        }
    }

    public void doAckAlarm(BAlarmRecord alarm) throws Exception {
        BObject source = null;
        try {
            source = this.resolveAlarmSource(alarm);
        }
        catch (UnresolvedException unresolvedException) {
            // empty catch block
        }
        if (source instanceof BIRemoteAlarmSource) {
            this.doRouteToSource(alarm, source);
        } else if (alarm.getAckRequired()) {
            this.doRouteToSource(alarm, source);
        } else {
            alarm.setAckState(BAckState.acked);
            this.doRouteToRecipient(alarm);
        }
    }

    public void doRouteAlarm(BAlarmRecord alarm) throws Exception {
        if (!this.isRunning() || !this.isOperational()) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BAlarmService.doRouteAlarm: " + (Object)((Object)alarm.getSourceState()) + ' ' + (Object)((Object)alarm.getAckState()) + ' ' + alarm.getTimestamp() + ' ' + alarm.getAlarmClass());
        }
        this.doRouteToRecipient(alarm);
    }

    public void doRouteToRecipient(BAlarmRecord alarm) {
        BAlarmClass ac = this.lookupAlarmClass(alarm.getAlarmClass());
        ac.routeAlarm(alarm);
        this.fireAlarm(alarm);
    }

    public void doRouteToSource(BAlarmRecord alarm) throws Exception {
        BObject source = null;
        try {
            source = this.resolveAlarmSource(alarm);
        }
        catch (UnresolvedException unresolvedException) {
            // empty catch block
        }
        this.doRouteToSource(alarm, source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRouteToSource(BAlarmRecord alarm, BObject source) throws Exception {
        boolean isAck;
        boolean bl = isAck = alarm.getAckState() == BAckState.ackPending || alarm.getAckState() == BAckState.acked && alarm.getAckRequired();
        if (source == null) {
            logger.severe("BAlarmService.doRouteToSource cannot resolve alarm source " + alarm.getSource());
            if (!isAck) return;
            alarm.setAckState(BAckState.acked);
            alarm.setAckTime(BAbsTime.now());
            alarm.setAckRequired(false);
            alarm.addAlarmFacet("autoAcked", (BIDataValue)BString.make((String)("Cannot resolve: " + alarm.getSource())));
            this.doRouteToRecipient(alarm);
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BAlarmService.doRouteToSource: " + source);
        }
        if (source instanceof BIAlarmSource) {
            try {
                if (isAck) {
                    ((BIAlarmSource)source).ackAlarm(alarm);
                    return;
                }
                if (!(source instanceof BIUpdatableAlarmSource)) return;
                BIUpdatableAlarmSource ext = (BIUpdatableAlarmSource)source;
                ext.updateAlarm(alarm);
                return;
            }
            catch (Exception e) {
                if (!(e instanceof BajaRuntimeException)) throw e;
                throw (Exception)e.getCause();
            }
        } else {
            BPlatformServiceSourceState transState;
            if (!isAck || !(source instanceof BIAlarmablePlatformService)) return;
            BSourceState state = alarm.getAlarmTransition();
            if (state == BSourceState.offnormal) {
                transState = BPlatformServiceSourceState.offnormal;
            } else if (state == BSourceState.fault) {
                transState = BPlatformServiceSourceState.fault;
            } else {
                if (state != BSourceState.alert) throw new IllegalStateException();
                transState = BPlatformServiceSourceState.alert;
            }
            BOrdList stackedSource = alarm.getSource();
            BOrd localSource = stackedSource.get(stackedSource.size() - 1);
            BPlatformServiceAlarmRecord record = new BPlatformServiceAlarmRecord(localSource, alarm.getAlarmClass(), transState, alarm.getAlarmData());
            record.setTimestamp(alarm.getTimestamp());
            ((BIAlarmablePlatformService)source).ackAlarm(record);
            alarm.setAckState(BAckState.acked);
            alarm.setAckTime(BAbsTime.now());
            alarm.setAckRequired(false);
            alarm.setAlarmClass(record.getAlarmClass());
            this.doRouteToRecipient(alarm);
        }
    }

    public BOrd doEnableToOffnormal(BVector extOrds, Context cx) {
        return new BAlarmExtStatusJob(this, extOrds, BAlarmTransitionBits.toOffnormal, true).submit(cx);
    }

    public BOrd doDisableToOffnormal(BVector extOrds, Context cx) {
        return new BAlarmExtStatusJob(this, extOrds, BAlarmTransitionBits.toOffnormal, false).submit(cx);
    }

    public BOrd doEnableToFault(BVector extOrds, Context cx) {
        return new BAlarmExtStatusJob(this, extOrds, BAlarmTransitionBits.toFault, true).submit(cx);
    }

    public BOrd doDisableToFault(BVector extOrds, Context cx) {
        return new BAlarmExtStatusJob(this, extOrds, BAlarmTransitionBits.toFault, false).submit(cx);
    }

    public void doAuditForceClear(BAlarmRecord rec, Context cx) {
        Auditor auditor = Sys.getAuditor();
        if (auditor != null) {
            BUser user = cx.getUser();
            String username = "";
            if (user != null) {
                username = user.getUsername();
            }
            user.getUsername();
            auditor.audit(new AuditEvent("Force Clear Alarm", rec.getSource().toString(), rec.getUuid().toString(), "", "", username));
        }
    }

    public BAlarmClass[] getAlarmClasses() {
        return BAlarmService.loadFromFolder((BComponent)this);
    }

    private static BAlarmClass[] loadFromFolder(BComponent folder) {
        BAlarmClassFolder[] folders;
        BAlarmClass[] direct;
        Array alarmClasses = new Array(BAlarmClass.class);
        folder.lease();
        for (BAlarmClass aDirect : direct = (BAlarmClass[])folder.getChildren(BAlarmClass.class)) {
            alarmClasses.add((Object)aDirect);
        }
        for (BAlarmClassFolder aFolder : folders = (BAlarmClassFolder[])folder.getChildren(BAlarmClassFolder.class)) {
            BAlarmClass[] indirect;
            BAlarmService.loadFromFolder((BComponent)aFolder);
            for (BAlarmClass anIndirect : indirect = BAlarmService.loadFromFolder((BComponent)aFolder)) {
                alarmClasses.add((Object)anIndirect);
            }
        }
        return (BAlarmClass[])alarmClasses.trim();
    }

    public BAlarmClass lookupAlarmClass(String alarmClassName) {
        BAlarmClass ac = this.lookupAlarmClass((BComponent)this, alarmClassName);
        if (ac == null) {
            ac = this.getDefaultAlarmClass();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("BAlarmService.lookupAlarmClass can't find alarm class <" + alarmClassName + "> using default <" + ac.getName() + '>');
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("BAlarmService.lookupAlarmClass: will route alarm with " + (Object)((Object)ac));
        }
        return ac;
    }

    protected BAlarmClass lookupAlarmClass(BComponent folder, String alarmClassName) {
        folder.lease();
        Property acp = folder.getProperty(alarmClassName);
        if (acp == null || !folder.get(acp).getType().is(BAlarmClass.TYPE)) {
            BAlarmClassFolder[] folders;
            for (BAlarmClassFolder alarmClassFolder : folders = (BAlarmClassFolder[])folder.getChildren(BAlarmClassFolder.class)) {
                BAlarmClass temp = this.lookupAlarmClass((BComponent)alarmClassFolder, alarmClassName);
                if (temp == null) continue;
                return temp;
            }
        } else {
            return (BAlarmClass)folder.get(acp);
        }
        return null;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public BString getAlarmClassDisplayName(Object alarmClass, Context cx) {
        BComponentSpace space = this.getComponentSpace();
        if (space != null && space.isProxyComponentSpace()) {
            if (this.remoteVersionGtOrEq("3.7.35")) {
                try {
                    return (BString)FoxRpcUtil.doRpc((BISpaceNode)this, (String)"getAlarmClassDisplayName", (Object[])new Object[]{BString.make((String)alarmClass.toString())}).get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return BString.make((String)alarmClass.toString());
        }
        String displayName = this.alarmClassDisplayNames.get(alarmClass.toString());
        if (displayName == null) {
            displayName = this.lookupAlarmClass(alarmClass.toString()).getDisplayName(cx);
            this.alarmClassDisplayNames.put(alarmClass, displayName);
        }
        return BString.make((String)displayName);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public Map<String, String> getAlarmClassDisplayNameMap(Context cx) {
        Map<String, String> alarmClassDisplayNameMap = new HashMap<String, String>();
        BComponentSpace space = this.getComponentSpace();
        if (space != null && space.isProxyComponentSpace()) {
            if (this.remoteVersionGtOrEq("4.9.0")) {
                try {
                    alarmClassDisplayNameMap = (Map)FoxRpcUtil.doRpc((BISpaceNode)this, (String)"getAlarmClassDisplayNameMap", (Object[])new Object[0]).get();
                }
                catch (Exception exception) {}
            }
        } else {
            this.addAlarmClassesToDisplayNameMap(alarmClassDisplayNameMap, (BComponent)this, cx);
        }
        return alarmClassDisplayNameMap;
    }

    private BObject resolveAlarmSource(BAlarmRecord req) throws Exception {
        BObject source = null;
        BOrdList stackedSource = req.getSource();
        BOrd localSource = stackedSource.get(stackedSource.size() - 1);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BAlarmService::resolveAlarmSource = " + localSource);
        }
        source = localSource.get((BObject)this);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("  BAlarmService::resolveAlarmSource resolved = " + source);
        }
        return source;
    }

    private void addAlarmClassesToDisplayNameMap(Map<String, String> map, BComponent folder, Context cx) {
        BAlarmClassFolder[] alarmClassFolders;
        BAlarmClass[] alarmClasses;
        for (BAlarmClass alarmClass : alarmClasses = (BAlarmClass[])folder.getChildren(BAlarmClass.class)) {
            if (cx == null || cx.getUser() == null || !cx.getUser().getPermissionsFor((BIProtected)alarmClass).hasOperatorRead()) continue;
            map.put(alarmClass.getName(), alarmClass.getDisplayName(cx));
        }
        for (BAlarmClassFolder alarmClassFolder : alarmClassFolders = (BAlarmClassFolder[])folder.getChildren(BAlarmClassFolder.class)) {
            this.addAlarmClassesToDisplayNameMap(map, (BComponent)alarmClassFolder, cx);
        }
    }

    private boolean remoteVersionGtOrEq(String versionString) {
        boolean result = false;
        if (this.remoteVersion == null) {
            try {
                this.remoteVersion = (Version)((BFoxSession)this.getSession()).fw(404, (Object)"alarm", null, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.remoteVersion != null && !this.remoteVersion.isNull()) {
            result = this.remoteVersion.compareTo(new Version(versionString)) >= 0;
        }
        return result;
    }

    public void checkAdd(String newName, BValue value, int flags, BFacets facets, Context context) {
        if (this.isRunning() && this.isOperational() && value.getType().is(BAlarmClass.TYPE)) {
            BAlarmClass existingClass = this.lookupAlarmClass(newName);
            if (newName.equals("defaultAlarmClass") || !existingClass.getName().equals("defaultAlarmClass")) {
                throw new LocalizableRuntimeException("alarm", "DuplicateAlarmClass", (Object[])new String[]{newName});
            }
        }
        super.checkAdd(newName, value, flags, facets, context);
    }

    public void checkRename(Property property, String newName, Context context) {
        if (property.getType().is(BAlarmClass.TYPE)) {
            BAlarmClass existingClass = this.lookupAlarmClass(newName);
            if (newName.equals("defaultAlarmClass") || !existingClass.getName().equals("defaultAlarmClass")) {
                throw new IllegalNameException("alarm", "DuplicateAlarmClass", (Object[])new String[]{newName});
            }
            this.alarmClassDisplayNames.clear();
        }
        super.checkRename(property, newName, context);
    }

    public void changed(Property prop, Context cx) {
        if (prop.getName().equals("displayNames")) {
            this.alarmClassDisplayNames.clear();
        }
    }

    public void added(Property prop, Context cx) {
        if (prop.getName().equals("displayNames")) {
            this.alarmClassDisplayNames.clear();
        }
    }

    public void removed(Property prop, BValue oldValue, Context cx) {
        if (prop.getName().equals("displayNames")) {
            this.alarmClassDisplayNames.clear();
        }
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)true);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("wiresheet:WireSheet");
        return BAlarmDatabase.filterAgents(list);
    }

    public BIcon getIcon() {
        return icon;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.add(null, (BValue)new BLink(this.getEscalationTimeTrigger().getOrdInSession(), "fireTrigger", "escalateAlarms", true), 6);
                break;
            }
            case 21: {
                if (this.alarmDb == null) break;
                this.alarmDb.fw(x, a, b, c, d);
                break;
            }
            case 601: {
                return this.alarmQueue;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"BAlarmService", 2);
        out.prop((Object)"workInAlarmQueue", (Object)String.valueOf(this.alarmQueue != null ? this.alarmQueue.size() : 0));
        out.endProps();
        if (this.alarmWorker != null) {
            this.alarmWorker.spy(out);
        }
    }

    private static void logThrowable(String message, Throwable thrown) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, message, thrown);
        } else {
            logger.warning(message);
        }
    }

    class PlatformServiceListener
    implements PlatformServiceAlarmListener {
        PlatformServiceListener() {
        }

        public void platformServiceAlarm(BPlatformServiceAlarmRecord platformServiceAlarm) {
            BSourceState sourceState;
            BPlatformServiceSourceState pt = platformServiceAlarm.getSourceState();
            if (pt == BPlatformServiceSourceState.normal) {
                this.platformServiceToNormal(platformServiceAlarm);
                return;
            }
            if (pt == BPlatformServiceSourceState.offnormal) {
                sourceState = BSourceState.offnormal;
            } else if (pt == BPlatformServiceSourceState.fault) {
                sourceState = BSourceState.fault;
            } else if (pt == BPlatformServiceSourceState.alert) {
                sourceState = BSourceState.alert;
            } else {
                throw new IllegalStateException();
            }
            BAlarmRecord alarm = null;
            try (AlarmDbConnection conn = BAlarmService.this.getAlarmDb().getDbConnection(null);){
                alarm = conn.getRecord(platformServiceAlarm.getUuid());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alarm == null) {
                alarm = new BAlarmRecord(platformServiceAlarm.getSource(), platformServiceAlarm.getAlarmClass(), platformServiceAlarm.getAlarmData(), BUuid.DEFAULT);
                alarm.setUuid(platformServiceAlarm.getUuid());
                alarm.setTimestamp(platformServiceAlarm.getTimestamp());
            }
            alarm.setSourceState(sourceState);
            alarm.setAlarmTransition(sourceState);
            BAlarmService.this.routeAlarm(alarm);
        }

        public void platformServiceToNormal(BPlatformServiceAlarmRecord platformServiceAlarm) {
            try (AlarmDbConnection conn = BAlarmService.this.getAlarmDb().getDbConnection(null);
                 Cursor<BAlarmRecord> cur = conn.getAlarmsForSource(BOrdList.make((BOrd)platformServiceAlarm.getSource()));){
                while (cur.next()) {
                    BAlarmRecord alarm = (BAlarmRecord)((Object)cur.get());
                    if (alarm.isNormal()) continue;
                    alarm.setAlarmClass(platformServiceAlarm.getAlarmClass());
                    alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (BFacets)platformServiceAlarm.getAlarmData()));
                    alarm.setNormalTime(platformServiceAlarm.getTimestamp());
                    alarm.setSourceState(BSourceState.normal);
                    BAlarmService.this.routeAlarm((BAlarmRecord)alarm.newCopy());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to generate toNormal PlatformServiceAlarm for: " + platformServiceAlarm.getSource(), e);
            }
        }
    }
}

