/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public final class BAlarmSchema
extends BSimple {
    public static final BAlarmSchema DEFAULT = new BAlarmSchema();
    private String[] names;
    private BTypeSpec[] types;
    private boolean frozen = false;
    private Unfrozen pending = null;
    public static final Type TYPE;

    public BAlarmSchema() {
        this.frozen = false;
    }

    public BAlarmSchema(String[] newNames, BTypeSpec[] newTypes) {
        this.names = new String[newNames.length];
        System.arraycopy(newNames, 0, this.names, 0, newNames.length);
        this.types = new BTypeSpec[newTypes.length];
        System.arraycopy(newTypes, 0, this.types, 0, newTypes.length);
        this.frozen = true;
    }

    public int getColumnCount() {
        this.freeze();
        return this.names.length;
    }

    public String getColumnName(int colIndex) {
        this.freeze();
        return this.names[colIndex];
    }

    public BTypeSpec getColumnType(int colIndex) {
        this.freeze();
        return this.types[colIndex];
    }

    public int hashCode() {
        int i;
        this.freeze();
        int hash = 0;
        for (i = 0; i < this.names.length; ++i) {
            hash = 31 * hash + this.names[i].hashCode();
        }
        for (i = 0; i < this.types.length; ++i) {
            hash = 31 * hash + this.types[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof BAlarmSchema) {
            int i;
            BAlarmSchema other = (BAlarmSchema)((Object)o);
            this.freeze();
            other.freeze();
            if (this.names.length != other.names.length) {
                return false;
            }
            if (this.types.length != other.types.length) {
                return false;
            }
            for (i = 0; i < this.names.length; ++i) {
                if (this.names[i].equals(other.names[i])) continue;
                return false;
            }
            for (i = 0; i < this.types.length; ++i) {
                if (this.types[i].equals((Object)other.types[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        this.freeze();
        int colCount = this.names.length;
        out.writeInt(colCount);
        for (int i = 0; i < colCount; ++i) {
            out.writeUTF(this.names[i]);
            this.types[i].encode(out);
        }
    }

    public BObject decode(DataInput in) throws IOException {
        int colCount = in.readInt();
        String[] names = new String[colCount];
        BTypeSpec[] types = new BTypeSpec[colCount];
        for (int i = 0; i < colCount; ++i) {
            names[i] = in.readUTF();
            types[i] = (BTypeSpec)BTypeSpec.DEFAULT.decode(in);
        }
        BAlarmSchema result = new BAlarmSchema();
        result.names = names;
        result.types = types;
        result.frozen = true;
        return result;
    }

    public String encodeToString() throws IOException {
        StringBuffer s = new StringBuffer(64);
        this.freeze();
        int colCount = this.names.length;
        for (int i = 0; i < colCount; ++i) {
            if (i != 0) {
                s.append(';');
            }
            s.append(this.names[i]);
            s.append(',');
            s.append(this.types[i].encodeToString());
        }
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        Unfrozen incoming = new Unfrozen();
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int index = pair.indexOf(44);
            String name = pair.substring(0, index);
            String typeString = pair.substring(index + 1);
            incoming.add(name, (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(typeString));
        }
        BAlarmSchema result = new BAlarmSchema();
        result.names = incoming.getNames();
        result.types = incoming.getTypes();
        result.frozen = true;
        return result;
    }

    public synchronized void addColumn(String name, BTypeSpec type) throws IllegalStateException {
        if (this.frozen) {
            throw new IllegalStateException("This scheme has already been frozen.");
        }
        if (this.pending == null) {
            this.pending = new Unfrozen();
        }
        this.pending.add(name, type);
    }

    private synchronized void freeze() {
        if (this.frozen) {
            return;
        }
        if (this.pending == null) {
            this.names = new String[0];
            this.types = new BTypeSpec[0];
        } else {
            this.names = this.pending.getNames();
            this.types = this.pending.getTypes();
        }
        this.frozen = true;
        this.pending = null;
    }

    public Type getType() {
        return TYPE;
    }

    static {
        BAlarmSchema.DEFAULT.names = new String[0];
        BAlarmSchema.DEFAULT.types = new BTypeSpec[0];
        BAlarmSchema.DEFAULT.frozen = true;
        TYPE = Sys.loadType(BAlarmSchema.class);
    }

    private static class Unfrozen {
        private ArrayList<String> nameList = new ArrayList(4);
        private ArrayList<BTypeSpec> typeList = new ArrayList(4);

        public void add(String name, BTypeSpec type) {
            this.nameList.add(name);
            this.typeList.add(type);
        }

        public String[] getNames() {
            return this.nameList.toArray(new String[this.nameList.size()]);
        }

        public BTypeSpec[] getTypes() {
            return this.typeList.toArray(new BTypeSpec[this.typeList.size()]);
        }
    }
}

