/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.alarm.BSourceState;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BAlarmPriorities
extends BSimple {
    private int toNormal;
    private int toOffnormal;
    private int toFault;
    private int toAlert;
    public static final BAlarmPriorities DEFAULT = new BAlarmPriorities();
    public static final int MAX_PRIORITY = 255;
    public static final int MIN_PRIORITY = 0;
    public static final Type TYPE = Sys.loadType(BAlarmPriorities.class);

    private BAlarmPriorities(int toOffnormal, int toFault, int toNormal, int toAlert) {
        this.toOffnormal = this.checkPriority(toOffnormal);
        this.toFault = this.checkPriority(toFault);
        this.toNormal = this.checkPriority(toNormal);
        this.toAlert = this.checkPriority(toAlert);
    }

    private BAlarmPriorities() {
        this(255, 255, 255, 255);
    }

    public static BAlarmPriorities make(int toOffnormal, int toFault, int toNormal) {
        return new BAlarmPriorities(toOffnormal, toFault, toNormal, 255);
    }

    public static BAlarmPriorities make(int toOffnormal, int toFault, int toNormal, int toAlert) {
        return new BAlarmPriorities(toOffnormal, toFault, toNormal, toAlert);
    }

    public int getPriority(BSourceState state) {
        if (state == BSourceState.offnormal) {
            return this.toOffnormal;
        }
        if (state == BSourceState.fault) {
            return this.toFault;
        }
        if (state == BSourceState.normal) {
            return this.toNormal;
        }
        if (state == BSourceState.alert) {
            return this.toAlert;
        }
        throw new IllegalStateException();
    }

    public int getToOffnormal() {
        return this.toOffnormal;
    }

    public int getToNormal() {
        return this.toNormal;
    }

    public int getToFault() {
        return this.toFault;
    }

    public int getToAlert() {
        return this.toAlert;
    }

    private int checkPriority(int priority) {
        if (priority < 0 || priority > 255) {
            throw new IllegalStateException(priority + ": not in range 0-255");
        }
        return priority;
    }

    public int hashCode() {
        int hash = 23 + this.toOffnormal;
        hash = hash * 37 + this.toNormal;
        hash = hash * 37 + this.toFault;
        return hash * 37 + this.toAlert;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BAlarmPriorities)) {
            return false;
        }
        BAlarmPriorities ap = (BAlarmPriorities)((Object)obj);
        return this.toOffnormal == ap.getToOffnormal() && this.toNormal == ap.getToNormal() && this.toFault == ap.getToFault() && this.toAlert == ap.getToAlert();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.toOffnormal);
        out.writeInt(this.toFault);
        out.writeInt(this.toNormal);
        out.writeInt(this.toAlert);
    }

    public BObject decode(DataInput in) throws IOException {
        int offnormal = in.readInt();
        int fault = in.readInt();
        int normal = in.readInt();
        int alert = in.readInt();
        return BAlarmPriorities.make(offnormal, fault, normal, alert);
    }

    public String encodeToString() throws IOException {
        StringBuffer s = new StringBuffer();
        s.append("toOffnormal=");
        s.append(this.toOffnormal).append(';');
        s.append("toFault=");
        s.append(this.toFault).append(';');
        s.append("toNormal=");
        s.append(this.toNormal).append(';');
        s.append("toAlert=");
        s.append(this.toAlert).append(';');
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        BAlarmPriorities ap = DEFAULT;
        StringTokenizer st = new StringTokenizer(s, ";");
        int offnormal = 0;
        int fault = 0;
        int normal = 0;
        int alert = 0;
        while (st.hasMoreTokens()) {
            String s1 = st.nextToken();
            int eq = s1.indexOf("=");
            String name = s1.substring(0, eq);
            String value = s1.substring(eq + 1);
            if (name.equals("toOffnormal")) {
                offnormal = Integer.parseInt(value);
                continue;
            }
            if (name.equals("toNormal")) {
                normal = Integer.parseInt(value);
                continue;
            }
            if (name.equals("toFault")) {
                fault = Integer.parseInt(value);
                continue;
            }
            if (!name.equals("toAlert")) continue;
            alert = Integer.parseInt(value);
        }
        return BAlarmPriorities.make(offnormal, fault, normal, alert);
    }

    public Type getType() {
        return TYPE;
    }
}

