/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.IOException;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSchema;
import javax.baja.alarm.BAlarmService;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="recordType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"alarm\", \"AlarmRecord\")", flags=5), @NiagaraProperty(name="schema", type="BAlarmSchema", defaultValue="BAlarmSchema.DEFAULT", flags=5)})
public class BAlarmDbConfig
extends BComponent {
    public static final Property recordType = BAlarmDbConfig.newProperty((int)5, (BValue)BTypeSpec.make((String)"alarm", (String)"AlarmRecord"), null);
    public static final Property schema = BAlarmDbConfig.newProperty((int)5, (BValue)BAlarmSchema.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAlarmDbConfig.class);
    private int recordSize = -1;
    private BAlarmRecord prototype;

    public BTypeSpec getRecordType() {
        return (BTypeSpec)this.get(recordType);
    }

    public void setRecordType(BTypeSpec v) {
        this.set(recordType, (BValue)v, null);
    }

    public BAlarmSchema getSchema() {
        return (BAlarmSchema)this.get(schema);
    }

    public void setSchema(BAlarmSchema v) {
        this.set(schema, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isNavChild() {
        return false;
    }

    public Type getColumnType(String name) {
        try {
            BAlarmRecord rec = this.makeRecord();
            Property prop = rec.getProperty(name);
            if (prop == null) {
                return null;
            }
            return prop.getDefaultValue().getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public BAlarmRecord makeRecord() throws AlarmException {
        BTypeSpec recordType = this.getRecordType();
        return BAlarmDbConfig.makeRecord(recordType);
    }

    private static BAlarmRecord makeRecord(BTypeSpec typeSpec) {
        Type recordType = typeSpec.getResolvedType();
        return (BAlarmRecord)recordType.getInstance();
    }

    public BObject makePrototype() {
        try {
            return this.makeRecord();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public int getRecordSize() throws IOException, AlarmException {
        if (this.recordSize == -1) {
            try {
                BAlarmRecord rec = this.makeRecord();
                if (!rec.isFixedSize()) {
                    throw new UnsupportedOperationException("A fixed record size cannot be determined for an alarm database with variable length records.");
                }
                this.recordSize = rec.getRecordSize();
            }
            catch (ModuleException e) {
                throw new AlarmException(e.getMessage(), e);
            }
            catch (TypeException e) {
                throw new AlarmException(e.getMessage(), e);
            }
        }
        return this.recordSize;
    }

    public void changed(Property p, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (p == recordType && this.getSchema().equals((Object)BAlarmSchema.DEFAULT)) {
            this.setSchema(this.makeRecord().getSchema());
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BAlarmService) {
            ((BAlarmService)parent).alarmDbConfigChanged(p);
        }
    }

    public void added(Property p, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BAlarmService) {
            ((BAlarmService)parent).alarmDbConfigChanged(p);
        }
    }

    public void removed(Property p, BValue value, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BAlarmService) {
            ((BAlarmService)parent).alarmDbConfigChanged(p);
        }
    }

    public void renamed(Property p, String oldName, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BAlarmService) {
            ((BAlarmService)parent).alarmDbConfigChanged(p);
        }
    }

    public void flagsChanged(Slot slot, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (!slot.isProperty()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BAlarmService) {
            ((BAlarmService)parent).alarmDbConfigChanged(slot.asProperty());
        }
    }

    public void facetsChanged(Slot slot, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (!slot.isProperty()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BAlarmService) {
            ((BAlarmService)parent).alarmDbConfigChanged(slot.asProperty());
        }
    }
}

