/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.AlarmClassRouteAlarmInvocation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmPriorities;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;

public class BAlarmClass
extends BComponent {
    public static final Property ackRequired = BAlarmClass.newProperty((int)0, (BValue)BAlarmTransitionBits.make(7), null);
    public static final Property priority = BAlarmClass.newProperty((int)0, (BValue)BAlarmPriorities.DEFAULT, null);
    public static final Property totalAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property openAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property inAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property unackedAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    public static final Property timeOfLastAlarm = BAlarmClass.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    public static final Property escalationLevel1Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    public static final Property escalationLevel1Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)60000L)));
    public static final Property escalationLevel2Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    public static final Property escalationLevel2Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)900000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)120000L)));
    public static final Property escalationLevel3Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    public static final Property escalationLevel3Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)1800000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)180000L)));
    public static final Action routeAlarm = BAlarmClass.newAction((int)20, (BValue)new BAlarmRecord(), null);
    public static final Topic alarm = BAlarmClass.newTopic((int)8, null);
    public static final Topic escalatedAlarm1 = BAlarmClass.newTopic((int)0, null);
    public static final Topic escalatedAlarm2 = BAlarmClass.newTopic((int)0, null);
    public static final Topic escalatedAlarm3 = BAlarmClass.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BAlarmClass.class);
    public static final Logger log = Logger.getLogger("alarm");
    BAlarmService alarmService;
    private static final BIcon icon = BIcon.std((String)"alarm/alarmClass.png");
    public static final String ESCALATED = "escalated";
    public static final String LEVEL_1 = "level1";
    public static final String LEVEL_2 = "level2";
    public static final String LEVEL_3 = "level3";

    public BAlarmTransitionBits getAckRequired() {
        return (BAlarmTransitionBits)this.get(ackRequired);
    }

    public void setAckRequired(BAlarmTransitionBits v) {
        this.set(ackRequired, (BValue)v, null);
    }

    public BAlarmPriorities getPriority() {
        return (BAlarmPriorities)this.get(priority);
    }

    public void setPriority(BAlarmPriorities v) {
        this.set(priority, (BValue)v, null);
    }

    public int getTotalAlarmCount() {
        return this.getInt(totalAlarmCount);
    }

    public void setTotalAlarmCount(int v) {
        this.setInt(totalAlarmCount, v, null);
    }

    public int getOpenAlarmCount() {
        return this.getInt(openAlarmCount);
    }

    public void setOpenAlarmCount(int v) {
        this.setInt(openAlarmCount, v, null);
    }

    public int getInAlarmCount() {
        return this.getInt(inAlarmCount);
    }

    public void setInAlarmCount(int v) {
        this.setInt(inAlarmCount, v, null);
    }

    public int getUnackedAlarmCount() {
        return this.getInt(unackedAlarmCount);
    }

    public void setUnackedAlarmCount(int v) {
        this.setInt(unackedAlarmCount, v, null);
    }

    public BAbsTime getTimeOfLastAlarm() {
        return (BAbsTime)this.get(timeOfLastAlarm);
    }

    public void setTimeOfLastAlarm(BAbsTime v) {
        this.set(timeOfLastAlarm, (BValue)v, null);
    }

    public boolean getEscalationLevel1Enabled() {
        return this.getBoolean(escalationLevel1Enabled);
    }

    public void setEscalationLevel1Enabled(boolean v) {
        this.setBoolean(escalationLevel1Enabled, v, null);
    }

    public BRelTime getEscalationLevel1Delay() {
        return (BRelTime)this.get(escalationLevel1Delay);
    }

    public void setEscalationLevel1Delay(BRelTime v) {
        this.set(escalationLevel1Delay, (BValue)v, null);
    }

    public boolean getEscalationLevel2Enabled() {
        return this.getBoolean(escalationLevel2Enabled);
    }

    public void setEscalationLevel2Enabled(boolean v) {
        this.setBoolean(escalationLevel2Enabled, v, null);
    }

    public BRelTime getEscalationLevel2Delay() {
        return (BRelTime)this.get(escalationLevel2Delay);
    }

    public void setEscalationLevel2Delay(BRelTime v) {
        this.set(escalationLevel2Delay, (BValue)v, null);
    }

    public boolean getEscalationLevel3Enabled() {
        return this.getBoolean(escalationLevel3Enabled);
    }

    public void setEscalationLevel3Enabled(boolean v) {
        this.setBoolean(escalationLevel3Enabled, v, null);
    }

    public BRelTime getEscalationLevel3Delay() {
        return (BRelTime)this.get(escalationLevel3Delay);
    }

    public void setEscalationLevel3Delay(BRelTime v) {
        this.set(escalationLevel3Delay, (BValue)v, null);
    }

    public void routeAlarm(BAlarmRecord alarm) {
        this.invoke(routeAlarm, (BValue)alarm, null);
    }

    public void fireAlarm(BAlarmRecord event) {
        this.fire(alarm, (BValue)event, null);
    }

    public void fireEscalatedAlarm1(BAlarmRecord event) {
        this.fire(escalatedAlarm1, (BValue)event, null);
    }

    public void fireEscalatedAlarm2(BAlarmRecord event) {
        this.fire(escalatedAlarm2, (BValue)event, null);
    }

    public void fireEscalatedAlarm3(BAlarmRecord event) {
        this.fire(escalatedAlarm3, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == totalAlarmCount || p == openAlarmCount || p == unackedAlarmCount || p == inAlarmCount) {
            if (this.getInt(p) < 0) {
                this.setInt(p, 0, null);
            }
        } else if (p == escalationLevel1Enabled) {
            if (this.getEscalationLevel1Enabled()) {
                int flags = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm1, flags |= 8);
            } else {
                int flags = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm1, flags &= 0xFFFFFFF7);
            }
        } else if (p == escalationLevel2Enabled) {
            if (this.getEscalationLevel2Enabled()) {
                int flags = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm2, flags |= 8);
            } else {
                int flags = this.getFlags((Slot)escalatedAlarm2);
                this.setFlags((Slot)escalatedAlarm2, flags &= 0xFFFFFFF7);
            }
        } else if (p == escalationLevel3Enabled) {
            if (this.getEscalationLevel3Enabled()) {
                int flags = this.getFlags((Slot)escalatedAlarm3);
                this.setFlags((Slot)escalatedAlarm3, flags |= 8);
            } else {
                int flags = this.getFlags((Slot)escalatedAlarm3);
                this.setFlags((Slot)escalatedAlarm3, flags &= 0xFFFFFFF7);
            }
        }
    }

    public void started() {
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == routeAlarm) {
            Queue q = (Queue)Sys.getService((Type)BAlarmService.TYPE).fw(601);
            AlarmClassRouteAlarmInvocation invc = AlarmClassRouteAlarmInvocation.make(this, action, (BAlarmRecord)argument, cx);
            q.enqueue((Object)invc);
            if (action == routeAlarm) {
                return invc;
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIAlarmClassFolder;
    }

    public void doRouteAlarm(BAlarmRecord alarm) {
        try {
            if (!this.isRunning()) {
                return;
            }
            BSourceState newState = alarm.getSourceState();
            alarm.setPriority(this.getPriority().getPriority(newState));
            alarm.setAlarmClass(this.getName());
            if (alarm.getAlarmData().get("TimeZone") == null) {
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
            }
            boolean ackReq = this.getAckRequired().includes(newState);
            if (alarm.getSourceState() == BSourceState.alert && alarm.getAckState() == BAckState.acked) {
                alarm.setSourceState(BSourceState.normal);
                alarm.setAlarmTransition(BSourceState.alert);
            }
            if (alarm.getAlarmData().get(ESCALATED) == null) {
                alarm.addAlarmFacet(ESCALATED, (BIDataValue)BString.make((String)""));
            }
            alarm.setLastUpdate(BAbsTime.now());
            BAlarmService as = this.getAlarmService();
            try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                if (conn.getRecord(alarm.getUuid()) == null) {
                    conn.append(alarm);
                } else {
                    conn.update(alarm);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot write alarm.", e);
                throw new AlarmException("Cannot write alarm", e);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("BAlarmClass: " + this.getName() + " stored alarm.timestamp: " + alarm.getTimestamp());
            }
            if (alarm.isAlarm()) {
                this.setTimeOfLastAlarm(alarm.getTimestamp());
            }
            this.fireAlarm(alarm);
            BString escalatedLevel = (BString)alarm.getAlarmData().get(ESCALATED);
            if (escalatedLevel != null) {
                if (this.getEscalationLevel1Enabled() && (escalatedLevel.equals((Object)BString.make((String)LEVEL_1)) || escalatedLevel.equals((Object)BString.make((String)LEVEL_2)) || escalatedLevel.equals((Object)BString.make((String)LEVEL_3)))) {
                    this.fireEscalatedAlarm1(alarm);
                }
                if (this.getEscalationLevel2Enabled() && (escalatedLevel.equals((Object)BString.make((String)LEVEL_2)) || escalatedLevel.equals((Object)BString.make((String)LEVEL_3)))) {
                    this.fireEscalatedAlarm2(alarm);
                }
                if (this.getEscalationLevel3Enabled() && escalatedLevel.equals((Object)BString.make((String)LEVEL_3))) {
                    this.fireEscalatedAlarm3(alarm);
                }
            }
        }
        catch (ServiceNotFoundException e) {
            log.log(Level.SEVERE, "Alarm service not found", e);
        }
    }

    public String toString(Context cx) {
        return this.getDisplayName(cx);
    }

    protected BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    public BIcon getIcon() {
        return icon;
    }
}

