/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.alarm.fox.BFoxAlarmDatabase;
import com.tridium.fox.sys.BFoxChannelRegistry;
import java.io.IOException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSource;
import javax.baja.bql.BqlQuery;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BUuid;

public class FoxAlarmDbConnection
extends AlarmDbConnection {
    private BFoxAlarmDatabase db;
    private Context cx;
    private BAlarmDbChannel channel = null;

    FoxAlarmDbConnection(BFoxAlarmDatabase db, Context cx) {
        this.db = db;
        this.cx = cx;
    }

    @Override
    public BAlarmDatabase getAlarmDatabase() {
        return this.db;
    }

    public BAlarmDbChannel getChannel() {
        if (this.channel == null) {
            try {
                this.channel = (BAlarmDbChannel)this.db.getFoxSession().getConnection().getChannels().get("alarmdb", BAlarmDbChannel.TYPE);
            }
            catch (Exception e) {
                BFoxChannelRegistry.getPrototype().add("alarmdb", (BValue)new BAlarmDbChannel());
                this.channel = (BAlarmDbChannel)this.db.getFoxSession().getConnection().getChannels().get("alarmdb", BAlarmDbChannel.TYPE);
            }
        }
        return this.channel;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void append(BAlarmRecord rec) throws AlarmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(BAlarmRecord rec) throws IOException, AlarmException {
        try {
            this.getChannel().update(rec);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public synchronized int getRecordCount() {
        try {
            return this.getChannel().getRecordCount();
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public synchronized BAlarmRecord getRecord(BUuid uuid) throws IOException {
        try {
            return this.getChannel().getRecord(uuid);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public synchronized Cursor<BAlarmSource> getOpenAlarmSources() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Cursor<BAlarmRecord> getOpenAlarms() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<BAlarmRecord> getAckPendingAlarms() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<BAlarmRecord> getAlarmsForSource(BOrdList alarmSource) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<BAlarmRecord> getOpenAlarmsForSource(BOrdList alarmSource) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<BAlarmRecord> scan() throws IOException, AlarmException {
        try {
            return this.getChannel().scan();
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public Cursor<BAlarmRecord> timeQuery(BAbsTime start, BAbsTime end) throws IOException, AlarmException {
        try {
            return this.getChannel().timeQuery(start, end);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public Cursor<BAlarmRecord> doBqlQuery(BqlQuery query) throws IOException, AlarmException {
        try {
            return this.getChannel().bqlQuery(query);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public void clearAllRecords(Context cx) throws IOException {
        try {
            this.getChannel().clearAllRecords();
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public void clearOldRecords(BAbsTime before, Context cx) throws IOException {
        try {
            this.getChannel().clearOldRecords(before);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public void clearRecord(BUuid uuid, Context cx) throws IOException {
        try {
            this.getChannel().clearRecord(uuid);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }
}

