/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BSourceState;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.util.BUuid;

public class FoxAlarmCodec {
    public static FoxMessage encodeAlarm(BAlarmRecord alarm) throws Exception {
        FoxMessage msg = new FoxMessage();
        msg.add("timestamp", alarm.getTimestamp().getMillis());
        msg.add("uuid", alarm.getUuid().encodeToString());
        msg.add("sourceState", alarm.getSourceState().encodeToString());
        msg.add("ackState", alarm.getAckState().encodeToString());
        msg.add("ackRequired", alarm.getAckRequired());
        msg.add("source", alarm.getSource().encodeToString());
        msg.add("alarmClass", alarm.getAlarmClass());
        msg.add("priority", alarm.getPriority());
        msg.add("normalTime", alarm.getNormalTime().getMillis());
        msg.add("ackTime", alarm.getAckTime().getMillis());
        msg.add("user", alarm.getUser());
        msg.add("alarmData", alarm.getAlarmData().encodeToString());
        msg.add("alarmTransition", alarm.getAlarmTransition().encodeToString());
        msg.add("lastUpdate", alarm.getLastUpdate().getMillis());
        return msg;
    }

    public static BAlarmRecord decodeAlarm(FoxMessage msg) throws Exception {
        BAlarmRecord alarm = new BAlarmRecord(BUuid.DEFAULT);
        try {
            alarm.setTimestamp(BAbsTime.make((long)msg.getTime("timestamp")));
            alarm.setUuid((BUuid)BUuid.DEFAULT.decodeFromString(msg.getString("uuid")));
            alarm.setSourceState((BSourceState)BSourceState.normal.decodeFromString(msg.getString("sourceState").intern()));
            alarm.setAckState((BAckState)BAckState.acked.decodeFromString(msg.getString("ackState").intern()));
            alarm.setAckRequired(msg.getBoolean("ackRequired"));
            alarm.setSource((BOrdList)BOrdList.DEFAULT.decodeFromString(msg.getString("source")));
            alarm.setAlarmClass(msg.getString("alarmClass"));
            alarm.setPriority(msg.getInt("priority"));
            alarm.setNormalTime(BAbsTime.make((long)msg.getTime("normalTime")));
            alarm.setAckTime(BAbsTime.make((long)msg.getTime("ackTime")));
            alarm.setUser(msg.getString("user"));
            alarm.setAlarmData((BFacets)BFacets.DEFAULT.decodeFromString(msg.getString("alarmData")));
            alarm.setAlarmTransition((BSourceState)BSourceState.normal.decodeFromString(msg.getString("alarmTransition").intern()));
            alarm.setLastUpdate(BAbsTime.make((long)msg.getTime("lastUpdate")));
        }
        catch (Exception e) {
            alarm.setTimestamp(BAbsTime.make((long)msg.getTime("timestamp")));
            alarm.setUuid((BUuid)DecoderFactory.decode((FoxMessage)msg, (String)"uuid", null));
            alarm.setSourceState((BSourceState)((Object)DecoderFactory.decode((FoxMessage)msg, (String)"sourceState", null)));
            alarm.setAckState((BAckState)((Object)DecoderFactory.decode((FoxMessage)msg, (String)"ackState", null)));
            alarm.setAckRequired(msg.getBoolean("ackRequired"));
            alarm.setSource((BOrdList)DecoderFactory.decode((FoxMessage)msg, (String)"source", null));
            alarm.setAlarmClass(msg.getString("alarmClass"));
            alarm.setPriority(msg.getInt("priority"));
            alarm.setNormalTime(BAbsTime.make((long)msg.getTime("normalTime")));
            alarm.setAckTime(BAbsTime.make((long)msg.getTime("ackTime")));
            alarm.setUser(msg.getString("user"));
            alarm.setAlarmData((BFacets)DecoderFactory.decode((FoxMessage)msg, (String)"alarmData", null));
            alarm.setAlarmTransition((BSourceState)((Object)DecoderFactory.decode((FoxMessage)msg, (String)"alarmTransition", null)));
            alarm.setLastUpdate(BAbsTime.make((long)msg.getTime("lastUpdate")));
        }
        return alarm;
    }
}

