/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.db.AlarmQuery;
import com.tridium.alarm.db.BIAlarmResolver;
import com.tridium.alarm.fox.BFoxAlarmDatabase;
import com.tridium.fox.sys.BFoxSession;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.naming.BISession;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BFoxAlarmResolver
extends BSingleton
implements BIAlarmResolver,
BIAgent {
    public static final BFoxAlarmResolver INSTANCE = new BFoxAlarmResolver();
    public static final Type TYPE = Sys.loadType(BFoxAlarmResolver.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OrdTarget resolve(BISession session, OrdTarget base, AlarmQuery query) {
        BFoxSession foxSession = (BFoxSession)session;
        if (query.isDbQuery()) {
            return new OrdTarget(base, (BObject)new BFoxAlarmDatabase(foxSession));
        }
        String uuid = query.getQueryParameter("uuid", null);
        if (uuid == null) throw new UnresolvedException("Invalid alarm query: " + query);
        BFoxAlarmDatabase foxAlarmDb = new BFoxAlarmDatabase(foxSession);
        try (AlarmDbConnection conn = foxAlarmDb.getDbConnection(null);){
            BAlarmRecord rec = conn.getRecord(BUuid.make((String)uuid));
            if (rec == null) {
                throw new UnresolvedException(uuid);
            }
            OrdTarget ordTarget = new OrdTarget(base, (BObject)rec);
            return ordTarget;
        }
        catch (IOException ioe) {
            throw new UnresolvedException("Error retreiving alarm record.", (Throwable)ioe);
        }
    }

    public Type getType() {
        return TYPE;
    }
}

