/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.alarm.fox.FoxAlarmDbConnection;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.bql.Queryable;
import javax.baja.bql.RemoteQueryable;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFoxAlarmDatabase
extends BAlarmDatabase
implements BIFoxProxySpace,
Queryable,
RemoteQueryable {
    BOrd ord;
    public static final Type TYPE = Sys.loadType(BFoxAlarmDatabase.class);
    private BFoxSession session;
    private BPermissions permissions = null;

    public BFoxAlarmDatabase() {
    }

    public BFoxAlarmDatabase(BFoxSession session) {
        this.session = session;
    }

    @Override
    public AlarmDbConnection getDbConnection(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasOperatorRead()) {
            throw new AlarmException("user needs alarm space permissions");
        }
        return new FoxAlarmDbConnection(this, cx);
    }

    @Override
    public void updateConfig(BAlarmDbConfig config, Property p) {
    }

    public BAlarmDbChannel getChannel() {
        BAlarmDbChannel channel = null;
        try {
            channel = (BAlarmDbChannel)this.getSession().getConnection().getChannels().get("alarmdb", BAlarmDbChannel.TYPE);
        }
        catch (Exception e) {
            BFoxChannelRegistry.getPrototype().add("alarmdb", (BValue)new BAlarmDbChannel());
            channel = (BAlarmDbChannel)this.getSession().getConnection().getChannels().get("alarmdb", BAlarmDbChannel.TYPE);
        }
        return channel;
    }

    public BFoxSession getSession() {
        return this.getFoxSession();
    }

    public BFoxSession getFoxSession() {
        if (this.session == null) {
            this.session = (BFoxSession)this.getNavParent();
        }
        return this.session;
    }

    public BOrd getNavOrd() {
        if (this.ord == null && this.getFoxSession() != null) {
            this.ord = BOrd.make((String)(this.getFoxSession().getNavOrd() + "|alarm:"));
        }
        return this.ord;
    }

    public void init(BFoxSession foxSession) throws Exception {
        this.session = foxSession;
        this.permissions = this.getChannel().getPermissions();
    }

    public void cleanup(BFoxSession foxSession) throws Exception {
    }

    public BObject bqlQuery(BOrd ord) {
        try {
            return this.getChannel().resolve(ord);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (this.permissions == null) {
            try {
                this.permissions = this.getChannel().getPermissions();
            }
            catch (Exception e) {
                this.permissions = BPermissions.all;
                e.printStackTrace();
            }
        }
        return this.permissions;
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    @Override
    public BCategoryMask getCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

