/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.fox.sys.NiagaraStation;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIRemoteAlarmRecipient;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BStationRecipient
extends BAlarmRecipient {
    public static final Property transitions = BStationRecipient.newProperty((int)0, (BValue)BAlarmTransitionBits.ALL, (BFacets)BFacets.make((String[])new String[]{"showNormal"}, (BIDataValue[])new BBoolean[]{BBoolean.FALSE}));
    public static final Property routeAcks = BStationRecipient.newProperty((int)1, (boolean)true, null);
    public static final Property remoteStation = BStationRecipient.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:RemoteStationFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:RemoteStationEditor")));
    public static final Type TYPE = Sys.loadType(BStationRecipient.class);
    public static final Lexicon lex = Lexicon.make((String)"baja");
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final Logger log = Logger.getLogger("alarm");

    @Override
    public BAlarmTransitionBits getTransitions() {
        return (BAlarmTransitionBits)this.get(transitions);
    }

    @Override
    public void setTransitions(BAlarmTransitionBits v) {
        this.set(transitions, (BValue)v, null);
    }

    @Override
    public boolean getRouteAcks() {
        return this.getBoolean(routeAcks);
    }

    @Override
    public void setRouteAcks(boolean v) {
        this.setBoolean(routeAcks, v, null);
    }

    public String getRemoteStation() {
        return this.getString(remoteStation);
    }

    public void setRemoteStation(String v) {
        this.setString(remoteStation, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void handleAlarm(BAlarmRecord alarm) {
        try {
            BIRemoteAlarmRecipient ext = this.getAlarmDeviceExt();
            if (ext == null) {
                return;
            }
            ext.routeAlarm(alarm);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private NiagaraStation getStation() throws Exception {
        Type type = Sys.getType((String)"niagaraDriver:NiagaraNetwork");
        NiagaraNetwork network = (NiagaraNetwork)Sys.getService((Type)type);
        BComponent station = (BComponent)network.getStation(this.getRemoteStation());
        if (station == null) {
            log.severe("" + this.getName() + ": Station '" + this.getRemoteStation() + "' not Configured in the Database");
            throw new Exception("Station '" + this.getRemoteStation() + "' not Configured in the Database");
        }
        return (NiagaraStation)station;
    }

    private BIRemoteAlarmRecipient getAlarmDeviceExt() throws Exception {
        BComponent station = (BComponent)this.getStation();
        if (!((BBoolean)station.get("enabled")).getBoolean()) {
            return null;
        }
        return (BIRemoteAlarmRecipient)station.get("alarms");
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

