/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import java.util.Comparator;
import java.util.HashMap;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSource;
import javax.baja.collection.AbstractCursor;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BObjectArrayCursor;

public class AlarmsToSourcesCursor
extends AbstractCursor<BAlarmSource> {
    private final Cursor<BAlarmRecord> alarms;
    private Cursor<BAlarmSource> sources;

    public AlarmsToSourcesCursor(Cursor<BAlarmRecord> alarms) {
        this.alarms = alarms;
    }

    protected BAlarmSource doGet() {
        return (BAlarmSource)((Object)this.sources.get());
    }

    public Context getContext() {
        return this.alarms.getContext();
    }

    protected boolean advanceCursor() {
        if (this.sources == null) {
            this.sources = this.load();
        }
        return this.sources.next();
    }

    protected void closeCursor() {
        this.alarms.close();
        if (this.sources != null) {
            this.sources.close();
        }
    }

    private Cursor<BAlarmSource> load() {
        HashMap<BOrdList, BAlarmSource> sourceMap = new HashMap<BOrdList, BAlarmSource>();
        while (this.alarms.next()) {
            BAlarmRecord rec = (BAlarmRecord)((Object)this.alarms.get());
            BOrdList sourceOrdList = rec.getSource();
            BAlarmSource source = (BAlarmSource)((Object)sourceMap.get(sourceOrdList));
            if (source == null) {
                source = new BAlarmSource(sourceOrdList, (BAlarmRecord)rec.newCopy(true));
                sourceMap.put(sourceOrdList, source);
                continue;
            }
            if (!rec.getTimestamp().isAfter(source.getCurrentAlarm().getTimestamp())) continue;
            source.setCurrentAlarm((BAlarmRecord)rec.newCopy(true));
        }
        BObject[] sources = sourceMap.values().toArray(new BAlarmSource[sourceMap.size()]);
        SortUtil.sort((Object[])sources, (Object[])sources, (Comparator)new BAlarmSource.SourceComparator());
        return new BObjectArrayCursor(sources, this.alarms.getContext());
    }
}

