/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import java.util.HashSet;
import java.util.Set;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.SlotPath;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.user.BUser;

public final class AlarmUtil {
    private BAlarmService service;

    public static AlarmUtil make(BAlarmService alarmService) {
        return new AlarmUtil(alarmService);
    }

    private AlarmUtil(BAlarmService alarmService) {
        this.service = alarmService;
    }

    public Set<String> getAllAlarmClassesFromAlarmService() {
        BAlarmClass[] allAlarmClasses = this.service.getAlarmClasses();
        HashSet<String> allAlarmClassNames = new HashSet<String>();
        for (BAlarmClass ac : allAlarmClasses) {
            allAlarmClassNames.add(ac.getName());
        }
        return allAlarmClassNames;
    }

    public String getInitialAlarmQuery(BAlarmRecipient recipient) {
        return this.getInitialAlarmQuery(recipient, null, false);
    }

    public String getInitialAlarmQuery(BAlarmRecipient recipient, BUser user, boolean includeSubscribedEscalatedAlarmClasses) {
        String defaultAlarmClassName = this.service.getDefaultAlarmClass().getName();
        String[] subscribedAlarmClasses = recipient.getSubscribedAlarmClasses();
        StringBuilder bqlQuery = new StringBuilder("alarm:|bql:select * from openAlarms");
        int count = 0;
        boolean isDefaultClassRecipient = false;
        StringBuilder whereClause = new StringBuilder();
        for (String ac : subscribedAlarmClasses) {
            try {
                if (user != null) {
                    user.check((BIProtected)this.service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (!isDefaultClassRecipient && ac.equals(defaultAlarmClassName)) {
                    isDefaultClassRecipient = true;
                }
                if (count > 0) {
                    whereClause.append(" or ");
                } else {
                    whereClause.append('(');
                }
                ++count;
                whereClause.append("alarmClass = '").append(SlotPath.escape((String)ac)).append('\'');
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        if (isDefaultClassRecipient) {
            BAlarmClass[] allAlarmClasses = this.service.getAlarmClasses();
            whereClause.append(" or ");
            whereClause.append('(');
            int acCount = 0;
            for (BAlarmClass ac : allAlarmClasses) {
                if (acCount > 0) {
                    whereClause.append(" and ");
                }
                whereClause.append("alarmClass != '").append(SlotPath.escape((String)ac.getName())).append('\'');
                ++acCount;
            }
            whereClause.append(')');
        }
        if (count > 0) {
            whereClause.append(')');
        }
        if (includeSubscribedEscalatedAlarmClasses) {
            String escalatedAlarmQuery = this.getSubscribedEscalatedAlarmClassesQuery(recipient, user, this.service, count);
            whereClause.append(escalatedAlarmQuery);
        }
        if (whereClause.length() > 0) {
            bqlQuery.append(" where (");
            bqlQuery.append(whereClause.toString()).append(')');
        } else {
            bqlQuery.append(" where alarmClass = 'null'");
        }
        return bqlQuery.toString();
    }

    private String getSubscribedEscalatedAlarmClassesQuery(BAlarmRecipient recipient, BUser user, BAlarmService service, int count) {
        String[] subscribedEscalatedAlarmClasses;
        StringBuilder whereClause = new StringBuilder();
        for (String ac : subscribedEscalatedAlarmClasses = recipient.getSubscribedEscalatedAlarmClasses(1)) {
            try {
                if (user != null) {
                    user.check((BIProtected)service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (count > 0) {
                    whereClause.append(" or ");
                }
                whereClause.append("(alarmClass = '").append(SlotPath.escape((String)ac)).append("' and (alarmData.").append("escalated").append(" != null and alarmData.").append("escalated").append(" = '").append("level3").append("' or alarmData.").append("escalated").append(" = '").append("level2").append("' or alarmData.").append("escalated").append(" = '").append("level1").append("'))");
                ++count;
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        for (String ac : subscribedEscalatedAlarmClasses = recipient.getSubscribedEscalatedAlarmClasses(2)) {
            try {
                if (user != null) {
                    user.check((BIProtected)service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (count > 0) {
                    whereClause.append(" or ");
                }
                whereClause.append("(alarmClass = '").append(SlotPath.escape((String)ac)).append("' and (alarmData.").append("escalated").append(" != null and alarmData.").append("escalated").append(" = '").append("level3").append("' or alarmData.").append("escalated").append(" = '").append("level2").append("'))");
                ++count;
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        for (String ac : subscribedEscalatedAlarmClasses = recipient.getSubscribedEscalatedAlarmClasses(3)) {
            try {
                if (user != null) {
                    user.check((BIProtected)service.lookupAlarmClass(ac), BPermissions.operatorRead);
                }
                if (count > 0) {
                    whereClause.append(" or ");
                }
                whereClause.append("(alarmClass = '").append(SlotPath.escape((String)ac)).append("' and alarmData.").append("escalated").append(" != null and alarmData.").append("escalated").append(" = '").append("level3").append("')");
                ++count;
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
        }
        return whereClause.toString();
    }
}

