/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.alarm.CoalesceUuidOnlyInvocation;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class AlarmClassRouteAlarmInvocation
extends Invocation
implements IFuture {
    protected Throwable throwable = null;
    protected boolean finished = false;

    public AlarmClassRouteAlarmInvocation(BAlarmClass instance, BAlarmRecord argument, Context context) {
        this(instance, BAlarmClass.routeAlarm, argument, context);
    }

    public AlarmClassRouteAlarmInvocation(BComponent instance, Action action, BAlarmRecord argument, Context context) {
        super(instance, action, (BValue)argument, context);
        if (argument != null) {
            this.hashCode ^= argument.getUuid().hashCode();
        }
        this.finished = false;
    }

    public static AlarmClassRouteAlarmInvocation make(BComponent instance, Action action, BAlarmRecord argument, Context context) {
        Optional service = Sys.findService((Type)BAlarmService.TYPE);
        if (service.isPresent()) {
            BAlarmService alarmService = (BAlarmService)service.get();
            if (alarmService.getCoalesceAlarms()) {
                return new AlarmClassRouteAlarmInvocation(instance, action, argument, context);
            }
            return new CoalesceUuidOnlyInvocation(instance, action, argument, context);
        }
        return new AlarmClassRouteAlarmInvocation(instance, action, argument, context);
    }

    public boolean equals(Object object) {
        if (object instanceof AlarmClassRouteAlarmInvocation) {
            AlarmClassRouteAlarmInvocation o = (AlarmClassRouteAlarmInvocation)((Object)object);
            if (this.argument != null) {
                return this.instance == o.instance && this.action == o.action && ((BAlarmRecord)this.argument).getUuid().equals((Object)((BAlarmRecord)o.argument).getUuid());
            }
            return this.instance == o.instance && this.action == o.action;
        }
        return false;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        this.finished = true;
        return c;
    }

    public void run() throws BajaRuntimeException {
        try {
            if (this.action != BAlarmClass.routeAlarm) {
                super.run();
                return;
            }
            ((BAlarmClass)this.instance).doRouteAlarm((BAlarmRecord)this.argument);
        }
        catch (Throwable e) {
            BAlarmService.logger.log(Level.SEVERE, "AlarmClass " + this.instance.getName() + " failed to route alarm", e);
            if (e instanceof BajaRuntimeException) {
                this.throwable = (Exception)e.getCause();
                throw (BajaRuntimeException)e;
            }
            this.throwable = e;
            throw new BajaRuntimeException(e);
        }
        finally {
            this.finished = true;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean success() throws Exception {
        if (!this.finished) {
            throw new Exception("Invocation not finished");
        }
        return this.throwable == null;
    }

    public Exception getException() {
        if (this.throwable == null) {
            return null;
        }
        if (!(this.throwable instanceof Exception)) {
            return new Exception(this.throwable);
        }
        return (Exception)this.throwable;
    }
}

