/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.sys.module.BModuleNavNode;
import com.tridium.ui.file.FileChooserModel;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;

public class BFileChooserListView
extends BTable {
    public static final Type TYPE = Sys.loadType(BFileChooserListView.class);
    protected FileChooserModel fileModel;
    protected ListModel model;
    protected boolean showDirs;
    protected boolean showFiles;

    public Type getType() {
        return TYPE;
    }

    public BFileChooserListView() {
        throw new UnsupportedOperationException();
    }

    public BFileChooserListView(FileChooserModel fileModel) {
        this.model = new ListModel();
        this.fileModel = fileModel;
        this.setShowDirectories(true);
        this.setShowFiles(true);
        this.populateChildren();
        this.setModel(this.model);
        this.setController(new Controller());
        this.setSelection(new Selection());
        this.setHeaderVisible(false);
        this.setHgridVisible(false);
        this.setVgridVisible(false);
    }

    public boolean getShowDirectories() {
        return this.showDirs;
    }

    public void setShowDirectories(boolean v) {
        this.showDirs = v;
    }

    public boolean getShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean v) {
        this.showFiles = v;
    }

    public void populateChildren() {
        BINavNode[] kids = this.fileModel.getChildren();
        this.model.kids = this.sort(this.filter(kids));
    }

    private BINavNode[] filter(BINavNode[] files) {
        if (!(this.fileModel.getSpace() instanceof BFileSpace)) {
            return files;
        }
        ArrayList<BINavNode> list = new ArrayList<BINavNode>();
        for (BINavNode file : files) {
            if ((!this.showDirs || !(file instanceof BIDirectory)) && (!this.showFiles || file instanceof BIDirectory)) continue;
            list.add(file);
        }
        BIFile[] result = new BIFile[list.size()];
        return (BINavNode[])list.toArray(result);
    }

    private BINavNode[] sort(BINavNode[] files) {
        if (!this.showDirs || !this.showFiles) {
            return files;
        }
        for (int i = 1; i < files.length; ++i) {
            if (!(files[i] instanceof BIDirectory)) continue;
            for (int j = i; j > 0 && !(files[j - 1] instanceof BIDirectory); --j) {
                BINavNode temp = files[j - 1];
                files[j - 1] = files[j];
                files[j] = temp;
            }
        }
        return files;
    }

    public void select(BIFile file) {
        for (int i = 0; i < this.model.kids.length; ++i) {
            if (!file.getNavName().equals(this.model.kids[i].getNavName())) continue;
            if (this.getSelection().isSelected(i)) break;
            this.getSelection().select(i);
            break;
        }
    }

    public void setListView() {
        this.model = new ListModel();
        this.setModel(this.model);
        this.setHeaderVisible(false);
        this.populateChildren();
    }

    public void setDetailsView() {
        this.model = new DetailsModel();
        this.setModel(this.model);
        this.setHeaderVisible(true);
        this.populateChildren();
    }

    public void setView(ListModel pModel, boolean pHeaderVisible) {
        this.model = pModel;
        this.setModel(this.model);
        this.setHeaderVisible(pHeaderVisible);
        this.populateChildren();
    }

    public static class DetailsModel
    extends ListModel {
        @Override
        public int getColumnCount() {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                return 3;
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                return 1;
            }
            return 1;
        }

        @Override
        public String getColumnName(int col) {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                switch (col) {
                    case 0: {
                        return UiLexicon.bajaui().getText("fileChooser.name");
                    }
                    case 1: {
                        return UiLexicon.bajaui().getText("fileChooser.size");
                    }
                    case 2: {
                        return UiLexicon.bajaui().getText("fileChooser.lastModified");
                    }
                }
                return "";
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                switch (col) {
                    case 0: {
                        return "Name";
                    }
                }
                return "";
            }
            return UiLexicon.bajaui().getText("fileChooser.name");
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.kids[row] instanceof BIFile) {
                return this.getFileDetail(row, col);
            }
            if (this.kids[row] instanceof BModuleNavNode) {
                return this.getModuleDetail(row, col);
            }
            return super.getValueAt(row, col);
        }

        private Object getFileDetail(int row, int col) {
            BIFile file = (BIFile)this.kids[row];
            switch (col) {
                case 0: {
                    return super.getValueAt(row, col);
                }
                case 1: {
                    if (file instanceof BIDirectory) {
                        return "";
                    }
                    long sz = file.getSize();
                    String size = sz < 1024L ? "1 KB" : String.valueOf(sz / 1024L) + " KB";
                    return size;
                }
                case 2: {
                    if (file instanceof BDirectory || file.getLastModified().getMillis() == 0L) {
                        return "";
                    }
                    return String.valueOf(file.getLastModified());
                }
            }
            return null;
        }

        private Object getModuleDetail(int row, int col) {
            switch (col) {
                case 0: {
                    return super.getValueAt(row, col);
                }
            }
            return null;
        }
    }

    public static class ListModel
    extends TableModel {
        protected BINavNode[] kids;

        public int getRowCount() {
            return this.kids.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int col) {
            return "";
        }

        public Object getValueAt(int row, int col) {
            return this.kids[row].getNavDisplayName(null);
        }

        public BImage getRowIcon(int row) {
            return BImage.make((BIcon)this.kids[row].getNavIcon());
        }

        public BINavNode get(int row) {
            return this.kids[row];
        }
    }

    public class Selection
    extends TableSelection {
        public void select(int row, boolean clear) {
            super.select(row, clear);
            if (clear) {
                BFileChooserListView.this.fileModel.deselectAll();
            }
            if (row < BFileChooserListView.this.model.getRowCount()) {
                this.handleSelect(row);
            }
        }

        public void select(int anchor, int lead, boolean clear) {
            int start;
            int end;
            super.select(anchor, lead, clear);
            if (clear) {
                BFileChooserListView.this.fileModel.deselectAll();
            }
            if ((end = lead) < (start = anchor)) {
                int temp = start;
                start = end;
                end = temp;
            }
            for (int r = start; r <= end; ++r) {
                this.handleSelect(r);
            }
        }

        public void select(int[] rows) {
            super.select(rows);
            for (int i = 0; i < rows.length; ++i) {
                this.handleSelect(i);
            }
        }

        public void deselect(int row) {
            super.deselect(row);
            BINavNode nav = BFileChooserListView.this.model.get(row);
            if (nav instanceof BIFile) {
                BFileChooserListView.this.fileModel.deselect((BIFile)nav);
            }
        }

        public void deselectAll() {
            super.deselectAll();
            BFileChooserListView.this.fileModel.deselectAll();
        }

        private void handleSelect(int row) {
            BINavNode nav = BFileChooserListView.this.model.get(row);
            if (nav instanceof BIFile) {
                BFileChooserListView.this.fileModel.select((BIFile)nav);
            }
        }
    }

    public class Controller
    extends TableController {
        public void handleEnter(BKeyEvent event) {
            int row = this.getTable().getSelection().getRow();
            if (row >= 0) {
                this.handleSelection(BFileChooserListView.this.model.kids[row]);
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.handleSelection(BFileChooserListView.this.model.kids[row]);
        }

        void handleSelection(BINavNode file) {
            if (file instanceof BIDirectory || file instanceof BNavContainer) {
                BFileChooserListView.this.fileModel.setDirectory(file);
            } else {
                BFileChooserListView.this.fileModel.chooseSelectedFiles();
            }
        }

        public void keyPressed(BKeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 38 && event.isAltDown()) {
                BFileChooserListView.this.fileModel.moveUpDirectory();
            }
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }
}

