/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.baja.agent.AgentFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.RectGeom;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.workbench.BWbEditor;

public class BEditorWindow
extends BFrame {
    public static final Type TYPE = Sys.loadType(BEditorWindow.class);

    public Type getType() {
        return TYPE;
    }

    public BEditorWindow() {
        throw new UnsupportedOperationException();
    }

    public BEditorWindow(BObject toView, Type editorType) {
        this.init((BWbEditor)editorType.getInstance(), toView);
    }

    public BEditorWindow(BObject toView) {
        BWbEditor editor = (BWbEditor)toView.getAgents().filter(AgentFilter.is((Type)BWbEditor.TYPE)).getDefault().getInstance();
        this.init(editor, toView);
    }

    private void init(BWbEditor editor, BObject toView) {
        editor.loadValue(toView);
        BButtonPane buttons = new BButtonPane();
        buttons.add(new CloseCommand(), true, true);
        BScrollPane scroll = new BScrollPane((BWidget)editor);
        BConstrainedPane boundedPane = new BConstrainedPane((BWidget)scroll);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.never);
        boundedPane.setMaxHeight(350.0);
        boundedPane.setMinWidth(350.0);
        this.setContent((BWidget)new BEdgePane(null, (BWidget)buttons, null, null, (BWidget)boundedPane));
        if (toView instanceof BINavNode) {
            this.setTitle(((BINavNode)toView).getNavDescription(null));
        }
        this.setIconImage(BImage.make((BIcon)toView.getIcon()));
        this.setBoundsCenteredOnScreen();
    }

    public void setBoundsCenteredOnScreen() {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBoundsCenteredOn(new RectGeom(0.0, 0.0, (double)sd.width, (double)sd.height));
    }

    public void setBoundsCenteredOn(RectGeom screenRect) {
        this.computePreferredSize();
        double w = this.getPreferredWidth() + 8.0;
        double h = this.getPreferredHeight() + 27.0;
        double x = screenRect.x + (screenRect.width - w) / 2.0;
        double y = screenRect.y + (screenRect.height - h) / 2.0;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        double sw = ss.width;
        double sh = ss.height;
        if (x + w > sw) {
            x = sw - w;
        }
        if (y + h > sh) {
            y = sh - h;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        this.setScreenBounds(x, y, w, h);
    }

    private class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BEditorWindow.this, TYPE.getModule(), "EditorWindow.command.close");
        }

        public CommandArtifact doInvoke() {
            BEditorWindow.this.close();
            return null;
        }
    }
}

