/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BDirectoryNodeEvent;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.PatternFilter;

public class BDirectoryTree
extends BTree {
    public static final Topic nodeChecked = BDirectoryTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BDirectoryTree.class);

    public void fireNodeChecked(BDirectoryNodeEvent event) {
        this.fire(nodeChecked, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDirectoryTree() {
        this(new DirectoryTreeModel(), new DirectoryTreeController());
    }

    public BDirectoryTree(TreeModel model) {
        this(model, new DirectoryTreeController());
    }

    public BDirectoryTree(TreeModel model, TreeController controller) {
        super(model, controller);
        this.setNodeRenderer(new DirectoryTreeNodeRenderer());
        this.setSelection(new TreeSelection());
    }

    public void setModel(TreeModel model) {
        super.setModel(model);
    }

    public DirectoryTreeModel getDirectoryTreeModel() {
        return (DirectoryTreeModel)this.getModel();
    }

    public void setController(TreeController controller) {
        super.setController(controller);
    }

    public DirectoryTreeController getDirectoryTreeController() {
        return (DirectoryTreeController)this.getController();
    }

    public DirectoryTreeNodeRenderer getDirectoryTreeNodeRenderer() {
        return (DirectoryTreeNodeRenderer)this.getNodeRenderer();
    }

    public static class DirectoryTreeNodeRenderer
    extends TreeNodeRenderer {
        public double getWidth(TreeNode node) {
            return super.getWidth(node) + 10.0 + 2.0;
        }

        public BBrush getForeground(TreeNode node) {
            DirectoryTreeNode dtn = (DirectoryTreeNode)node;
            return dtn.isCheckEnabled() ? Theme.checkBox().getControlForeground() : Theme.checkBox().getControlShadow();
        }

        public void paintNode(Graphics g, TreeNode node, double x, double y) {
            super.paintNode(g, node, x + 12.0, y);
            DirectoryTreeNode dtn = (DirectoryTreeNode)node;
            double cy = y + this.getHeight() / 2.0 - 5.0;
            double cw = 10.0;
            double ch = 10.0;
            g.setBrush(this.getForeground(node));
            g.strokeRect(x, cy, cw, ch);
            if (dtn.isChecked()) {
                g.strokeLine(x, cy, x + cw, cy + ch);
                g.strokeLine(x, cy + cw, x + cw, cy);
            }
        }
    }

    public static class DirectoryTreeNode
    extends TreeNode {
        private BDirectory dir;
        private boolean checked = true;
        private boolean checkEnabled = true;
        private ArrayList<TreeNode> childNodes;
        public static final BImage icon = BImage.make((String)"module://icons/x16/folder.png");
        public static final BImage disabledIcon = icon.getDisabledImage();

        public DirectoryTreeNode(DirectoryTreeModel model, BDirectory dir) {
            super((TreeModel)model);
            this.init(dir);
        }

        public DirectoryTreeNode(BDirectory dir, DirectoryTreeNode parent) {
            super((TreeNode)parent);
            this.init(dir);
        }

        private void init(BDirectory dir) {
            this.dir = dir;
            this.childNodes = new ArrayList();
            try {
                for (BIFile kid : dir.listFiles()) {
                    if (!kid.isDirectory()) continue;
                    this.childNodes.add(new DirectoryTreeNode((BDirectory)kid, this));
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.setExpanded(true);
        }

        public BIFile getFile() {
            return this.getDirectory();
        }

        public BDirectory getDirectory() {
            return this.dir;
        }

        public boolean inCheckBox(double x) {
            double checkBoxX = this.getX() + Theme.tree().getExpanderWidth() + 10.0;
            return x >= checkBoxX && x <= checkBoxX + 10.0;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.setChecked(value, BTreeCascadePolicy.never, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean value, BTreeCascadePolicy cascadeDescendants) {
            this.setChecked(value, cascadeDescendants, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean value, BTreeCascadePolicy cascadeDescendants, BTreeCascadePolicy cascadeAncestors, boolean observeEnabled) {
            BDirectoryNodeEvent event = new BDirectoryNodeEvent();
            this.setChecked(value, cascadeDescendants, cascadeAncestors, event, observeEnabled);
            ((DirectoryTreeModel)this.getModel()).fireNodeChecked(event);
        }

        private void setChecked(boolean value, BTreeCascadePolicy cascadeDescendants, BTreeCascadePolicy cascadeAncestors, BDirectoryNodeEvent event, boolean observeEnabled) {
            TreeNode parent;
            if (this.checked != value && (this.isCheckEnabled() || !observeEnabled)) {
                this.checked = value;
                event.addNode(this);
            }
            if (cascadeDescendants.cascade(value)) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ((DirectoryTreeNode)this.getChild(i)).setChecked(value, BTreeCascadePolicy.always, BTreeCascadePolicy.never, event, observeEnabled);
                }
            }
            if (cascadeAncestors.cascade(value) && (parent = this.getParent()) != null && parent instanceof DirectoryTreeNode) {
                ((DirectoryTreeNode)parent).setChecked(value, BTreeCascadePolicy.never, BTreeCascadePolicy.always, event, observeEnabled);
            }
        }

        public boolean isCheckEnabled() {
            return this.checkEnabled;
        }

        public void setCheckEnabled(boolean value) {
            this.setCheckEnabled(value, false);
        }

        public void setCheckEnabled(boolean value, boolean cascade) {
            this.checkEnabled = value;
            if (cascade) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ((DirectoryTreeNode)this.getChild(i)).setCheckEnabled(value, true);
                }
            }
        }

        public void toggleChecked() {
            this.toggleChecked(BTreeCascadePolicy.never, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy cascadeDescendants) {
            this.toggleChecked(cascadeDescendants, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy cascadeDescendants, BTreeCascadePolicy cascadeAncestors) {
            this.setChecked(!this.isChecked(), cascadeDescendants, cascadeAncestors, true);
        }

        public String getText() {
            return this.dir.getFileName();
        }

        public BImage getIcon() {
            return this.checkEnabled ? icon : disabledIcon;
        }

        public int getChildCount() {
            return this.childNodes.size();
        }

        public TreeNode getChild(int index) {
            return this.childNodes.get(index);
        }

        public TreeNode getChild(String dirName) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!((DirectoryTreeNode)this.getChild(i)).getDirectory().getFileName().equals(dirName)) continue;
                return this.getChild(i);
            }
            return null;
        }
    }

    public static class DirectoryTreeModel
    extends TreeModel {
        private DirectoryTreeNode root;

        public void setRootDirectory(BDirectory dir) {
            if (dir == null) {
                this.root = null;
            } else {
                this.root = new DirectoryTreeNode(this, dir);
                this.root.setCheckEnabled(false);
            }
            this.updateTree();
        }

        public void fireNodeChecked(BDirectoryNodeEvent event) {
            if (this.getTree() instanceof BDirectoryTree) {
                ((BDirectoryTree)this.getTree()).fireNodeChecked(event);
            }
        }

        public int getRootCount() {
            return this.root == null ? 0 : 1;
        }

        public Iterator<BDirectory> getCheckedDirectories() {
            return this.getCheckedDirectories(true);
        }

        public Iterator<BDirectory> getCheckedDirectories(boolean checkValue) {
            ArrayList<BDirectory> result = new ArrayList<BDirectory>();
            this.getCheckedDirectories(this.root, checkValue, result);
            return result.iterator();
        }

        private void getCheckedDirectories(DirectoryTreeNode node, boolean checkValue, Collection<BDirectory> list) {
            if (node.isChecked() == checkValue) {
                list.add(node.getDirectory());
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.getCheckedDirectories((DirectoryTreeNode)node.getChild(i), checkValue, list);
            }
        }

        public void setDirectoryStates(DirectoryTreeNode node, PatternFilter[] filter, boolean checkValue, boolean enableValue, boolean expandedValue) {
            if (node != null) {
                String name = node.getDirectory().getFileName();
                for (PatternFilter aFilter : filter) {
                    if (!aFilter.accept(name)) continue;
                    node.setChecked(checkValue);
                    node.setCheckEnabled(enableValue);
                    node.setExpanded(expandedValue);
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.setDirectoryStates((DirectoryTreeNode)node.getChild(i), filter, checkValue, enableValue, expandedValue);
                }
            }
        }

        public TreeNode getRoot(int index) {
            return this.root;
        }

        public TreeNode findNode(FilePath path) {
            FilePath rootPath = this.root.getDirectory().getFilePath();
            if (path.getAbsoluteMode() != rootPath.getAbsoluteMode() || path.depth() < rootPath.depth()) {
                return null;
            }
            for (int i = 0; i < rootPath.depth(); ++i) {
                if (rootPath.nameAt(i).equals(path.nameAt(i))) continue;
                return null;
            }
            DirectoryTreeNode node = this.root;
            for (int i = rootPath.depth(); i < path.depth(); ++i) {
                if ((node = (DirectoryTreeNode)node.getChild(path.nameAt(i))) != null) continue;
                return null;
            }
            return node;
        }
    }

    public static class DirectoryTreeController
    extends TreeController {
        private BTreeCascadePolicy cascadeAncestorPolicy = BTreeCascadePolicy.never;
        private BTreeCascadePolicy cascadeDescendantPolicy = BTreeCascadePolicy.always;

        public void mousePressed(BMouseEvent evt) {
            this.getTree().requestFocus();
            double x = evt.getX();
            double y = evt.getY();
            DirectoryTreeNode target = (DirectoryTreeNode)this.getTree().yToTreeNode(y);
            if (target != null) {
                if (target.inExpander(x, y)) {
                    this.getTree().toggleExpanded((TreeNode)target);
                } else if (target.inCheckBox(x)) {
                    if (target.isCheckEnabled()) {
                        target.toggleChecked(this.getCascadeDescendantPolicy(), this.getCascadeAncestorPolicy());
                        this.getTree().relayout();
                    }
                } else if (target.isSelection(x, y)) {
                    this.mouseSelection(target, evt);
                    if (!evt.isButton3Down() && evt.getClickCount() == 2) {
                        this.doSelectAction(target, evt.getX(), evt.getY());
                    }
                } else {
                    target = null;
                    this.mouseSelection(null, evt);
                }
            } else {
                this.mouseSelection(null, evt);
            }
            if (evt.isPopupTrigger()) {
                this.popup(evt, target);
            }
        }

        public BTreeCascadePolicy getCascadeAncestorPolicy() {
            return this.cascadeAncestorPolicy;
        }

        public void setCascadeAncestorPolicy(BTreeCascadePolicy value) {
            this.cascadeAncestorPolicy = value;
        }

        public BTreeCascadePolicy getCascadeDescendantPolicy() {
            return this.cascadeDescendantPolicy;
        }

        public void setCascadeDescendantPolicy(BTreeCascadePolicy value) {
            this.cascadeDescendantPolicy = value;
        }
    }
}

