/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BPane;

public class BCoordinatedGridPane
extends BPane {
    public static final Property columnCount = BCoordinatedGridPane.newProperty((int)0, (int)2, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property valign = BCoordinatedGridPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property halign = BCoordinatedGridPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property rowAlign = BCoordinatedGridPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property columnAlign = BCoordinatedGridPane.newProperty((int)0, (BValue)BHalign.left, null);
    public static final Property rowGap = BCoordinatedGridPane.newProperty((int)0, (int)3, null);
    public static final Property columnGap = BCoordinatedGridPane.newProperty((int)0, (int)3, null);
    public static final Property uniformRowHeight = BCoordinatedGridPane.newProperty((int)0, (boolean)false, null);
    public static final Property uniformColumnWidth = BCoordinatedGridPane.newProperty((int)0, (boolean)false, null);
    public static final Property stretchRow = BCoordinatedGridPane.newProperty((int)0, (int)-1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property stretchColumn = BCoordinatedGridPane.newProperty((int)0, (int)-1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property colorRows = BCoordinatedGridPane.newProperty((int)0, (boolean)false, null);
    public static final Property colorEvenRows = BCoordinatedGridPane.newProperty((int)0, (boolean)false, null);
    public static final Property bandBrush = BCoordinatedGridPane.newProperty((int)0, (BValue)BColor.make((int)190, (int)190, (int)190).toBrush(), null);
    public static final Type TYPE = Sys.loadType(BCoordinatedGridPane.class);
    private static final BIcon icon = BIcon.std((String)"widgets/gridPane.png");
    double xo;
    double yo;
    double[] rh = new double[0];
    double[] cw = new double[0];
    ColumnSupport colSupport = new ColumnSupport(this);

    public int getColumnCount() {
        return this.getInt(columnCount);
    }

    public void setColumnCount(int v) {
        this.setInt(columnCount, v, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    public BValign getRowAlign() {
        return (BValign)this.get(rowAlign);
    }

    public void setRowAlign(BValign v) {
        this.set(rowAlign, (BValue)v, null);
    }

    public BHalign getColumnAlign() {
        return (BHalign)this.get(columnAlign);
    }

    public void setColumnAlign(BHalign v) {
        this.set(columnAlign, (BValue)v, null);
    }

    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    public double getColumnGap() {
        return this.getDouble(columnGap);
    }

    public void setColumnGap(double v) {
        this.setDouble(columnGap, v, null);
    }

    public boolean getUniformRowHeight() {
        return this.getBoolean(uniformRowHeight);
    }

    public void setUniformRowHeight(boolean v) {
        this.setBoolean(uniformRowHeight, v, null);
    }

    public boolean getUniformColumnWidth() {
        return this.getBoolean(uniformColumnWidth);
    }

    public void setUniformColumnWidth(boolean v) {
        this.setBoolean(uniformColumnWidth, v, null);
    }

    public int getStretchRow() {
        return this.getInt(stretchRow);
    }

    public void setStretchRow(int v) {
        this.setInt(stretchRow, v, null);
    }

    public int getStretchColumn() {
        return this.getInt(stretchColumn);
    }

    public void setStretchColumn(int v) {
        this.setInt(stretchColumn, v, null);
    }

    public boolean getColorRows() {
        return this.getBoolean(colorRows);
    }

    public void setColorRows(boolean v) {
        this.setBoolean(colorRows, v, null);
    }

    public boolean getColorEvenRows() {
        return this.getBoolean(colorEvenRows);
    }

    public void setColorEvenRows(boolean v) {
        this.setBoolean(colorEvenRows, v, null);
    }

    public BBrush getBandBrush() {
        return (BBrush)this.get(bandBrush);
    }

    public void setBandBrush(BBrush v) {
        this.set(bandBrush, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCoordinatedGridPane(BCoordinatedGridPane master) {
        this.setMaster(master);
    }

    public BCoordinatedGridPane(int columnCount) {
        this.setColumnCount(columnCount);
    }

    public BCoordinatedGridPane() {
    }

    public BCoordinatedGridPane(int columnCount, BWidget[] childWidgets) {
        this.setColumnCount(columnCount);
        for (BWidget childWidget : childWidgets) {
            this.add(null, (BValue)childWidget);
        }
    }

    public BCoordinatedGridPane(BWidget[] childWidgets) {
        for (BWidget childWidget : childWidgets) {
            this.add(null, (BValue)childWidget);
        }
    }

    public void setMaster(BCoordinatedGridPane master) {
        this.setColumnCount(master.getColumnCount());
        this.setColumnGap(master.getColumnGap());
        this.setStretchColumn(master.getStretchColumn());
        this.setColumnSupport(master.getColumnSupport());
        this.setUniformColumnWidth(master.getUniformColumnWidth());
    }

    public ColumnSupport getColumnSupport() {
        return this.colSupport;
    }

    public void setColumnSupport(ColumnSupport value) {
        if (this.colSupport != value) {
            this.colSupport.removePane(this);
            this.colSupport = value;
            this.colSupport.addPane(this);
        }
    }

    public void computePreferredSize() {
        int r;
        BWidget[] kids = this.getChildWidgets();
        double hgap = this.colSupport.getColumnGap();
        double vgap = this.getRowGap();
        this.cw = this.colSupport.computeColumnWidths(this);
        if (this.cw == null) {
            return;
        }
        int columns = this.cw.length;
        int rows = kids.length / columns;
        if (kids.length % columns > 0) {
            ++rows;
        }
        this.rh = new double[rows];
        double maxh = 0.0;
        int i = 0;
        block0: for (r = 0; r < this.rh.length; ++r) {
            for (double aCw : this.cw) {
                BWidget kid;
                if (i >= kids.length) break block0;
                if (!(kid = kids[i++]).isVisible()) continue;
                kid.computePreferredSize();
                this.rh[r] = Math.max(this.rh[r], kid.getPreferredHeight());
                maxh = Math.max(this.rh[r], maxh);
            }
        }
        if (this.getUniformRowHeight()) {
            for (r = 0; r < this.rh.length; ++r) {
                this.rh[r] = maxh;
            }
        }
        double pw = 0.0;
        double ph = 0.0;
        for (i = 0; i < this.cw.length; ++i) {
            if (i > 0) {
                pw += hgap;
            }
            pw += this.cw[i];
        }
        for (i = 0; i < this.rh.length; ++i) {
            if (i > 0) {
                ph += vgap;
            }
            ph += this.rh[i];
        }
        this.setPreferredSize(pw, ph);
    }

    private double[] computeColumnWidths(double[] initialWidths) {
        BWidget[] kids = this.getChildWidgets();
        int columns = initialWidths.length;
        int rows = kids.length / columns;
        if (kids.length % columns > 0) {
            ++rows;
        }
        double[] result = new double[columns];
        System.arraycopy(initialWidths, 0, result, 0, columns);
        int i = 0;
        block0: for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < result.length; ++c) {
                BWidget kid;
                if (i >= kids.length) break block0;
                if (!(kid = kids[i++]).isVisible()) continue;
                kid.computePreferredSize();
                result[c] = Math.max(result[c], kid.getPreferredWidth());
            }
        }
        return result;
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        if (this.cw == null) {
            return;
        }
        double pw = this.getPreferredWidth();
        double ph = this.getPreferredHeight();
        double w = this.getWidth();
        double h = this.getHeight();
        double hgap = this.colSupport.getColumnGap();
        double vgap = this.getRowGap();
        int hlayout = this.getColumnAlign().getOrdinal();
        int vlayout = this.getRowAlign().getOrdinal();
        int stretchRow = this.getStretchRow();
        int stretchCol = this.colSupport.getStretchColumn();
        this.xo = 0.0;
        if (w > pw && stretchCol < 0) {
            int hpalign = this.getHalign().getOrdinal();
            if (hpalign == 1) {
                this.xo = (w - pw) / 2.0;
            }
            if (hpalign == 2) {
                this.xo = w - pw;
            }
        }
        this.yo = 0.0;
        if (h > ph && stretchRow < 0) {
            int vpalign = this.getValign().getOrdinal();
            if (vpalign == 1) {
                this.yo = (h - ph) / 2.0;
            }
            if (vpalign == 2) {
                this.yo = h - ph;
            }
        }
        if (stretchCol >= 0 && stretchCol < this.cw.length && w > pw) {
            int n = stretchCol;
            this.cw[n] = this.cw[n] + (w - pw);
        }
        if (stretchRow >= 0 && stretchRow < this.rh.length && h > ph) {
            int n = stretchRow;
            this.rh[n] = this.rh[n] + (h - ph);
        }
        int i = 0;
        double cx = 0.0;
        double ry = 0.0;
        block0: for (double aRh : this.rh) {
            cx = 0.0;
            for (double aCw : this.cw) {
                if (i >= kids.length) break block0;
                BWidget kid = kids[i++];
                double colw = aCw;
                double rowh = aRh;
                double kx = this.xo + cx;
                double ky = this.yo + ry;
                double kw = colw;
                double kh = rowh;
                if (hlayout != 3) {
                    kw = kid.getPreferredWidth();
                    if (hlayout == 1) {
                        kx = this.xo + cx + (colw - kw) / 2.0;
                    }
                    if (hlayout == 2) {
                        kx = this.xo + cx + colw - kw;
                    }
                }
                if (vlayout != 3) {
                    kh = kid.getPreferredHeight();
                    if (vlayout == 1) {
                        ky = this.yo + ry + (rowh - kh) / 2.0;
                    }
                    if (vlayout == 2) {
                        ky = this.yo + ry + rowh - kh;
                    }
                }
                kid.setBounds((double)((int)kx), (double)((int)ky), (double)((int)kw), (double)((int)kh));
                cx += aCw + hgap;
            }
            ry += aRh + vgap;
        }
    }

    public void paint(Graphics g) {
        double vgap = this.getRowGap();
        double w = this.getWidth();
        if (this.getColorRows()) {
            g.setBrush(this.getBandBrush());
            double vgapHalf = vgap / 2.0;
            double ry = this.yo;
            int remainder = this.getColorEvenRows() ? 1 : 0;
            for (int r = 0; r < this.rh.length; ++r) {
                if (r % 2 == remainder) {
                    g.fillRect(0.0, ry - vgapHalf, w, this.rh[r] + vgap);
                }
                ry += this.rh[r] + vgap;
            }
        }
        super.paint(g);
    }

    public void changed(Property prop, Context context) {
        this.relayout();
    }

    public BIcon getIcon() {
        return icon;
    }

    public static class ColumnSupport {
        private double[] cw;
        private Array<BCoordinatedGridPane> panes = new Array(BCoordinatedGridPane.class);

        public ColumnSupport(BCoordinatedGridPane pane) {
            this.panes.add((Object)pane);
        }

        public void addPane(BCoordinatedGridPane pane) {
            if (!this.panes.contains((Object)pane)) {
                this.panes.add((Object)pane);
            }
        }

        public void removePane(BCoordinatedGridPane pane) {
            this.panes.remove((Object)pane);
        }

        public int getColumnCount() {
            BCoordinatedGridPane rootPane = (BCoordinatedGridPane)((Object)this.panes.get(0));
            return rootPane.getColumnCount();
        }

        public double getColumnGap() {
            BCoordinatedGridPane rootPane = (BCoordinatedGridPane)((Object)this.panes.get(0));
            return rootPane.getColumnGap();
        }

        public int getStretchColumn() {
            BCoordinatedGridPane rootPane = (BCoordinatedGridPane)((Object)this.panes.get(0));
            return rootPane.getStretchColumn();
        }

        public boolean getUniformColumnWidth() {
            BCoordinatedGridPane rootPane = (BCoordinatedGridPane)((Object)this.panes.get(0));
            return rootPane.getUniformColumnWidth();
        }

        public double[] computeColumnWidths(BCoordinatedGridPane computeFor) {
            BCoordinatedGridPane rootPane = (BCoordinatedGridPane)((Object)this.panes.get(0));
            if (computeFor == rootPane) {
                int i;
                int ncols = rootPane.getColumnCount();
                if (ncols < 0) {
                    ncols = 1;
                }
                this.cw = new double[ncols];
                for (i = 0; i < ncols; ++i) {
                    this.cw[i] = 0.0;
                }
                for (i = 0; i < this.panes.size(); ++i) {
                    this.cw = ((BCoordinatedGridPane)((Object)this.panes.get(i))).computeColumnWidths(this.cw);
                }
                if (rootPane.getUniformColumnWidth()) {
                    double maxw = 0.0;
                    for (double aCw : this.cw) {
                        maxw = Math.max(aCw, maxw);
                    }
                    for (int i2 = 0; i2 < this.cw.length; ++i2) {
                        this.cw[i2] = maxw;
                    }
                }
            }
            return this.cw;
        }
    }
}

