/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.DialogCommand;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;

public class BCommandDialog
extends BDialog {
    public static final Topic buttonPressed = BCommandDialog.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BCommandDialog.class);
    private DialogCommand[] commands;
    private BButton[] buttons;
    private DialogCommand closingCommand = null;
    public static final int CLOSE = 16;

    public void fireButtonPressed(BValue event) {
        this.fire(buttonPressed, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BCommandDialog(BWidget owner, String title, boolean modal, BWidget content, DialogCommand[] commands, BImage icon) {
        this(owner, title, modal, content, commands, icon, null, null);
    }

    protected BCommandDialog(BWidget owner, String title, boolean modal, BWidget content, DialogCommand[] commands, BImage icon, BInsets buttonInsets, BInsets contentInsets) {
        super(owner, title, modal);
        BWidget contentWithIcon = content;
        if (icon != null) {
            contentWithIcon = new BEdgePane(null, null, (BWidget)new BLabel(icon), null, content);
        }
        BGridPane buttonPane = new BGridPane(commands.length);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.setColumnAlign(BHalign.fill);
        this.commands = commands;
        BButton def = null;
        this.buttons = new BButton[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            commands[i].setDialog(this);
            this.buttons[i] = new BButton((Command)commands[i]);
            buttonPane.add("button?", (BValue)this.buttons[i]);
            this.linkTo("lkButton?", (BComponent)this.buttons[i], (Slot)BButton.actionPerformed, (Slot)buttonPressed);
            if (commands[i].getResult() == 1) {
                def = this.buttons[i];
                continue;
            }
            if (def == null && commands[i].getResult() == 16) {
                def = this.buttons[i];
                continue;
            }
            if (def != null || commands[i].getResult() != 2) continue;
            def = this.buttons[i];
        }
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, buttonInsets != null ? buttonInsets : BInsets.make((double)0.0, (double)4.0, (double)4.0, (double)4.0)), null, null, (BWidget)new BBorderPane(contentWithIcon, contentInsets != null ? contentInsets : BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0))));
        if (def != null) {
            this.setDefaultButton(def);
        }
    }

    public BCommandDialog() {
    }

    public static int open(BWidget parent, String title, Object content, int buttons) {
        return BCommandDialog.open(parent, title, content, DialogCommand.make(parent, buttons));
    }

    public static int open(BWidget parent, String title, Object content, DialogCommand[] commands) {
        return BCommandDialog.open(parent, title, content, commands, null, null, null);
    }

    public static int open(BWidget parent, String title, Object content, int buttons, BImage icon) {
        return BCommandDialog.open(parent, title, content, DialogCommand.make(parent, buttons), icon, null, null);
    }

    public static int open(BWidget parent, String title, Object content, DialogCommand[] commands, BImage icon) {
        return BCommandDialog.open(parent, title, content, commands, icon, null, null);
    }

    public static int open(BWidget parent, String title, Object content, DialogCommand[] commands, BImage icon, BInsets buttonInsets, BInsets contentInsets) {
        BWidget w;
        BCommandDialog dialog = BCommandDialog.make(parent, title, true, content, commands, icon, buttonInsets, contentInsets);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        if (content instanceof BWidget && (w = (BWidget)content).getPropertyInParent() != null && w.getParentWidget() != null) {
            BWidget wp = w.getParentWidget();
            wp.set(w.getPropertyInParent(), (BValue)new BNullWidget());
        }
        return dialog.getResult();
    }

    public static BCommandDialog make(BWidget parent, String title, boolean modal, Object content, DialogCommand[] commands, BImage icon) {
        return BCommandDialog.make(parent, title, modal, content, commands, icon, null, null);
    }

    public static BCommandDialog make(BWidget parent, String title, boolean modal, Object content, DialogCommand[] commands, BImage icon, BInsets buttonInsets, BInsets contentInsets) {
        Object c = content instanceof BWidget ? (BWidget)content : new BLabel(String.valueOf(content), BHalign.left);
        return new BCommandDialog(parent, title, modal, (BWidget)c, commands, icon, buttonInsets, contentInsets);
    }

    public int getResult() {
        return this.closingCommand == null ? -1 : this.closingCommand.getResult();
    }

    public void replaceCommand(int index, DialogCommand command) {
        this.commands[index] = command;
        this.buttons[index].setCommand((Command)command, true, false);
        this.commands[index].setDialog(this);
    }

    public void close(DialogCommand closingCommand) {
        this.closingCommand = closingCommand;
        this.close();
    }

    public Command getButtonCommand(int result) {
        for (DialogCommand command : this.commands) {
            if (command.getResult() != result) continue;
            return command;
        }
        return null;
    }

    public void windowClosing(BWindowEvent event) {
        Command c = this.getButtonCommand(2);
        if (c == null) {
            c = this.getButtonCommand(1);
        }
        if (c == null) {
            c = this.getButtonCommand(16);
        }
        if (c == null) {
            c = this.getButtonCommand(8);
        }
        if (c == null) {
            c = this.getButtonCommand(4);
        }
        if (c != null) {
            c.invoke();
        }
    }
}

