/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbShell;

public class BButtonPane
extends BGridPane {
    public static final Property buttonStyle = BButtonPane.newProperty((int)0, (BValue)BButtonStyle.normal, null);
    public static final Type TYPE = Sys.loadType(BButtonPane.class);

    public BButtonStyle getButtonStyle() {
        return (BButtonStyle)this.get(buttonStyle);
    }

    public void setButtonStyle(BButtonStyle v) {
        this.set(buttonStyle, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BButtonPane() {
        super(0);
        this.setUniformColumnWidth(true);
        this.setColumnAlign(BHalign.fill);
    }

    public BButtonPane(Command[] commands) {
        this(BButtonStyle.normal, commands, true, true);
    }

    public BButtonPane(Command[] commands, boolean useLabel, boolean useIcon) {
        this(BButtonStyle.normal, commands, useLabel, useIcon);
    }

    public BButtonPane(BButtonStyle buttonStyle, Command[] commands, boolean useLabel, boolean useIcon) {
        this();
        this.setButtonStyle(buttonStyle);
        for (int i = 0; i < commands.length; ++i) {
            this.add(commands[i], useLabel, useIcon);
        }
    }

    public void add(Command command) {
        this.add(command, true, true);
    }

    public void add(Command command, boolean useLabel, boolean useIcon) {
        this.setColumnCount(this.getColumnCount() + 1);
        BAbstractButton button = BAbstractButton.make((Command)command, (boolean)useLabel, (boolean)useIcon);
        if (this.getButtonStyle() != BButtonStyle.normal) {
            button.setButtonStyle(this.getButtonStyle());
        }
        this.add(null, (BValue)button);
    }

    public void add(BWidget toAdd) {
        this.setColumnCount(this.getColumnCount() + 1);
        this.add(null, (BValue)toAdd);
    }

    public void addWorkbenchButtons(BWidget owner) {
        BWbShell shell = BWbShell.getWbShell((BWidget)owner);
        if (shell != null) {
            this.add(shell.getRefreshCommand(), true, true);
            this.add(shell.getSaveCommand(), true, true);
        }
    }

    public static BButtonPane makeWorkbenchButtonPane(BWidget owner) {
        BWbShell shell = BWbShell.getWbShell((BWidget)owner);
        if (shell == null) {
            return null;
        }
        return new BButtonPane(new Command[]{shell.getRefreshCommand(), shell.getSaveCommand()}, true, true);
    }
}

