/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import com.tridium.platform.ui.tcpip.BTcpIpHostEditor;
import com.tridium.platform.ui.util.AuditUtil;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.workbench.shell.BNiagaraWbWebShell;
import java.util.logging.Level;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platform:TcpIpPlatformService"}, requiredPermissions="W")})
public class BTcpIpPlatformServicePlugin
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BTcpIpPlatformServicePlugin.class);
    private AuditUtil.ViewAuditCommand auditCommand;
    private BTcpIpHostEditor hostEditor;
    private BScrollPane scrollpane;

    public Type getType() {
        return TYPE;
    }

    public BTcpIpPlatformServicePlugin() {
        this.autoRegisterForComponentEvents = false;
        this.hostEditor = new BTcpIpHostEditor();
        this.scrollpane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.hostEditor, 10.0, 10.0, 10.0, 10.0));
        this.linkTo(null, (BComponent)this.hostEditor, (Slot)BTcpIpHostEditor.pluginModified, (Slot)setModified);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        boolean readonly;
        BTcpIpPlatformService service = (BTcpIpPlatformService)value;
        service.poll();
        try {
            this.registerForComponentEvents((BComponent)service, 4);
        }
        catch (Throwable t) {
            BPlatform.log.log(Level.WARNING, "exception occurred registering for component events", t);
        }
        BTcpIpHostSettings hostSettings = service.getSettings();
        hostSettings.lease(4);
        hostSettings.getComponentSpace().sync();
        this.hostEditor.loadValue((BObject)hostSettings);
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            BButtonPane buttons = new BButtonPane();
            buttons.add(shell.getRefreshCommand(), true, true);
            buttons.add(shell.getSaveCommand(), true, true);
            if (!(shell instanceof BNiagaraWbWebShell)) {
                this.auditCommand = new AuditUtil.ViewAuditCommand("ipchanges", (BWidget)this);
                buttons.add(this.auditCommand, true, true);
                this.auditCommand.setEnabled(!this.isReadonly() && this.auditCommand.auditFileExists());
            }
            this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttons, 5.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.scrollpane, BBorder.none, BInsets.DEFAULT))));
        } else {
            this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)new BBorderPane((BWidget)this.scrollpane, BBorder.none, BInsets.DEFAULT)));
        }
        BSystemPlatformService sys = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)service);
        sys.lease();
        boolean bl = readonly = service.getSettings().getIsReadonly() || this.isReadonly();
        if (this.isReadonly() == readonly) {
            this.doSetReadonly(readonly);
        } else {
            this.setReadonly(readonly);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        BTcpIpPlatformService service = (BTcpIpPlatformService)value;
        if (service.getSettings().getIsReadonly()) {
            return value;
        }
        BTcpIpHostSettings oldSettings = (BTcpIpHostSettings)service.getSettings().newCopy();
        BTcpIpHostSettings newSettings = (BTcpIpHostSettings)this.hostEditor.saveValue(cx);
        BWbShell shell = this.getWbShell();
        if (shell != null && !(shell instanceof BNiagaraWbWebShell)) {
            AuditUtil.audit("ipchanges", service.getHost(), TYPE, (BComponent)oldSettings, (BComponent)newSettings);
        }
        BSystemPlatformService system = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)service);
        system.poll();
        system.lease();
        if (!service.getSettings().getIsReadonly()) {
            service.savePlatformServiceProperties();
            if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("TcpIpPlatformServicePlugin.reboot.dlgTitle"), (Object)this.getLexicon().getText("TcpIpPlatformServicePlugin.reboot.dlgMessage"), (int)12)) {
                system.reboot();
            }
            if (this.auditCommand != null) {
                this.auditCommand.setEnabled(!this.isReadonly() && this.auditCommand.auditFileExists());
            }
        }
        return value;
    }

    protected void doSetReadonly(boolean readonly) {
        this.hostEditor.setReadonly(readonly);
        if (this.auditCommand != null) {
            this.auditCommand.setEnabled(!readonly && this.auditCommand.auditFileExists());
        }
    }

    public final void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BTcpIpHostSettings || evt.getSourceComponent() instanceof BTcpIpAdapterSettings) {
            this.hostEditor.handleComponentEvent(evt);
        } else {
            super.handleComponentEvent(evt);
        }
    }
}

